PrefabFiles = {
	"lyrica",
	"lyrica_none",
	"lyrica_hat",
	"lyrica_keyboard"
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/lyrica.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/lyrica.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/lyrica.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/lyrica.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/lyrica_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/lyrica_silho.xml" ),

    Asset( "IMAGE", "bigportraits/lyrica.tex" ),
    Asset( "ATLAS", "bigportraits/lyrica.xml" ),
	
	Asset( "IMAGE", "images/map_icons/lyrica.tex" ),
	Asset( "ATLAS", "images/map_icons/lyrica.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_lyrica.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_lyrica.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_lyrica.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_lyrica.xml" ),
	
	Asset( "IMAGE", "images/avatars/self_inspect_lyrica.tex" ),
    Asset( "ATLAS", "images/avatars/self_inspect_lyrica.xml" ),

	Asset( "IMAGE", "images/names_lyrica.tex" ),
    Asset( "ATLAS", "images/names_lyrica.xml" ),
	
	Asset( "IMAGE", "bigportraits/lyrica_none.tex" ),
    Asset( "ATLAS", "bigportraits/lyrica_none.xml" ),

	Asset( "IMAGE", "images/inventoryimages/lyrica_hat.tex" ),
	Asset( "ATLAS", "images/inventoryimages/lyrica_hat.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/lyrica_keyboard.tex" ),
	Asset( "ATLAS", "images/inventoryimages/lyrica_keyboard.xml" ),
}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

-- get language config
local LYRICALANG = GetModConfigData("lyrica_lang")


if LYRICALANG == "chinese" then
	-- Chinese
	STRINGS.CHARACTER_TITLES.lyrica = "骚灵键盘手"
	STRINGS.CHARACTER_NAMES.lyrica = "莉莉卡"
	STRINGS.CHARACTER_DESCRIPTIONS.lyrica = "*键盘手\n*治愈音效\n*无惧黑暗"
	STRINGS.CHARACTER_QUOTES.lyrica = "\"来点音乐\""

	STRINGS.NAMES.LYRICA_HAT = "莉莉卡的帽子"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.LYRICA_HAT = "莉莉卡的最爱!"

	STRINGS.NAMES.LYRICA_KEYBOARD = "莉莉卡的键盘"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.LYRICA_KEYBOARD = "幽灵键盘."
	
	STRINGS.CHARACTERS.LYRICA = require "speech_lyrica_chinese"

	STRINGS.NAMES.LYRICA = "莉莉卡"

	STRINGS.CHARACTERS.GENERIC.DESCRIBE.LYRICA = 
	{
		GENERIC = "骚灵键盘手, 莉莉卡",
		ATTACKER = "危险的键盘手.",
		MURDERER = "凶手!",
		REVIVER = "是骚灵救了我.",
		GHOST = "莉莉卡需要帮助.",
	}
	
	-- speech out speech file
	TUNING.KEYBOARD_ONEQUIP = "我不喜欢这声音."
	TUNING.KEYBOARD_AURA = "噢，感受这治愈的节奏."
	TUNING.KEYBOARD_RUNOUT = "我需要梦魇燃料来加大音量."

else
	-- The character select screen lines
	STRINGS.CHARACTER_TITLES.lyrica = "Poltergeist Keyboardist"
	STRINGS.CHARACTER_NAMES.lyrica = "Lyrica"
	STRINGS.CHARACTER_DESCRIPTIONS.lyrica = "*Keyboardist\n*Healing Beat\n*Unafraid Dark"
	STRINGS.CHARACTER_QUOTES.lyrica = "\"Let's play music\""

	-- Lyrica hat
	STRINGS.NAMES.LYRICA_HAT = "Lyrica's lovely hat"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.LYRICA_HAT = "Love it!"

	-- Lyrica keyboard
	STRINGS.NAMES.LYRICA_KEYBOARD = "Lyrica's keyboard"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.LYRICA_KEYBOARD = "Unrealistic keyboard."
	
	-- Custom speech strings
	STRINGS.CHARACTERS.LYRICA = require "speech_lyrica_chinese"
	
	-- The character's name as appears in-game 
	STRINGS.NAMES.LYRICA = "Lyrica"

	-- The default responses of examining the character
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.LYRICA = 
	{
		GENERIC = "Poltergeist Lyrica",
		ATTACKER = "Dangerous keyboard.",
		MURDERER = "Murderer!",
		REVIVER = "Lyrica, friend of ghost.",
		GHOST = "Lyrica needs help.",
	}
	
	TUNING.KEYBOARD_ONEQUIP = "I don't like this sound."
	TUNING.KEYBOARD_AURA = "Oh, feel that healing beat."
	TUNING.KEYBOARD_RUNOUT = "I need nightmare fuel to amplify it up."
end


AddMinimapAtlas("images/map_icons/lyrica.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("lyrica", "FEMALE")

