local assets=
{ 
    Asset("ANIM", "anim/lyrica_hat.zip"),
    Asset("ANIM", "anim/lyrica_hat_swap.zip"), 

    Asset("ATLAS", "images/inventoryimages/lyrica_hat.xml"),
    Asset("IMAGE", "images/inventoryimages/lyrica_hat.tex"),
}

local prefabs = 
{
}


local function OnEquip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_hat", "lyrica_hat_swap", "swap_hat")
    owner.AnimState:Show("HAT")
    owner.AnimState:Show("HAT_HAIR")
		
end

local function OnUnequip(inst, owner) 
	owner.AnimState:ClearOverrideSymbol("swap_hat")
    owner.AnimState:Hide("HAT")
    owner.AnimState:Hide("HAT_HAIR")
    owner.AnimState:Show("HAIR_NOHAT")
    owner.AnimState:Show("HAIR")

end

local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	inst.entity:AddNetwork()
	
	inst:AddTag("hat")
	inst:AddTag("lyrica_hat")
    
    anim:SetBank("lyrica_hat")
    anim:SetBuild("lyrica_hat")
    anim:PlayAnimation("idle")
	
	inst.entity:SetPristine()
	
	if not TheWorld.ismastersim then
        return inst
    end

    -----------------------------------

	inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/lyrica_hat.xml"
    
	inst:AddComponent("armor")
	inst.components.armor:InitCondition(6666666666, .3)

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	inst.components.equippable.dapperness = TUNING.DAPPERNESS_SMALL
	
	inst:AddComponent("waterproofer")
	inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL)
	
	inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)

    return inst
end

return  Prefab("common/inventory/lyrica_hat", fn, assets, prefabs)