local assets =
{
    Asset("ANIM", "anim/lyrica_keyboard.zip"),
	Asset("ANIM", "anim/swap_lyrica_keyboard.zip"),
	Asset("SOUND", "sound/sanity.fsb"),
	Asset("SOUND", "sound/chess.fsb"),
}



local function set_keyboard_damage(inst, owner)
	local damage = 20 + (owner.components.sanity.current * .3)
	inst.components.weapon:SetDamage(damage)
end

-- on attack function
local function hit_keyboard(inst, attacker, target)
	attacker.components.hunger:DoDelta(-0.33);
	
	attacker.SoundEmitter:PlaySound("dontstarve/wilson/onemanband")
	inst.SoundEmitter:PlaySound("dontstarve/wilson/onemanband")
	
	local pos = attacker:GetPosition()
    local range = 15

	local ents = TheSim:FindEntities(pos.x, pos.y, pos.z, range)
	
	for i, v in ipairs(ents) do
		if v~=attacker and v:HasTag("player") then
			v.components.sanity:DoDelta(-0.33)
		end
	end
end

local function keyboard_aura(inst)
	local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
	owner.SoundEmitter:PlaySound("dontstarve/wilson/onemanband")
	
	if owner then
		local x,y,z = owner.Transform:GetWorldPosition()
		local range = 15
		local ents = TheSim:FindEntities(x,y,z, range)
		local rate = .01 * owner.components.health.maxhealth
		owner.components.health:DoDelta(rate)
		for i,v in ipairs(ents) do
			if not TheNet:GetPVPEnabled() and v:HasTag("player") and v ~= owner then
				rate = .01 * v.components.health.maxhealth
				v.components.health:DoDelta(rate)
			end
		end
		for v in pairs(owner.components.leader.followers) do
			rate = .01 * v.components.health.maxhealth
			v.components.health:DoDelta(rate)
		end
	end
end

local function keyboard_enable(inst)
	local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
	if not inst.components.fueled:IsEmpty() then
        if inst.components.fueled then
            inst.components.fueled:StartConsuming()        
        end
		inst.isplaying = true
		inst.task = inst:DoPeriodicTask(1, keyboard_aura)
		owner.components.talker:Say(TUNING.KEYBOARD_AURA, 2.5, true)
	end
end

local function keyboard_disable(inst)
	if inst.components.fueled then
        inst.components.fueled:StopConsuming()        
    end
	if inst.task then
		inst.task:Cancel()
		inst.task = nil
	end
	inst.isplaying = false
end

local function keyboard_switch(inst)
	if inst.isplaying then
		keyboard_disable(inst)
		inst.isplaying = false
	else
		keyboard_enable(inst)
		inst.isplaying = true
	end
	inst.components.useableitem.inuse = false
end

local function OnLoad(inst, data)
    if data.isplaying then
		keyboard_enable(inst)
    else
		keyboard_disable(inst)
    end
end

local function keyboard_runout(inst)
	local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
	owner.components.talker:Say(TUNING.KEYBOARD_RUNOUT, 3.5, true)
	keyboard_disable(inst)
end

local function OnEquip(inst, owner)
	owner:ListenForEvent("sanitydelta", 
	function() 
		set_keyboard_damage(inst, owner) 
	end)
	
    owner.AnimState:OverrideSymbol("swap_object", "swap_lyrica_keyboard", "swap_lyrica_keyboard")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
	
	owner.SoundEmitter:PlaySound("dontstarve/sanity/shadowhand_creep", "using")
	if not owner:HasTag("poltergeist") then
		owner.SoundEmitter:SetVolume("using", 1)
		inst.components.equippable.dapperness = -TUNING.DAPPERNESS_LARGE
		if not owner:HasTag("mime") then
			owner.components.talker:Say(TUNING.KEYBOARD_ONEQUIP, 2.5, true)
		end
	else
		owner.SoundEmitter:SetVolume("using", 0)
		inst.components.equippable.dapperness = 0
	end
end

local function OnUnequip(inst, owner)
	owner.SoundEmitter:KillSound("using")
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
	keyboard_disable(inst)
end

local function fn(Sim)
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("lyrica_keyboard")
    inst.AnimState:SetBuild("lyrica_keyboard")
    inst.AnimState:PlayAnimation("idle")
	
	inst:AddTag("keyboard")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    -----------------------------------

    inst:AddComponent("inspectable")
	
	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(20)
	inst.components.weapon:SetRange(1.35)
    inst.components.weapon:SetOnAttack(hit_keyboard)

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/lyrica_keyboard.xml"
	
	inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
	
	-- arua healing
	inst:AddComponent("fueled")
	inst.components.fueled:SetDepletedFn(keyboard_runout)
	inst.components.fueled.maxfuel = 60
	inst.components.fueled.accepting = true
	inst.components.fueled.fueltype = FUELTYPE.NIGHTMARE
	inst.components.fueled:InitializeFuelLevel(60)
	
	-- 开/关
	inst:AddComponent("useableitem")
    inst.components.useableitem:SetOnUseFn(keyboard_switch)
	
	inst.OnLoad = OnLoad
	
    return inst
end

return Prefab("common/inventory/lyrica_keyboard", fn, assets)

