local assets=
{
	Asset("ANIM", "anim/skinmod_bluestaff.zip"),
	Asset("ANIM", "anim/skinmod_bluestaff_swap.zip"), 
	Asset("ATLAS", "images/inventoryimages/skinmod_bluestaff.xml"),
}

local prefabs = 
{
    "ice_projectile",
}

---------BLUE STAFF---------

local function onattack_blue(inst, attacker, target)
    if attacker and attacker.components.sanity then
        attacker.components.sanity:DoDelta(-TUNING.SANITY_SUPERTINY)
    end

    if not target:IsValid() then
        --target killed or removed in combat damage phase
        return
    end
    
    if target.components.sleeper and target.components.sleeper:IsAsleep() then
        target.components.sleeper:WakeUp()
    end
	
	if IsDLCEnabled(REIGN_OF_GIANTS) then --rog
		if target.components.burnable then
			if target.components.burnable:IsBurning() then
				target.components.burnable:Extinguish()
			elseif target.components.burnable:IsSmoldering() then
				target.components.burnable:SmotherSmolder()
			end
		end
	elseif not SaveGameIndex:IsModeShipwrecked() then --ds
		if target.components.burnable and target.components.burnable:IsBurning() then
			target.components.burnable:Extinguish()
		end
	elseif SaveGameIndex:IsModeShipwrecked() then --sw
		if target.components.burnable then
			if target.components.burnable:IsBurning() then
				target.components.burnable:Extinguish()
			elseif target.components.burnable:IsSmoldering() then
				target.components.burnable:SmotherSmolder()
			end
		end
	end

    if target.sg ~= nil and not target.sg:HasStateTag("frozen") then
        target:PushEvent("attacked", { attacker = attacker, damage = 0 })
    end

    if target.components.freezable then
        target.components.freezable:AddColdness(1)
        target.components.freezable:SpawnShatterFX()
    end
end

---------COMMON FUNCTIONS---------

local function onfinished(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/gem_shatter")
    inst:Remove()
end

local function unimplementeditem(inst)
    local player = GetPlayer()
    player.components.talker:Say(GetString(player.prefab, "ANNOUNCE_UNIMPLEMENTED"))
    if player.components.health.currenthealth > 1 then
        player.components.health:DoDelta(-player.components.health.currenthealth * 0.5)
    end

    if inst.components.useableitem then
        inst.components.useableitem:StopUsingItem()
    end
end

local function commonfn(colour)

    local onequip = function(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_object", "skinmod_bluestaff_swap", "bluestaff_skin")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
    end

    local onunequip = function(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
	
	if SaveGameIndex:IsModeShipwrecked() then --sw
		MakeInventoryFloatable(inst, "bluestaff_water", "bluestaff")
    end
	
    anim:SetBank("skinmod_bluestaff")
    anim:SetBuild("skinmod_bluestaff")
    anim:PlayAnimation("bluestaff")
    -------   
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetOnFinished( onfinished )

    inst:AddComponent("inspectable")
    inst:AddComponent("tradable")
    
    inst:AddComponent("inventoryitem")
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )


    
    return inst
end


---------COLOUR SPECIFIC CONSTRUCTIONS---------

local function blue()
    local inst = commonfn("blue")
    
    inst:AddTag("icestaff")
    inst:AddTag("extinguisher")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(0)
    inst.components.weapon:SetRange(8, 10)
    inst.components.weapon:SetOnAttack(onattack_blue)
    inst.components.weapon:SetProjectile("ice_projectile")

    inst.components.finiteuses:SetMaxUses(TUNING.ICESTAFF_USES)
    inst.components.finiteuses:SetUses(TUNING.ICESTAFF_USES)
    
	inst.components.inventoryitem.atlasname = "images/inventoryimages/skinmod_bluestaff.xml"
	
    return inst
end

return Prefab( "common/inventory/skinmod_bluestaff", blue, assets, prefabs)
