local Assets =
{
	Asset("ANIM", "anim/skinmod_flowerhat_xmas_c.zip"),
	Asset("ATLAS", "images/inventoryimages/skinmod_flowerhat_xmas_c.xml"),
}

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_hat", "skinmod_flowerhat_xmas_c", "swap_hat")
	owner.AnimState:Show("HAT")
	owner.AnimState:Show("HAT_HAIR")
	owner.AnimState:Hide("HAIR_NOHAT")
	owner.AnimState:Hide("HAIR")

	if owner:HasTag("player") then
		owner.AnimState:Hide("HEAD")
		owner.AnimState:Show("HEAD_HAIR")
	end
	
	if inst.components.fueled then
		inst.components.fueled:StartConsuming()
	end
end

local function onunequip(inst, owner)
	owner.AnimState:Hide("HAT")
	owner.AnimState:Hide("HAT_HAIR")
	owner.AnimState:Show("HAIR_NOHAT")
	owner.AnimState:Show("HAIR")
	
	if owner:HasTag("player") then
		owner.AnimState:Show("HEAD")
		owner.AnimState:Hide("HEAD_HAIR")
	end
	
	if inst.components.fueled then
		inst.components.fueled:StopConsuming()        
	end
end

local function opentop_onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_hat", "skinmod_flowerhat_xmas_c", "swap_hat")
	owner.AnimState:Show("HAT")
	owner.AnimState:Hide("HAT_HAIR")
	owner.AnimState:Show("HAIR_NOHAT")
	owner.AnimState:Show("HAIR")
	
	owner.AnimState:Show("HEAD")
	owner.AnimState:Hide("HEAD_HAIR")
	
	if inst.components.fueled then
	inst.components.fueled:StartConsuming()        
	end
end

local function generic_perish(inst)
	inst:Remove()
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	
    MakeInventoryPhysics(inst)
	
    inst.AnimState:SetBank("skinmod_flowerhat_xmas_c")
    inst.AnimState:SetBuild("skinmod_flowerhat_xmas_c")
    inst.AnimState:PlayAnimation("anim")
    
	inst:AddTag("hat")
	
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
	inst:AddComponent("equippable")
	
	inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	inst.components.equippable:SetOnEquip( onequip )
	inst.components.equippable:SetOnUnequip( onunequip )
	
	inst.components.equippable.dapperness = TUNING.DAPPERNESS_TINY
	
	inst:AddTag("show_spoilage")
	
	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_FAST)
	inst.components.perishable:StartPerishing()
	inst.components.perishable:SetOnPerishFn(generic_perish)
	inst.components.equippable:SetOnEquip( opentop_onequip )
	
	if IsDLCEnabled(REIGN_OF_GIANTS) then --rog
	elseif not SaveGameIndex:IsModeShipwrecked() then --ds
	elseif SaveGameIndex:IsModeShipwrecked() then --sw
		MakeInventoryFloatable(inst, "idle_water", "anim")
	end
	
	inst.components.inventoryitem.atlasname = "images/inventoryimages/skinmod_flowerhat_xmas_c.xml"
	
	return inst
end

return Prefab("common/inventory/skinmod_flowerhat_xmas_c", fn, Assets)
