local assets= --From DS
{
	Asset("ANIM", "anim/skinmod_grassarmor_speed.zip"),
	Asset("ATLAS", "images/inventoryimages/skinmod_grassarmor_speed.xml"),
}

local function OnBlocked(owner) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour") 
end


local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "skinmod_grassarmor_speed", "swap_body")
    inst:ListenForEvent("blocked", OnBlocked, owner)
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
    inst:RemoveEventCallback("blocked", OnBlocked, owner)
end

local function fn(Sim)
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("skinmod_grassarmor_speed")
    inst.AnimState:SetBuild("skinmod_grassarmor_speed")
    inst.AnimState:PlayAnimation("anim")
    
    inst:AddTag("grass")
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/grassarmour"

    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.LARGE_FUEL
    
	if IsDLCEnabled(REIGN_OF_GIANTS) then --rog
		MakeSmallBurnable(inst, TUNING.SMALL_BURNTIME)
		MakeSmallPropagator(inst)
		inst.components.burnable:MakeDragonflyBait(3)
	elseif not SaveGameIndex:IsModeShipwrecked() then --ds
	elseif SaveGameIndex:IsModeShipwrecked() then --sw
		MakeInventoryFloatable(inst, "idle_water", "anim")
		
		inst:AddComponent("appeasement")
		inst.components.appeasement.appeasementvalue = TUNING.WRATH_SMALL
		
		MakeSmallBurnable(inst, TUNING.SMALL_BURNTIME)
		MakeSmallPropagator(inst)
		inst.components.burnable:MakeDragonflyBait(3)
	end
	
    inst:AddComponent("armor")
    inst.components.armor:InitCondition(TUNING.ARMORGRASS, TUNING.ARMORGRASS_ABSORPTION)
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
    
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
	inst.components.inventoryitem.atlasname = "images/inventoryimages/skinmod_grassarmor_speed.xml"
	
    return inst
end


return Prefab( "common/inventory/skinmod_grassarmor_speed", fn, assets) 
