local assets= --From DS
{
    Asset("ANIM", "anim/skinmod_hambat.zip"),
    Asset("ANIM", "anim/skinmod_hambat_swap.zip"),
	Asset("ATLAS", "images/inventoryimages/skinmod_hambat.xml"),
}

--[[
if IsDLCEnabled(REIGN_OF_GIANTS) or SaveGameIndex:IsModeShipwrecked() then --rog/sw
	local function UpdateDamage(inst)
		if inst.components.perishable and inst.components.weapon then
			local dmg = TUNING.HAMBAT_DAMAGE * inst.components.perishable:GetPercent()
			dmg = Remap(dmg, 0, TUNING.HAMBAT_DAMAGE, TUNING.HAMBAT_MIN_DAMAGE_MODIFIER*TUNING.HAMBAT_DAMAGE, TUNING.HAMBAT_DAMAGE)
			inst.components.weapon:SetDamage(dmg)
		end
	end
	
	local function OnLoad(inst, data)
		UpdateDamage(inst)
	end
end
]]

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "skinmod_hambat_swap", "swap_ham_bat")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end


local function fn(Sim)
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
	if SaveGameIndex:IsModeShipwrecked() then --sw
		MakeInventoryFloatable(inst, "idle_water", "idle")
	end
	
    anim:SetBank("skinmod_hambat")
    anim:SetBuild("skinmod_hambat")
    anim:PlayAnimation("idle")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.HAMBAT_DAMAGE)
    
	if IsDLCEnabled(REIGN_OF_GIANTS) or SaveGameIndex:IsModeShipwrecked() then --rog/sw
		local function UpdateDamage(inst)
			if inst.components.perishable and inst.components.weapon then
				local dmg = TUNING.HAMBAT_DAMAGE * inst.components.perishable:GetPercent()
				dmg = Remap(dmg, 0, TUNING.HAMBAT_DAMAGE, TUNING.HAMBAT_MIN_DAMAGE_MODIFIER*TUNING.HAMBAT_DAMAGE, TUNING.HAMBAT_DAMAGE)
				inst.components.weapon:SetDamage(dmg)
			end
		end
		
		local function OnLoad(inst, data)
			UpdateDamage(inst)
		end
		inst.components.weapon:SetOnAttack(UpdateDamage)
		inst.OnLoad = OnLoad
	end
	
    -------
    --[[
    inst:AddComponent("edible")
    inst.components.edible.foodtype = "MEAT"
    inst.components.edible.healthvalue = -TUNING.HEALING_MEDSMALL
    inst.components.edible.hungervalue = TUNING.CALORIES_MED
    inst.components.edible.sanityvalue = -TUNING.SANITY_MED
    --]]
    
    inst:AddTag("show_spoilage")
	
	if IsDLCEnabled(REIGN_OF_GIANTS) or SaveGameIndex:IsModeShipwrecked() then --rog/sw
		inst:AddTag("icebox_valid")
	end

    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
	if SaveGameIndex:IsModeShipwrecked() then --sw
		inst:AddComponent("appeasement")
		inst.components.appeasement.appeasementvalue = TUNING.APPEASEMENT_SMALL
	end
	
	inst.components.inventoryitem.atlasname = "images/inventoryimages/skinmod_hambat.xml"
	
    return inst
end

return Prefab("common/inventory/skinmod_hambat", fn, assets) 
