local assets= --From DS
{
	Asset("ANIM", "anim/skinmod_marblearmor_extra.zip"),
    Asset("INV_IMAGE", "armormarble"),
	Asset("ATLAS", "images/inventoryimages/skinmod_marblearmor_extra.xml"),
}

local function OnBlocked(owner) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_marble")
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "skinmod_marblearmor_extra", "swap_body")
    inst:ListenForEvent("blocked", OnBlocked, owner)
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
    inst:RemoveEventCallback("blocked", OnBlocked, owner)
end

local function fn()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("skinmod_marblearmor_extra")
    inst.AnimState:SetBuild("skinmod_marblearmor_extra")
    inst.AnimState:PlayAnimation("anim")
	
	if SaveGameIndex:IsModeShipwrecked() then --sw
		MakeInventoryFloatable(inst, "idle_water", "anim")
    end
	
    inst:AddTag("marble")
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/marblearmour"
    
    inst:AddComponent("armor")
    inst.components.armor:InitCondition(TUNING.ARMORMARBLE, TUNING.ARMORMARBLE_ABSORPTION)
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
    inst.components.equippable.walkspeedmult = TUNING.ARMORMARBLE_SLOW
    
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
	inst.components.inventoryitem.atlasname = "images/inventoryimages/skinmod_marblearmor_extra.xml"
    
    return inst
end

return Prefab( "common/inventory/skinmod_marblearmor_extra", fn, assets) 
