local Assets =
{
	Asset("ANIM", "anim/skinmod_minerhat.zip"),
	Asset("ANIM", "anim/skinmod_minerhat_off.zip"),
	Asset("ATLAS", "images/inventoryimages/skinmod_minerhat.xml"),
}

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_hat", "skinmod_minerhat", "swap_hat")
	owner.AnimState:Show("HAT")
	owner.AnimState:Show("HAT_HAIR")
	owner.AnimState:Hide("HAIR_NOHAT")
	owner.AnimState:Hide("HAIR")

	if owner:HasTag("player") then
		owner.AnimState:Hide("HEAD")
		owner.AnimState:Show("HEAD_HAIR")
	end
	
	if inst.components.fueled then
		inst.components.fueled:StartConsuming()
	end
end

local function onunequip(inst, owner)
	owner.AnimState:Hide("HAT")
	owner.AnimState:Hide("HAT_HAIR")
	owner.AnimState:Show("HAIR_NOHAT")
	owner.AnimState:Show("HAIR")
	
	if owner:HasTag("player") then
		owner.AnimState:Show("HEAD")
		owner.AnimState:Hide("HEAD_HAIR")
	end
	
	if inst.components.fueled then
		inst.components.fueled:StopConsuming()        
	end
end

local function opentop_onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_hat", skinmod_minerhat, "swap_hat")
	owner.AnimState:Show("HAT")
	owner.AnimState:Hide("HAT_HAIR")
	owner.AnimState:Show("HAIR_NOHAT")
	owner.AnimState:Show("HAIR")
	
	owner.AnimState:Show("HEAD")
	owner.AnimState:Hide("HEAD_HAIR")
	
	if inst.components.fueled then
	inst.components.fueled:StartConsuming()        
	end
end

local function miner_turnon(inst)
	local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
	if inst.components.fueled:IsEmpty() then
		if owner then
			onequip(inst, owner, "anim/skinmod_minerhat_off")
			
			owner.AnimState:OverrideSymbol("swap_hat", "skinmod_minerhat_off", "swap_hat")--learn from musha
			owner.AnimState:Show("HAT")
			owner.AnimState:Show("HAT_HAIR")
			owner.AnimState:Hide("HAIR_NOHAT")
			owner.AnimState:Hide("HAIR")
		end
	else
		if owner then
			onequip(inst, owner)
		end
		
		inst.components.fueled:StartConsuming()
		inst.SoundEmitter:PlaySound("dontstarve/common/minerhatAddFuel")
		inst.Light:Enable(true)
	end
end

local function miner_turnoff(inst, ranout)
	if inst.components.equippable and inst.components.equippable:IsEquipped() then
		local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
		if owner then
			onequip(inst, owner, "anim/skinmod_minerhat_off")
			
			owner.AnimState:OverrideSymbol("swap_hat", "skinmod_minerhat_off", "swap_hat")--learn from musha
			owner.AnimState:Show("HAT")
			owner.AnimState:Show("HAT_HAIR")
			owner.AnimState:Hide("HAIR_NOHAT")
			owner.AnimState:Hide("HAIR")
		end
	end
	inst.components.fueled:StopConsuming()
	inst.SoundEmitter:PlaySound("dontstarve/common/minerhatOut")
	
	inst.Light:Enable(false)
end

local function miner_equip(inst, owner)
	miner_turnon(inst)
end

local function miner_unequip(inst, owner)
	onunequip(inst, owner)
	miner_turnoff(inst)
end

local function miner_perish(inst)
	local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
	if owner then
		owner:PushEvent("torchranout", {torch = inst})
	end
	miner_turnoff(inst)
end

local function miner_drop(inst)
	miner_turnoff(inst)
end

local function miner_takefuel(inst)
	if inst.components.equippable and inst.components.equippable:IsEquipped() then
		miner_turnon(inst)
	end
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	
	inst.entity:AddSoundEmitter()   
	
    MakeInventoryPhysics(inst)
	
    inst.AnimState:SetBank("skinmod_minerhat")
    inst.AnimState:SetBuild("skinmod_minerhat")
    inst.AnimState:PlayAnimation("anim")
    
	inst:AddTag("hat")
	
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
	inst:AddComponent("equippable")
	
	inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	inst.components.equippable:SetOnEquip( onequip )
	inst.components.equippable:SetOnUnequip( onunequip )
	
	local light = inst.entity:AddLight()
	light:SetFalloff(0.4)
	light:SetIntensity(.7)
	light:SetRadius(2.5)
	light:SetColour(180/255, 195/255, 150/255)
	light:Enable(false)
	
	inst.components.inventoryitem:SetOnDroppedFn( miner_drop )
	inst.components.equippable:SetOnEquip( miner_equip )
	inst.components.equippable:SetOnUnequip( miner_unequip )
	
	inst:AddComponent("fueled")
	inst.components.fueled.fueltype = "CAVE"
	inst.components.fueled:InitializeFuelLevel(TUNING.MINERHAT_LIGHTTIME)
	inst.components.fueled:SetDepletedFn(miner_perish)
	inst.components.fueled.ontakefuelfn = miner_takefuel
	inst.components.fueled.accepting = true
	
	if IsDLCEnabled(REIGN_OF_GIANTS) then --rog
		inst:AddComponent("waterproofer")
		inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL)
	elseif not SaveGameIndex:IsModeShipwrecked() then --ds
	elseif SaveGameIndex:IsModeShipwrecked() then --sw
		inst:AddComponent("waterproofer")
		inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL)
		
		MakeInventoryFloatable(inst, "idle_water", "anim")
	end
	
	inst.components.inventoryitem.atlasname = "images/inventoryimages/skinmod_minerhat.xml"
	
	return inst
end

return Prefab("common/inventory/skinmod_minerhat", fn, Assets)
