local Assets =
{
	Asset("ANIM", "anim/skinmod_rainhat.zip"),
	Asset("ATLAS", "images/inventoryimages/skinmod_rainhat.xml"),
}

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_hat", "skinmod_rainhat", "swap_hat")
	owner.AnimState:Show("HAT")
	owner.AnimState:Show("HAT_HAIR")
	owner.AnimState:Hide("HAIR_NOHAT")
	owner.AnimState:Hide("HAIR")

	if owner:HasTag("player") then
		owner.AnimState:Hide("HEAD")
		owner.AnimState:Show("HEAD_HAIR")
	end
	
	if inst.components.fueled then
		inst.components.fueled:StartConsuming()
	end
end

local function onunequip(inst, owner)
	owner.AnimState:Hide("HAT")
	owner.AnimState:Hide("HAT_HAIR")
	owner.AnimState:Show("HAIR_NOHAT")
	owner.AnimState:Show("HAIR")
	
	if owner:HasTag("player") then
		owner.AnimState:Show("HEAD")
		owner.AnimState:Hide("HEAD_HAIR")
	end
	
	if inst.components.fueled then
		inst.components.fueled:StopConsuming()        
	end
end

local function opentop_onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_hat", skinmod_rainhat, "swap_hat")
	owner.AnimState:Show("HAT")
	owner.AnimState:Hide("HAT_HAIR")
	owner.AnimState:Show("HAIR_NOHAT")
	owner.AnimState:Show("HAIR")
	
	owner.AnimState:Show("HEAD")
	owner.AnimState:Hide("HEAD_HAIR")
	
	if inst.components.fueled then
	inst.components.fueled:StartConsuming()        
	end
end

local function generic_perish(inst)
	inst:Remove()
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	
    MakeInventoryPhysics(inst)
	
    inst.AnimState:SetBank("skinmod_rainhat")
    inst.AnimState:SetBuild("skinmod_rainhat")
    inst.AnimState:PlayAnimation("anim")
    
	inst:AddTag("hat")
	
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
	inst:AddComponent("equippable")
	
	inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	inst.components.equippable:SetOnEquip( onequip )
	inst.components.equippable:SetOnUnequip( onunequip )
	
	if SaveGameIndex:IsModeShipwrecked() then --sw
		MakeInventoryFloatable(inst, "idle_water", "anim")
	end
	
	--[[
	if inst.components.moisture or (inst.components.poisonable or SaveGameIndex:IsModeShipwrecked()) then --rog/sw
		inst:AddComponent("waterproofer")
		inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_LARGE)
	end
	]]
	
	if IsDLCEnabled(REIGN_OF_GIANTS) then --rog
		inst:AddComponent("waterproofer")
		inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_LARGE)
	elseif not SaveGameIndex:IsModeShipwrecked() then --ds
	elseif SaveGameIndex:IsModeShipwrecked() then --sw
		inst:AddComponent("waterproofer")
		inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_LARGE)
	end
	
	inst:AddComponent("fueled")
	inst.components.fueled.fueltype = "USAGE"
	
	--[[
	if inst.components.moisture or (inst.components.poisonable or SaveGameIndex:IsModeShipwrecked()) then --rog/sw
		inst.components.fueled:InitializeFuelLevel(TUNING.RAINHAT_PERISHTIME)
	else --ds
		inst.components.fueled:InitializeFuelLevel(TUNING.TOTAL_DAY_TIME*10)
	end
	]]
	
	if IsDLCEnabled(REIGN_OF_GIANTS) then --rog
		inst.components.fueled:InitializeFuelLevel(TUNING.RAINHAT_PERISHTIME)
	elseif not SaveGameIndex:IsModeShipwrecked() then --ds
		inst.components.fueled:InitializeFuelLevel(TUNING.TOTAL_DAY_TIME*10)
	elseif SaveGameIndex:IsModeShipwrecked() then --sw
		inst.components.fueled:InitializeFuelLevel(TUNING.RAINHAT_PERISHTIME)
	end
	
	inst.components.fueled:SetDepletedFn(generic_perish)
	
	inst.components.inventoryitem.atlasname = "images/inventoryimages/skinmod_rainhat.xml"
	
	return inst
end

return Prefab("common/inventory/skinmod_rainhat", fn, Assets)
