local assets= --From DS
{
	Asset("ANIM", "anim/skinmod_redamulet.zip"),
	Asset("ANIM", "anim/skinmod_redamulet_down.zip"),
	Asset("ATLAS", "images/inventoryimages/skinmod_redamulet.xml"),
}

local function healowner(inst, owner)
    if (owner.components.health and owner.components.health:IsHurt())
    and (owner.components.hunger and owner.components.hunger.current > 5 )then
        owner.components.health:DoDelta(TUNING.REDAMULET_CONVERSION,false,"redamulet")
        owner.components.hunger:DoDelta(-TUNING.REDAMULET_CONVERSION)
        inst.components.finiteuses:Use(1)
    end
end

local function onequip_red(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "skinmod_redamulet", "redamulet")
    inst.task = inst:DoPeriodicTask(30, function() healowner(inst, owner) end)
end

local function onunequip_red(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
    if inst.task then inst.task:Cancel() inst.task = nil end
end

--COMMON FUNCTIONS

local function onfinished(inst)
    inst:Remove()
end

local function commonfn()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)   

    inst.AnimState:SetBank("skinmod_redamulet_down")
    inst.AnimState:SetBuild("skinmod_redamulet_down")
    
    inst:AddComponent("inspectable")
    inst:AddComponent("tradable")
	
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.NECK or EQUIPSLOTS.BODY
	inst.components.equippable.dapperness = TUNING.DAPPERNESS_SMALL    
    
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/jewlery"
    
    return inst
end

local function red(inst)
    local inst = commonfn(inst)
	
	if SaveGameIndex:IsModeShipwrecked() then --sw
		MakeInventoryFloatable(inst, "redamulet_water", "redamulet")
	end
	
    inst.AnimState:PlayAnimation("redamulet")
    inst.components.inventoryitem.keepondeath = true
    inst.components.equippable:SetOnEquip( onequip_red )
    inst.components.equippable:SetOnUnequip( onunequip_red )
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetOnFinished( onfinished )
    inst.components.finiteuses:SetMaxUses(TUNING.REDAMULET_USES)
    inst.components.finiteuses:SetUses(TUNING.REDAMULET_USES)
	
	inst.components.inventoryitem.atlasname = "images/inventoryimages/skinmod_redamulet.xml"
	
    return inst
end

return Prefab( "common/inventory/skinmod_redamulet", red, assets)
