local assets=
{
	Asset("ANIM", "anim/skinmod_redstaff.zip"),
	Asset("ANIM", "anim/skinmod_redstaff_swap.zip"), 
	Asset("ATLAS", "images/inventoryimages/skinmod_redstaff.xml"),
}

local prefabs = 
{
    "fire_projectile",
    "cutgrass",
}

---------RED STAFF---------

local function onattack_red(inst, attacker, target)

    if target.components.burnable and not target.components.burnable:IsBurning() then
        if target.components.freezable and target.components.freezable:IsFrozen() then           
            target.components.freezable:Unfreeze()            
        else            
			if IsDLCEnabled(REIGN_OF_GIANTS) then --rog
				if target.components.fueled and target:HasTag("campfire") and target:HasTag("structure") then
					-- Rather than worrying about adding fuel cmp here, just spawn some fuel and immediately feed it to the fire
					local fuel = SpawnPrefab("cutgrass")
					if fuel then target.components.fueled:TakeFuelItem(fuel) end
				else
					target.components.burnable:Ignite(true)
				end
			elseif not SaveGameIndex:IsModeShipwrecked() then --ds
				target.components.burnable:Ignite(true)
			elseif SaveGameIndex:IsModeShipwrecked() then --sw
				if target.components.fueled and target:HasTag("campfire") and target:HasTag("structure") then
					-- Rather than worrying about adding fuel cmp here, just spawn some fuel and immediately feed it to the fire
					local fuel = SpawnPrefab("cutgrass")
					if fuel then target.components.fueled:TakeFuelItem(fuel) end
				else
					target.components.burnable:Ignite(true)
				end
			end
        end   
    end
	
	if SaveGameIndex:IsModeShipwrecked() then --sw
		if target:HasTag("aquatic") and not target.components.burnable then 
			local pt = target:GetPosition()
			local smoke = SpawnPrefab("smoke_out")
			smoke.Transform:SetPosition(pt:Get())

			 if target.SoundEmitter then 
				target.SoundEmitter:PlaySound("dontstarve_DLC002/common/fire_weapon_out") 
			end 
		end 
	end
	
    if target.components.freezable then
        target.components.freezable:AddColdness(-1) --Does this break ice staff?
        if target.components.freezable:IsFrozen() then
            target.components.freezable:Unfreeze()            
        end
    end

    if target.components.sleeper and target.components.sleeper:IsAsleep() then
        target.components.sleeper:WakeUp()
    end

    if attacker and attacker.components.sanity then
        attacker.components.sanity:DoDelta(-TUNING.SANITY_SUPERTINY)
    end

    attacker.SoundEmitter:PlaySound("dontstarve/wilson/fireball_explo")

    target:PushEvent("attacked", { attacker = attacker, damage = 0 })
end

local function onlight(inst, target)
    if inst.components.finiteuses then
        inst.components.finiteuses:Use(1)
    end
end

---------COMMON FUNCTIONS---------

local function onfinished(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/gem_shatter")
    inst:Remove()
end

local function unimplementeditem(inst)
    local player = GetPlayer()
    player.components.talker:Say(GetString(player.prefab, "ANNOUNCE_UNIMPLEMENTED"))
    if player.components.health.currenthealth > 1 then
        player.components.health:DoDelta(-player.components.health.currenthealth * 0.5)
    end

    if inst.components.useableitem then
        inst.components.useableitem:StopUsingItem()
    end
end

local function commonfn(colour)

    local onequip = function(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_object", "skinmod_redstaff_swap", "redstaff_skin")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
    end

    local onunequip = function(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
	
	if SaveGameIndex:IsModeShipwrecked() then --sw
		MakeInventoryFloatable(inst, "redstaff_water", "redstaff")
    end
	
    anim:SetBank("skinmod_redstaff")
    anim:SetBuild("skinmod_redstaff")
    anim:PlayAnimation("redstaff")
    -------   
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetOnFinished( onfinished )

    inst:AddComponent("inspectable")
    inst:AddComponent("tradable")
    
    inst:AddComponent("inventoryitem")
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )


    
    return inst
end


---------COLOUR SPECIFIC CONSTRUCTIONS---------

local function red()
    local inst = commonfn("red")


    inst:AddTag("firestaff")
    inst:AddTag("rangedfireweapon")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(0)
    inst.components.weapon:SetRange(8, 10)
    inst.components.weapon:SetOnAttack(onattack_red)
    inst.components.weapon:SetProjectile("fire_projectile")
	
	if IsDLCEnabled(REIGN_OF_GIANTS) then --rog
		inst:AddTag("rangedlighter")
	elseif not SaveGameIndex:IsModeShipwrecked() then --ds
		inst:AddComponent("lighter")
		inst.components.lighter:SetOnLightFn(onlight)
	elseif SaveGameIndex:IsModeShipwrecked() then --sw
		inst:AddTag("rangedlighter")
	end

    inst.components.finiteuses:SetMaxUses(TUNING.FIRESTAFF_USES)
    inst.components.finiteuses:SetUses(TUNING.FIRESTAFF_USES)
	
	inst.components.inventoryitem.atlasname = "images/inventoryimages/skinmod_redstaff.xml"
	
    return inst
end

return Prefab("common/inventory/skinmod_redstaff", red, assets, prefabs)
