local Assets =
{
	Asset("ANIM", "anim/skinmod_winterhat.zip"),
	Asset("ATLAS", "images/inventoryimages/skinmod_winterhat.xml"),
}

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_hat", "skinmod_winterhat", "swap_hat")
	owner.AnimState:Show("HAT")
	owner.AnimState:Show("HAT_HAIR")
	owner.AnimState:Hide("HAIR_NOHAT")
	owner.AnimState:Hide("HAIR")

	if owner:HasTag("player") then
		owner.AnimState:Hide("HEAD")
		owner.AnimState:Show("HEAD_HAIR")
	end
	
	if inst.components.fueled then
		inst.components.fueled:StartConsuming()
	end
end

local function onunequip(inst, owner)
	owner.AnimState:Hide("HAT")
	owner.AnimState:Hide("HAT_HAIR")
	owner.AnimState:Show("HAIR_NOHAT")
	owner.AnimState:Show("HAIR")
	
	if owner:HasTag("player") then
		owner.AnimState:Show("HEAD")
		owner.AnimState:Hide("HEAD_HAIR")
	end
	
	if inst.components.fueled then
		inst.components.fueled:StopConsuming()        
	end
end

local function opentop_onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_hat", skinmod_winterhat, "swap_hat")
	owner.AnimState:Show("HAT")
	owner.AnimState:Hide("HAT_HAIR")
	owner.AnimState:Show("HAIR_NOHAT")
	owner.AnimState:Show("HAIR")
	
	owner.AnimState:Show("HEAD")
	owner.AnimState:Hide("HEAD_HAIR")
	
	if inst.components.fueled then
	inst.components.fueled:StartConsuming()        
	end
end

local function generic_perish(inst)
	inst:Remove()
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	
    MakeInventoryPhysics(inst)
	
    inst.AnimState:SetBank("skinmod_winterhat")
    inst.AnimState:SetBuild("skinmod_winterhat")
    inst.AnimState:PlayAnimation("anim")
    
	inst:AddTag("hat")
	
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
	inst:AddComponent("equippable")
	
	inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	inst.components.equippable:SetOnEquip( onequip )
	inst.components.equippable:SetOnUnequip( onunequip )
	
	inst:AddComponent("dapperness")
	inst.components.dapperness.dapperness = TUNING.DAPPERNESS_TINY
	inst:AddComponent("insulator")
	inst.components.insulator.insulation = TUNING.INSULATION_MED
    
	inst:AddComponent("fueled")
	inst.components.fueled.fueltype = "USAGE"
	inst.components.fueled:InitializeFuelLevel(TUNING.WINTERHAT_PERISHTIME)
	inst.components.fueled:SetDepletedFn(generic_perish)
	
	if SaveGameIndex:IsModeShipwrecked() then --sw
		MakeInventoryFloatable(inst, "idle_water", "anim")
	end
	
	inst.components.inventoryitem.atlasname = "images/inventoryimages/skinmod_winterhat.xml"
	
	return inst
end

return Prefab("common/inventory/skinmod_winterhat", fn, Assets)
