local assets= --From DS
{
	Asset("ANIM", "anim/skinmod_woodarmor_norm.zip"),
	Asset("ATLAS", "images/inventoryimages/skinmod_woodarmor_norm.xml"),
}

local function OnBlocked(owner) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour") 
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "skinmod_woodarmor_norm", "swap_body")
    inst:ListenForEvent("blocked", OnBlocked, owner)
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
    inst:RemoveEventCallback("blocked", OnBlocked, owner)
end

local function fn(Sim)
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)
	
	if SaveGameIndex:IsModeShipwrecked() then --sw
		MakeInventoryFloatable(inst, "idle_water", "anim")
    end
	
    inst.AnimState:SetBank("skinmod_woodarmor_norm")
    inst.AnimState:SetBuild("skinmod_woodarmor_norm")
    inst.AnimState:PlayAnimation("anim")
    
    inst:AddTag("wood")
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/logarmour"

    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.LARGE_FUEL

	if IsDLCEnabled(REIGN_OF_GIANTS) then --rog
		MakeSmallBurnable(inst, TUNING.SMALL_BURNTIME)
		MakeSmallPropagator(inst)
		inst.components.burnable:MakeDragonflyBait(3)
	elseif not SaveGameIndex:IsModeShipwrecked() then --ds
	elseif SaveGameIndex:IsModeShipwrecked() then --sw
		inst:AddComponent("appeasement")
		inst.components.appeasement.appeasementvalue = TUNING.WRATH_SMALL
		
		MakeSmallBurnable(inst, TUNING.SMALL_BURNTIME)
		MakeSmallPropagator(inst)
		inst.components.burnable:MakeDragonflyBait(3)
	end
    
    inst:AddComponent("armor")
    inst.components.armor:InitCondition(TUNING.ARMORWOOD, TUNING.ARMORWOOD_ABSORPTION)
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
    
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
	inst.components.inventoryitem.atlasname = "images/inventoryimages/skinmod_woodarmor_norm.xml"
	
    return inst
end

return Prefab( "common/inventory/skinmod_woodarmor_norm", fn, assets) 
