
local CatastropheTracker = Class(function(self, inst)
    self.inst = inst
    self.tracklist = {}
	self.phase = "calm" -- "warn" "climax" "cool" "subclimax"
	self.climaxtime = 0
	self.cooldowntime = 0
	self.warningthreshold = 120
	self.climaxthreshold = 5
	self.nightmareclockmode = false
	
    self.inst:StartUpdatingComponent(self)
end)

-- This returns the damage multiplier for the Catastrorang
function CatastropheTracker:GetCatastrorangMultiplier()
	if self.phase == "cool" or self.phase == "subclimax" then
		return 0.66
	elseif self.phase == "warn" then
		return 0.4
	elseif self.phase == "climax" then
		return 1
	end
	return 0.2
end

function CatastropheTracker:IsCalm()
	return self.phase == "calm"
end

function CatastropheTracker:IsWarn()
	return self.phase == "warn" 
end

function CatastropheTracker:IsSubclimax()
	return self.phase == "subclimax"
end

function CatastropheTracker:IsClimax()
	return self.phase == "climax"
end

function CatastropheTracker:IsCool()
	return self.phase == "cool"
end

-- Track hound attacks
function CatastropheTracker:AddHoundedTracker()
	local hounded = TheWorld.components.hounded
	if hounded then
		self.tracklist.hounded = function()
			local timetoattack = hounded:GetTimeToAttack()
			if timetoattack and timetoattack <= self.climaxthreshold then
				self.phase = "climax"
				self.climaxtime = 30 --20 + (hounded.houndstorelease * 10)
				self:NewPhase()
			end
			return timetoattack
		end
	end
end

--TODO: Update for DST
function CatastropheTracker:AddBaseHasslerTracker()
	local basehassler = TheWorld.components.basehassler
	if basehassler then
		if IsDLCEnabled(REIGN_OF_GIANTS) then
			self.tracklist.basehassler = function()
				-- Note: This will only work correctly as long as there's one hassler active at a time
				for k,v in pairs(basehassler.hasslers) do
					local h = basehassler.hasslers[k]
					if basehassler:IsHasslerState(k, "WARNING") then
						if h.timer and h.timer <= self.climaxthreshold then
							self.phase = "climax"
							self.climaxtime = 90
							self:NewPhase()
						end
						return h.timer
					end
				end
				return nil
			end 
		else
			self.tracklist.basehassler = function()
				if basehassler.timetoattack and basehassler.timetoattack <= self.climaxthreshold then
					self.phase = "climax"
					self.climaxtime = 90
					self:NewPhase()
				end
				return basehassler.timetoattack
			end
		end
	end
end

--TODO: Update for DST
function CatastropheTracker:AddQuakerTracker()
	local quaker = TheWorld.components.quaker
	if quaker then
		self.tracklist.quaker = function()
			if quaker.nextquake and quaker.nextquake <= self.climaxthreshold*2 and self.phase ~= "climax" then
				self.phase = "subclimax"
				self.cooldowntime = 20
				self:NewPhase()
			end
			return nil
		end
	end
end

--TODO: Update for DST
function CatastropheTracker:AddMooseEggTracker()
    self.inst:ListenForEvent("moose_egg_hatch", function(wrld, data)
		self.phase = "climax"
		self.climaxtime = 90 
		self:NewPhase()
	end, TheWorld)
end

function CatastropheTracker:EnterSubclimax(time_to_set)
	if self.phase ~= "climax" then
		-- Enter subclimax if not already in climax
		self.phase = "subclimax"
		if self.cooldowntime < time_to_set then
			self.cooldowntime = time_to_set 
		end
		-- Push phase change event
		self:NewPhase()
	elseif self.climaxtime < time_to_set then
		-- Extend climax time if already in climax phase
		self.climaxtime = time_to_set
	end
end
function CatastropheTracker:NightmareClockPhase()
	local nightmareclock = TheWorld.components.nightmareclock
	if nightmareclock then		
	-- Use nightmare clock to determine phase if existent
		if nightmareclock:IsCalm() then 
			self.phase = "calm" 
		elseif nightmareclock:IsNightmare() then 
			self.phase = "climax" 
		elseif nightmareclock:IsWarn() then 
			self.phase = "warn" 
		else 
			self.phase = "cool" 
		end
	end
	return nightmareclock ~= nil
end
function CatastropheTracker:OnUpdate(dt)
	if self.climaxtime > 0 then
		-- Update for climax time
		self.climaxtime = self.climaxtime - dt
		if self.climaxtime <= 0 then
			self.climaxtime = 0
			self.cooldowntime = 30
			self.phase = "cool"
			self:NewPhase()
		end
	else
		-- Check for warning
		local nearestthreattime = self.warningthreshold
		for k,v in pairs(self.tracklist) do
			if self.tracklist[k] then
			   local threattime = self.tracklist[k]()
			   if threattime and threattime < nearestthreattime then
					nearestthreattime = threattime
			   end
			else
			end
		end
		local nightmareclock = TheWorld.components.nightmareclock
		if nearestthreattime < self.warningthreshold and self.phase ~= "climax" then
			self.phase = "warn"
			self:NewPhase()
		elseif self.phase ~= "subclimax" then
			self:NightmareClockPhase()
		end
		
		-- Update for cooldown time
		if self.cooldowntime > 0 then
			self.cooldowntime = self.cooldowntime - dt
			if self.cooldowntime <= 0 then
				self.cooldowntime = 0
				if not self:NightmareClockPhase() then
					self.phase = "calm"
				end
				self:NewPhase()
			end
		end
	end
end
function CatastropheTracker:LongUpdate(dt)
	self:OnUpdate(dt)
end
function CatastropheTracker:OnSave()
    local data = {}

    data.phase = self.phase
    data.cooldowntime = self.cooldowntime
	data.climaxtime = self.climaxtime

    return data
end   
      
function CatastropheTracker:OnLoad(data)

    if data then
		if not self:NightmareClockPhase() then
			if data.phase then 
				if data.phase == "warn" then
					self.phase = "calm"
				else
					self.phase = data.phase 
				end
			end
		end
		if data.cooldowntime and (data.phase == "cool" or data.phase == "subclimax")  then self.cooldowntime = data.cooldowntime end
		if data.climaxtime and data.phase == "climax" then self.climaxtime = data.climaxtime end
    end
	self:NewPhase()
end

-- Pushes an event used by Catastrorang
function CatastropheTracker:NewPhase()
	self.inst:PushEvent("catastrophe_phase_change", {newphase = self.phase})
end

return CatastropheTracker


