local _G = GLOBAL

local TUNING = _G.TUNING 

TUNING.CLIMATE_CHANGE_WAIT_YEARS = 1
TUNING.CLIMATE_CHANGE_COMPLETION_YEARS = 4

TUNING.CLIMATE_CHANGE_VARIABLES = {
	PLATEAU_HUMID_DEVIATE_TEMP = {0, 30}, 
	PLATEAU_LUSH_START_TEMP = {40, 50}, 
	PLATEAU_LUSH_DEVIATE_TEMP = {0, 30}, 
}

local function UpdateClimateChange(world)
	local manager = world.components.seasonmanager
	local year = manager.temperatelength + manager.humidlength + manager.lushlength
	local days = _G.GetClock():GetNumCycles()-- nothing within the first year 
	local percent = (days - year * TUNING.CLIMATE_CHANGE_WAIT_YEARS) / (year * TUNING.CLIMATE_CHANGE_COMPLETION_YEARS)
	percent = math.clamp(percent, 0, 1)
	print("updating climate change, percent:", percent)
	
	for variable, variation in pairs(TUNING.CLIMATE_CHANGE_VARIABLES) do 
		local value = variation[1] + (variation[2] - variation[1]) * percent
		TUNING[variable] = value 
	end 	
end

local function SetUpClimateChange(world)
	world:DoTaskInTime(0, UpdateClimateChange)
	world:ListenForEvent("daycomplete", UpdateClimateChange)
end

AddPrefabPostInit("world", function(world)
	world:DoTaskInTime(0, function()
		if world.components.seasonmanager.seasonmode == "plateau" then 
			SetUpClimateChange(world) 
		end 
	end)
	
	for prefab, _ in pairs{
		icehat = true, 
		heatrock = true, 
		watermelonhat = true, 
	} do 
		local recipe = _G.GetRecipe(prefab)
		if recipe then _G.Porkland_Recipes[prefab] = recipe end 
	end 
end)

