class Kv_IP_Common extends Object;

const Kv_PsiAmp_Prefix = "Kv_Invis_PsiAmps.WP_";
const PsiAmpName_0 = "PsiAmp_CV";
const PsiAmpName_1 = "PsiAmp_MG";
const PsiAmpName_2 = "PsiAmp_BM";

static function bool UpdatePsiAmpTemplatesAllDifficulties()
{
	// Do a proper pass across all difficulties to catch variants
	return class'Kv_Common'.static.UpdateTemplates(UpdatePsiAmpTemplate, GetPsiAmpTemplates);
}

/*
// Try to catch any PsiAmps added by mods too
static function bool UpdatePsiAmpTemplates_AddedByMods()
{
	return class'Kv_Common'.static.UpdateTemplates(UpdatePsiAmpTemplate_AddedByMods, GetPsiAmpTemplates_AddedByMods);
}
*/

static function bool UpdatePsiAmpTemplates_CurrentOnly()
{
	// Do a quick pass on currently loaded templates for the sake of the character pool
	class'Kv_Common'.static.UpdateTemplates(UpdatePsiAmpTemplate, GetPsiAmpTemplates, true);
}

static function bool UpdatePsiAmpTemplate(X2DataTemplate Template)
{
	local X2WeaponTemplate PsiAmp;
	PsiAmp = X2WeaponTemplate(Template);
	PsiAmp.GameArchetype = "Kv_Invis_PsiAmps.WP_PsiAmp_CV";
	return true;
}

static function array<X2DataTemplate> GetPsiAmpTemplates()
{
	local X2ItemTemplateManager ItemTemplateManager;
	local X2DataTemplate Template;
	local string PsiAmpNames[3];
	local string PsiAmpArchetypes[3];
	local array<X2DataTemplate> Templates;
	local int ArrayIndex;
		
	PsiAmpNames[0] = PsiAmpName_0;
	PsiAmpNames[1] = PsiAmpName_1;
	PsiAmpNames[2] = PsiAmpName_2;

	ItemTemplateManager = class'X2ItemTemplateManager'.static.GetItemTemplateManager();

	for( ArrayIndex = 0; ArrayIndex < 3; ++ArrayIndex )
	{
		Template = ItemTemplateManager.FindItemTemplate(name(PsiAmpNames[ArrayIndex]));
		if(Template != none)
			Templates.AddItem(Template);
	}

	return Templates;
}

/*
// Special case for handling PsiAmps added by other mods
static function bool UpdatePsiAmpTemplate_AddedByMods(X2DataTemplate Template)
{
	local X2WeaponTemplate PsiAmp;
	PsiAmp = X2WeaponTemplate(Template);
	//PsiAmp.GameArchetype = Kv_PsiAmp_Prefix @ PsiAmpName_0; // Just set it to the invisible model of the CV PsiAmp
	//PsiAmp.GameArchetype = "Kv_Invis_PsiAmps.WP_PsiAmp_CV";
	
	return true;
}

// Special case for handling PsiAmps added by other mods
static function array<X2DataTemplate> GetPsiAmpTemplates_AddedByMods()
{
	local int ArrayIndex;
	local X2WeaponTemplate Template;
	local array<X2DataTemplate> Templates;
	local array<X2DataTemplate> WeaponTemplates;

	WeaponTemplates = class'Kv_Common'.static.GetItemTemplatesByType("weapon");
	for( ArrayIndex = 0; ArrayIndex < WeaponTemplates.Length; ++ArrayIndex)
	{
		Template = X2WeaponTemplate( WeaponTemplates[ArrayIndex] );
		if(Template != none)
		{
			if(Template.WeaponCat == 'psiamp')
			{
				Templates.AddItem(WeaponTemplates[ArrayIndex]);
			}
		}
	}
	return Templates;
}
*/