
local MakePlayerCharacter = require "prefabs/player_common"

local assets = {Asset("SCRIPT", "scripts/prefabs/player_common.lua"),}

local prefabs = {}

local start_inv = {"manrabbit_tail", "carrot_seeds", "healingsalve", }

local function onbecamehuman(inst)

	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "reisen_speed_mod", 1)
	
end

local function onbecameghost(inst)

   inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "reisen_speed_mod")
   
end

local function onload(inst)

    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
	
        onbecameghost(inst)
		
    else
	
        onbecamehuman(inst)
		
    end
	
end

local function lunatic(inst)

	if inst.components.sanity.current >= (100) then
	
		inst.components.combat.damagemultiplier = 1.00
		inst.components.health.absorb = 0.00
	   
	   	inst.components.locomotor.walkspeed = ( 1.15 * TUNING.WILSON_WALK_SPEED )
		inst.components.locomotor.runspeed = ( 1.15 * TUNING.WILSON_RUN_SPEED )
		
		inst.components.sanity.neg_aura_mult = 1.5
		inst.components.sanity.night_drain_mult = 1.5
		inst.components.sanity.dapperness = ( TUNING.DAPPERNESS_MED * -0.85 )
		
		inst.Light:Enable(false)
	 
	elseif inst.components.sanity.current >= (75) and inst.components.sanity.current < (100) then
		
		inst.components.combat.damagemultiplier = 1.30
		inst.components.health.absorb = -0.15
		
		inst.components.locomotor.walkspeed = ( 1.15 * TUNING.WILSON_WALK_SPEED )
		inst.components.locomotor.runspeed = ( 1.15 * TUNING.WILSON_RUN_SPEED )
		
		inst.components.sanity.neg_aura_mult = 1.5
		inst.components.sanity.night_drain_mult = 1.5
		inst.components.sanity.dapperness = ( TUNING.DAPPERNESS_MED * -0.85 )
		
		inst.Light:Enable(false)
		
    elseif inst.components.sanity.current >= (50) and inst.components.sanity.current < (75) then
		
		inst.components.combat.damagemultiplier = 1.60
		inst.components.health.absorb = -0.30
		
		inst.components.locomotor.walkspeed = ( 1.15 * TUNING.WILSON_WALK_SPEED )
		inst.components.locomotor.runspeed = ( 1.15 * TUNING.WILSON_RUN_SPEED )
		
		inst.components.sanity.neg_aura_mult = 1.5
		inst.components.sanity.night_drain_mult = 1.5
		inst.components.sanity.dapperness = ( TUNING.DAPPERNESS_MED * -0.85 )
		
		inst.Light:Enable(false)
		
    elseif inst.components.sanity.current >= (25) and inst.components.sanity.current < (50)then
		
		inst.components.combat.damagemultiplier = 1.90
		inst.components.health.absorb = -0.45
		
		inst.components.locomotor.walkspeed = ( 1.15 * TUNING.WILSON_WALK_SPEED )
		inst.components.locomotor.runspeed = ( 1.15 * TUNING.WILSON_RUN_SPEED )
		
		inst.components.sanity.neg_aura_mult = 1.5
		inst.components.sanity.night_drain_mult = 1.5
		inst.components.sanity.dapperness = ( TUNING.DAPPERNESS_MED * -0.85 )
		
		inst.Light:Enable(false)
		
	elseif inst.components.sanity.current > (0) and inst.components.sanity.current < (25) then
		
		inst.components.combat.damagemultiplier = 2.20
		inst.components.health.absorb = -0.60
		
		inst.components.locomotor.walkspeed = ( 1.15 * TUNING.WILSON_WALK_SPEED )
		inst.components.locomotor.runspeed = ( 1.15 * TUNING.WILSON_RUN_SPEED )
		
		inst.components.sanity.neg_aura_mult = 1.5
		inst.components.sanity.night_drain_mult = 1.5
		inst.components.sanity.dapperness = ( TUNING.DAPPERNESS_MED * -0.85 )
		
		inst.Light:Enable(false)
	
	elseif inst.components.sanity.current >= (0) and inst.components.sanity.current < (1) and TheWorld.state.phase == "day" then
	
		inst.components.combat.damagemultiplier = 2.50
		inst.components.health.absorb = -0.75
		
		inst.components.locomotor.walkspeed = ( 1.3 * TUNING.WILSON_WALK_SPEED )
		inst.components.locomotor.runspeed = ( 1.3 * TUNING.WILSON_RUN_SPEED )
		
		inst.components.sanity.neg_aura_mult = 3.0
		inst.components.sanity.night_drain_mult = 3.0
		inst.components.sanity.dapperness = ( TUNING.DAPPERNESS_MED * -1.5 )
		
		inst.Light:Enable(true)
		
	elseif inst.components.sanity.current >= (0) and inst.components.sanity.current < (1) and TheWorld.state.phase == "dusk" then
	
		inst.components.combat.damagemultiplier = 2.50
		inst.components.health.absorb = -0.75
		
		inst.components.locomotor.walkspeed = ( 1.3 * TUNING.WILSON_WALK_SPEED )
		inst.components.locomotor.runspeed = ( 1.3 * TUNING.WILSON_RUN_SPEED )
		
		inst.components.sanity.neg_aura_mult = 3.0
		inst.components.sanity.night_drain_mult = 3.0
		inst.components.sanity.dapperness = ( TUNING.DAPPERNESS_MED * -1.5 )
		
		inst.Light:Enable(true)
		
	elseif inst.components.sanity.current >= (0) and inst.components.sanity.current < (1) and TheWorld.state.phase == "night" then
		
		inst.components.combat.damagemultiplier = 2.50
		inst.components.health.absorb = -0.75
		
		inst.entity:AddLight()
		inst.Light:SetRadius(6)
		inst.Light:SetFalloff(.6)
		inst.Light:SetIntensity(.6)
		inst.Light:SetColour(255/255,0/255,0/255)
		inst.Light:Enable(true)
		
		inst.components.locomotor.walkspeed = ( 1.3 * TUNING.WILSON_WALK_SPEED )
		inst.components.locomotor.runspeed = ( 1.3 * TUNING.WILSON_RUN_SPEED )
		
		inst.components.sanity.neg_aura_mult = 3.0
		inst.components.sanity.night_drain_mult = 3.0
		inst.components.sanity.dapperness = ( TUNING.DAPPERNESS_MED * -1.5 )
		
	elseif inst.components.sanity.current >= (0) and inst.components.sanity.current < (1) and tempCaveVar == true then
	
		inst.components.combat.damagemultiplier = 2.50
		inst.components.health.absorb = -0.75
		
		inst.entity:AddLight()
		inst.Light:SetRadius(6)
		inst.Light:SetFalloff(.6)
		inst.Light:SetIntensity(.6)
		inst.Light:SetColour(255/255,0/255,0/255)
		inst.Light:Enable(true)
		
		inst.components.locomotor.walkspeed = ( 1.3 * TUNING.WILSON_WALK_SPEED )
		inst.components.locomotor.runspeed = ( 1.3 * TUNING.WILSON_RUN_SPEED )
		
		inst.components.sanity.neg_aura_mult = 3.0
		inst.components.sanity.night_drain_mult = 3.0
		inst.components.sanity.dapperness = ( TUNING.DAPPERNESS_MED * -1.5 )
		
	end
	
end

local function oneat(inst, food)

	if food and food.components.edible and food.prefab == "carrot" or food.prefab == "carrot_cooked" then
		
		inst.components.sanity:DoDelta(100)
		
	end
	
end

local common_postinit = function(inst)

	inst.MiniMapEntity:SetIcon( "reisen.tex" )
	
end

local master_postinit = function(inst)

	inst.soundsname = "willow"
	
	inst.components.health:SetMaxHealth(300)
	inst.components.hunger:SetMax(200)
	inst.components.sanity:SetMax(100)
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
	inst.components.temperature.inherentinsulation = ( TUNING.INSULATION_PER_BEARD_BIT * 1.5 )
	
	inst.components.hunger.hungerrate = ( 0.85 * TUNING.WILSON_HUNGER_RATE )
	
	inst:AddTag("insomniac")
	
	inst.components.eater:SetOnEatFn(oneat)
	
	inst:ListenForEvent("sanitydelta", function(inst) lunatic(inst) end )
	
	inst:WatchWorldState( "isday", function(inst) lunatic(inst) end )
	inst:WatchWorldState( "isdusk", function(inst) lunatic(inst) end )
	inst:WatchWorldState( "isnight", function(inst) lunatic(inst) end )
	inst:WatchWorldState( "iscaveday", function(inst) lunatic(inst) end)
  	inst:WatchWorldState( "iscavedusk", function(inst) lunatic(inst) end)
  	inst:WatchWorldState( "iscavenight", function(inst) lunatic(inst) end)
	
	lunatic(inst)
	return inst
	
end

return MakePlayerCharacter("reisen", prefabs, assets, common_postinit, master_postinit, start_inv)

--Current Mod Version: [1.3.8]
--DST Character Mod created by: Senshimi [https://steamcommunity.com/id/Senshimi/]
--Touhou Project Collection: [http://steamcommunity.com/sharedfiles/filedetails/?id=701414094]
