require "behaviours/wander"
require "behaviours/faceentity"

local MAX_WANDER_DIST = 50

local START_FACE_DIST = 3
local KEEP_FACE_DIST = 6
local TRADE_DIST = 20

local function GetFaceTargetFn(inst)
    local target = GetClosestInstWithTag("player", inst, START_FACE_DIST)
    if target and not target:HasTag("notarget") then
        return target
    end
end

local function KeepFaceTargetFn(inst, target)
    return inst:IsNear(target, KEEP_FACE_DIST) and not target:HasTag("notarget")
end

local function GetTraderFn(inst)
    return FindEntity(inst, TRADE_DIST, function(target) return inst.components.trader:IsTryingToTradeWithMe(target) end, {"player"})
end

local function KeepTraderFn(inst, target)
    return inst.components.trader:IsTryingToTradeWithMe(target)
end

local PigBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

function PigBrain:OnStart()
    --print(self.inst, "PigBrain:OnStart")
    local clock = GetClock()

    local root =
        PriorityNode(
        {
          FaceEntity(self.inst, GetTraderFn, KeepTraderFn),
          FaceEntity(self.inst, GetFaceTargetFn, KeepFaceTargetFn),
          Wander(self.inst, function() return self.inst.components.knownlocations:GetLocation("herd") end, MAX_WANDER_DIST)
        }, .5)

    self.bt = BT(self.inst, root)

end

return PigBrain
