
local name = "fruit"
local fname = "hat_"..name
local symname = name.."hat"
local texture = symname..".tex"
local prefabname = symname
local assets=
{
    Asset("ANIM", "anim/"..fname..".zip"),
    --Asset("IMAGE", texture),
}

local function onequip(inst, owner, fname_override)
    local build = fname_override or fname
    owner.AnimState:OverrideSymbol("swap_hat", build, "swap_hat")
    owner.AnimState:Show("HAT")
    owner.AnimState:Show("HAT_HAIR")
    owner.AnimState:Hide("HAIR_NOHAT")
    owner.AnimState:Hide("HAIR")

    if owner:HasTag("player") then
	     owner.AnimState:Hide("HEAD")
	     owner.AnimState:Show("HEAD_HAIR")
    end

    if inst.components.fueled then
	     inst.components.fueled:StartConsuming()
    end
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("HAT")
    owner.AnimState:Hide("HAT_HAIR")
    owner.AnimState:Show("HAIR_NOHAT")
    owner.AnimState:Show("HAIR")

    if owner:HasTag("player") then
      owner.AnimState:Show("HEAD")
    	owner.AnimState:Hide("HEAD_HAIR")
    end

    if inst.components.fueled then
    	inst.components.fueled:StopConsuming()
    end
end

local function opentop_onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_hat", fname, "swap_hat")
    owner.AnimState:Show("HAT")
    owner.AnimState:Hide("HAT_HAIR")
    owner.AnimState:Show("HAIR_NOHAT")
    owner.AnimState:Show("HAIR")

    owner.AnimState:Show("HEAD")
    owner.AnimState:Hide("HEAD_HAIR")

    if inst.components.fueled then
    	inst.components.fueled:StartConsuming()
    end
end


local function simple()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank(symname)
    inst.AnimState:SetBuild(fname)
    inst.AnimState:PlayAnimation("anim")

    inst:AddTag("hat")

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst:AddComponent("tradable")

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD

    inst.components.equippable:SetOnEquip( onequip )

    inst.components.equippable:SetOnUnequip( onunequip )

    return inst
end


return Prefab( "common/inventory/fruithat", simple, assets, nil)
