local assets=
{
    Asset("ANIM", "anim/dca.zip"),
    Asset("ANIM", "anim/swap_dca.zip"),
  
    Asset("ATLAS", "images/inventoryimages/dca.xml"),
    Asset("IMAGE", "images/inventoryimages/dca.tex"),
}

local prefabs = 
{
	"creighton"
}

local function Onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_dca", "swap_sandai")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end
  
local function Onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end
 
local function fn()
  
    local inst = CreateEntity()
 
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
     
    MakeInventoryPhysics(inst)   
      
    inst.AnimState:SetBank("sandai")
    inst.AnimState:SetBuild("dca")
    inst.AnimState:PlayAnimation("idle")
 
    inst:AddTag("sharp")
 
    if not TheWorld.ismastersim then
        return inst
    end
 
    inst.entity:SetPristine()
     
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(33)
	
	inst:AddComponent("armor")
	inst.components.armor:InitCondition(99999999*9, TUNING.ARMOR_SANITY_ABSORPTION * 0.11)
	
	inst:AddComponent("tool")
	inst.components.tool:SetAction(ACTIONS.CHOP, 2)
	
    inst.components.tool:SetAction(ACTIONS.MINE, 2)
  
    inst:AddComponent("inspectable")
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.keepondeath = true
    inst.components.inventoryitem.atlasname = "images/inventoryimages/dca.xml"
	
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( Onequip )
    inst.components.equippable:SetOnUnequip( Onunequip )
	inst.components.inventoryitem.keepondeath = true
	
	if not inst.components.characterspecific then
    inst:AddComponent("characterspecific")
end
 
	inst.components.characterspecific:SetOwner("creighton")
	inst.components.characterspecific:SetStorable(true)
	inst.components.characterspecific:SetComment("Is this real?") 
     
    return inst
end
return  Prefab("common/inventory/dca", fn, assets, prefabs) 