local assets=
{
	Asset("ANIM", "anim/trap.zip"),
    Asset("SOUND", "sound/common.fsb"),
}

local sounds = 
{
    close = "dontstarve/common/trap_close",
    rustle = "dontstarve/common/trap_rustle",
}

local function onfinished(inst)
    inst:Remove()
end

local function onharvested(inst)
    if inst.components.finiteuses then
	    inst.components.finiteuses:Use(1)
    end
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    
    inst.entity:AddMiniMapEntity()
    inst.MiniMapEntity:SetIcon( "rabbittrap.png" )
   
    anim:SetBank("trap")
    anim:SetBuild("trap")
    anim:PlayAnimation("idle")
    inst.sounds = sounds
    
    inst:AddTag("trap")
    
    inst:AddComponent("inspectable")
local colours=
{
    {198/255,43/255,43/255},
    {79/255,153/255,68/255},
    {35/255,105/255,235/255},
    {233/255,208/255,69/255},
    {109/255,50/255,163/255},
    {222/255,126/255,39/255},
}
local function OnDeploy (inst, pt)
    local ball = SpawnPrefab("trap")
    ball.Transform:SetPosition(pt.x, pt.y, pt.z)
    ball.AnimState:SetBank("bulb")
    ball.AnimState:SetBuild("bulb")
    ball.AnimState:PlayAnimation("idle")
    ball.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
    ball:ClearStateGraph()
    ball.components.inventoryitem:ChangeImageName("lightbulb")
    ball.colour_idx = math.random(#colours)
    ball.AnimState:SetMultColour(colours[ball.colour_idx][1],colours[ball.colour_idx][2],colours[ball.colour_idx][3],1)
    ball:RemoveComponent("finiteuses")
    ball:RemoveComponent("trap")
    ball:RemoveComponent("deployable")
    ball:RemoveTag("trap")
    ball:AddComponent("weapon")
    ball.components.weapon:SetDamage(30)
    ball.components.weapon:SetRange(20, 25)
    ball:AddComponent("equippable")
    ball.components.equippable.equipslot = EQUIPSLOTS.HANDS
    ball.components.equippable:SetOnEquip(function(ball)
        ball.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
    end )
    ball:AddComponent("projectile")
    ball.components.projectile:SetSpeed(25)
    ball.components.projectile:SetOnHitFn(function(ball, owner, target)
        GetPlayer().SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
        local target0 = FindEntity(owner, 25, function(guy) 
            if guy.components.health and not guy.components.health:IsDead() and not guy:HasTag("player") then
               return guy.components.combat.target == owner or owner.components.combat.target == owner or guy:HasTag("monster")
            end
        end )
        if target0 then
           ball.components.projectile:Throw(owner, target0)
        else
           owner.components.inventory:Equip(ball)
        end
    end )
    ball.components.projectile:SetOnMissFn(function(ball, owner)
        owner.components.inventory:Equip(ball)
    end )
    ball:ListenForEvent("onthrown", function(ball)
        local pt = ball:GetPosition()
        ball.Transform:SetPosition(pt.x, 2, pt.z)
        ball.SoundEmitter:PlaySound("dontstarve/wilson/boomerang_throw")
    end )
    ball:AddComponent("workable")
    ball.components.workable:SetWorkAction(ACTIONS.HAMMER)
    ball.components.workable:SetWorkLeft(3)
    ball.components.workable:SetOnFinishCallback(function(ball)
        SpawnPrefab("ground_chunks_breaking").Transform:SetPosition(ball.Transform:GetWorldPosition())
        ball:Remove()
    end )
    ball:AddTag("projectile")
    ball:AddTag("balls")
    inst:Remove()
end
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy
local function onsave(inst, data)
    if inst:HasTag("balls") then
       data.balls = true
    end
    data.colour_idx = inst.colour_idx
end
local function onload(inst, data)
  if data and data.balls then
    inst.AnimState:SetBank("bulb")
    inst.AnimState:SetBuild("bulb")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
    inst:ClearStateGraph()
    inst.components.inventoryitem:ChangeImageName("lightbulb")
    inst:RemoveComponent("finiteuses")
    inst:RemoveComponent("trap")
    inst:RemoveComponent("deployable")
    inst:RemoveTag("trap")
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(30)
    inst.components.weapon:SetRange(20, 25)
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HANDS
    inst.components.equippable:SetOnEquip(function(inst)
        inst.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
    end )
    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(25)
    inst.components.projectile:SetOnHitFn(function(inst, owner, target)
        GetPlayer().SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
        local target0 = FindEntity(owner, 25, function(guy) 
            if guy.components.health and not guy.components.health:IsDead() and not guy:HasTag("player") then
               return guy.components.combat.target == owner or owner.components.combat.target == owner or guy:HasTag("monster")
            end
        end )
        if target0 then
           inst.components.projectile:Throw(owner, target0)
        else
           owner.components.inventory:Equip(inst)
        end
    end )
    inst.components.projectile:SetOnMissFn(function(inst, owner)
        owner.components.inventory:Equip(inst)
    end )
    inst:ListenForEvent("onthrown", function(inst)
        local pt = inst:GetPosition()
        inst.Transform:SetPosition(pt.x, 2, pt.z)
        inst.SoundEmitter:PlaySound("dontstarve/wilson/boomerang_throw")
    end )
    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(3)
    inst.components.workable:SetOnFinishCallback(function(inst)
        SpawnPrefab("ground_chunks_breaking").Transform:SetPosition(inst.Transform:GetWorldPosition())
        inst:Remove()
    end )
    inst:AddTag("projectile")
    inst:AddTag("balls")
  end
  if data and data.colour_idx then
     inst.colour_idx = math.min(#colours, data.colour_idx)
     inst.AnimState:SetMultColour(colours[inst.colour_idx][1],colours[inst.colour_idx][2],colours[inst.colour_idx][3],1)
  end
end
    inst.OnSave = onsave
    inst.OnLoad = onload

    inst:AddComponent("inventoryitem")

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.TRAP_USES)
    inst.components.finiteuses:SetUses(TUNING.TRAP_USES)
    inst.components.finiteuses:SetOnFinished( onfinished )
    
    inst:AddComponent("trap")
    inst.components.trap.targettag = "canbetrapped"
    inst.components.trap:SetOnHarvestFn(onharvested)
    
    inst:SetStateGraph("SGtrap")

    return inst
end

return Prefab( "common/inventory/trap", fn, assets) 
