/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipaySignature;
import com.taobao.api.ApiException;
import com.taobao.api.FileItem;
import com.taobao.api.TaobaoParser;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.TaobaoResponse;
import com.taobao.api.TaobaoUploadRequest;
import com.taobao.api.internal.parser.json.ObjectJsonParser;
import com.taobao.api.internal.parser.xml.ObjectXmlParser;
import com.taobao.api.internal.util.RequestParametersHolder;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.TaobaoLogger;
import com.taobao.api.internal.util.TaobaoUtils;
import com.taobao.api.internal.util.WebUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAlipayClient
implements AlipayClient {
    private String serverUrl;
    private String appId;
    private String privateKey;
    private String format = "json";
    private String sign_type = "RSA";
    private int connectTimeout = 3000;
    private int readTimeout = 15000;

    public DefaultAlipayClient(String serverUrl, String appId, String privateKey) {
        this.serverUrl = serverUrl;
        this.appId = appId;
        this.privateKey = privateKey;
    }

    public DefaultAlipayClient(String serverUrl, String appId, String privateKey, String format) {
        this(serverUrl, appId, privateKey);
        this.format = format;
    }

    @Override
    public <T extends TaobaoResponse> T execute(TaobaoRequest<T> request) throws AlipayApiException {
        return this.execute(request, null);
    }

    @Override
    public <T extends TaobaoResponse> T execute(TaobaoRequest<T> request, String accessToken) throws AlipayApiException {
        return this.execute(request, accessToken, "1.0");
    }

    @Override
    public <T extends TaobaoResponse> T execute(TaobaoRequest<T> request, String authToken, String version) throws AlipayApiException {
        TaobaoParser<T> parser = null;
        parser = "xml".equals(this.format) ? new ObjectXmlParser<T>(request.getResponseClass()) : new ObjectJsonParser<T>(request.getResponseClass());
        return this._execute(request, parser, authToken, version);
    }

    private <T extends TaobaoResponse> T _execute(TaobaoRequest<T> request, TaobaoParser<T> parser, String authToken, String version) throws AlipayApiException {
        RequestParametersHolder context = this.doPost(request, authToken, version);
        TaobaoResponse tRsp = null;
        try {
            tRsp = (TaobaoResponse)parser.parse(context.getResponseBody());
            tRsp.setBody(context.getResponseBody());
        }
        catch (RuntimeException e) {
            TaobaoLogger.logBizError(context.getResponseBody());
            throw e;
        }
        catch (ApiException e) {
            TaobaoLogger.logBizError(context.getResponseBody());
            throw new AlipayApiException(e);
        }
        tRsp.setParams(context.getApplicationParams());
        if (!tRsp.isSuccess()) {
            TaobaoLogger.logErrorScene(context, tRsp, "");
        }
        return (T)tRsp;
    }

    public <T extends TaobaoResponse> RequestParametersHolder doPost(TaobaoRequest<T> request, String accessToken, String version) throws AlipayApiException {
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        TaobaoHashMap appParams = new TaobaoHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        requestHolder.setApplicationParams(appParams);
        TaobaoHashMap protocalMustParams = new TaobaoHashMap();
        protocalMustParams.put("method", request.getApiMethodName());
        protocalMustParams.put("version", version);
        protocalMustParams.put("app_id", this.appId);
        Long timestamp = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        protocalMustParams.put("timestamp", df.format(new Date(timestamp)));
        requestHolder.setProtocalMustParams(protocalMustParams);
        TaobaoHashMap protocalOptParams = new TaobaoHashMap();
        protocalOptParams.put("format", this.format);
        protocalOptParams.put("sign_type", this.sign_type);
        protocalOptParams.put("auth_token", accessToken);
        protocalOptParams.put("alipay_sdk", "top-sdk-java-20151116");
        requestHolder.setProtocalOptParams(protocalOptParams);
        if ("RSA".equals(this.sign_type)) {
            String signContent = AlipaySignature.getSignatureContent(requestHolder);
            protocalMustParams.put("sign", AlipaySignature.rsaSign(signContent, this.privateKey, "UTF-8"));
        } else {
            protocalMustParams.put("sign", "");
        }
        StringBuffer requestUrl = new StringBuffer(this.serverUrl);
        try {
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), "UTF-8");
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), "UTF-8");
            if (requestUrl.indexOf("?") != -1) {
                requestUrl.append("&");
            } else {
                requestUrl.append("?");
            }
            requestUrl.append(sysMustQuery);
            if (sysOptQuery != null & sysOptQuery.length() > 0) {
                requestUrl.append("&").append(sysOptQuery);
            }
            requestHolder.setRequestUrl(requestUrl.toString());
        }
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
        String rsp = null;
        try {
            if (request instanceof TaobaoUploadRequest) {
                TaobaoUploadRequest uRequest = (TaobaoUploadRequest)request;
                Map<String, FileItem> fileParams = TaobaoUtils.cleanupMap(uRequest.getFileParams());
                rsp = WebUtils.doPost(requestUrl.toString(), (Map<String, String>)appParams, fileParams, this.connectTimeout, this.readTimeout);
            } else {
                rsp = WebUtils.doPost(requestUrl.toString(), appParams, this.connectTimeout, this.readTimeout);
            }
            requestHolder.setResponseBody(rsp);
        }
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
        return requestHolder;
    }
}

