/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.parser.json;

import com.taobao.api.ApiException;
import com.taobao.api.TaobaoResponse;
import com.taobao.api.internal.mapping.Converter;
import com.taobao.api.internal.mapping.Converters;
import com.taobao.api.internal.mapping.Reader;
import com.taobao.api.internal.util.json.ExceptionErrorListener;
import com.taobao.api.internal.util.json.JSONReader;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonConverter
implements Converter {
    @Override
    public <T extends TaobaoResponse> T toResponse(String rsp, Class<T> clazz) throws ApiException {
        JSONValidatingReader reader = new JSONValidatingReader(new ExceptionErrorListener());
        Object rootObj = ((JSONReader)reader).read(rsp);
        if (rootObj instanceof Map) {
            Map rootJson = (Map)rootObj;
            Collection values = rootJson.values();
            for (Object rspObj : values) {
                if (!(rspObj instanceof Map)) continue;
                Map rspJson = (Map)rspObj;
                return (T)((TaobaoResponse)this.fromJson(rspJson, clazz));
            }
        }
        return null;
    }

    public <T> T fromJson(final Map<?, ?> json, Class<T> clazz) throws ApiException {
        return Converters.convert(clazz, new Reader(){

            @Override
            public boolean hasReturnField(Object name) {
                return json.containsKey(name);
            }

            @Override
            public Object getPrimitiveObject(Object name) {
                return json.get(name);
            }

            @Override
            public Object getObject(Object name, Class<?> type) throws ApiException {
                Object tmp = json.get(name);
                if (tmp instanceof Map) {
                    Map map = (Map)tmp;
                    return JsonConverter.this.fromJson(map, type);
                }
                return tmp;
            }

            @Override
            public List<?> getListObjects(Object listName, Object itemName, Class<?> subType) throws ApiException {
                ArrayList<Object> listObjs = null;
                Object listTmp = json.get(listName);
                if (listTmp instanceof Map) {
                    Map jsonMap = (Map)listTmp;
                    Object itemTmp = jsonMap.get(itemName);
                    if (itemTmp == null && listName != null) {
                        String listNameStr = listName.toString();
                        itemTmp = jsonMap.get(listNameStr.substring(0, listNameStr.length() - 1));
                    }
                    if (itemTmp instanceof List) {
                        listObjs = new ArrayList<Object>();
                        List tmpList = (List)itemTmp;
                        for (Object subTmp : tmpList) {
                            if (subTmp instanceof Map) {
                                Map subMap = (Map)subTmp;
                                Object subObj = JsonConverter.this.fromJson(subMap, subType);
                                if (subObj == null) continue;
                                listObjs.add(subObj);
                                continue;
                            }
                            if (subTmp instanceof List) continue;
                            listObjs.add(subTmp);
                        }
                    }
                }
                return listObjs;
            }
        });
    }
}

