/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.remoting;

import com.taobao.top.link.BufferManager;
import com.taobao.top.link.LoggerFactory;
import com.taobao.top.link.channel.ClientChannelSelector;
import com.taobao.top.link.channel.ClientChannelSharedSelector;
import com.taobao.top.link.logging.LogUtil;
import com.taobao.top.link.remoting.DynamicProxy;
import com.taobao.top.link.remoting.HandshakingHeadersBean;
import com.taobao.top.link.remoting.RemotingClientChannelHandler;
import com.taobao.top.link.remoting.SerializerUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringServiceProxyBean
implements FactoryBean,
InitializingBean {
    private static Object initObject;
    private static ClientChannelSelector channelSelector;
    private static RemotingClientChannelHandler channelHandler;
    private URI uri;
    private Class<?> interfaceType;
    private int executionTimeout;
    private String format;

    public void setInterfaceName(String interfaceName) throws ClassNotFoundException {
        this.interfaceType = Class.forName(interfaceName);
    }

    public void setUri(String uri) throws URISyntaxException {
        this.uri = new URI(uri);
    }

    public void setExecutionTimeout(String executionTimeout) {
        this.executionTimeout = Integer.parseInt(executionTimeout);
    }

    public void setHeaders(HandshakingHeadersBean headersBean) {
        headersBean.setUri(this.uri);
    }

    public void setSerialization(String format) {
        this.format = format;
    }

    public Object getObject() throws Exception {
        DynamicProxy proxy = new DynamicProxy(this.uri, channelSelector, channelHandler);
        proxy.setSerializationFormat(this.format);
        proxy.setExecutionTimeout(this.executionTimeout);
        return proxy.create(this.interfaceType, this.uri);
    }

    public Class<?> getObjectType() {
        return this.interfaceType;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        SpringServiceProxyBean.init(this);
    }

    private static synchronized void init(Object obj) {
        if (initObject != null) {
            return;
        }
        BufferManager.setBufferSize(0x200000);
        LoggerFactory loggerFactory = LogUtil.getLoggerFactory(obj);
        channelSelector = new ClientChannelSharedSelector(loggerFactory);
        channelHandler = new RemotingClientChannelHandler(loggerFactory, new AtomicInteger(0));
        channelHandler.setSerializationFactory(SerializerUtil.getSerializationFactory(obj));
        initObject = new Object();
    }
}

