/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.binding;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.client.HandlerConfiguration;
import com.sun.xml.internal.ws.resources.ClientMessages;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPFactory;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.soap.SOAPBinding;

public final class SOAPBindingImpl
extends BindingImpl
implements SOAPBinding {
    public static final String X_SOAP12HTTP_BINDING = "http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/";
    private static final String ROLE_NONE = "http://www.w3.org/2003/05/soap-envelope/role/none";
    protected final SOAPVersion soapVersion;
    private Set<QName> portKnownHeaders = Collections.emptySet();
    private Set<QName> bindingUnderstoodHeaders = new HashSet<QName>();
    private static final WebServiceFeature[] EMPTY_FEATURES = new WebServiceFeature[0];

    SOAPBindingImpl(BindingID bindingID) {
        this(bindingID, EMPTY_FEATURES);
    }

    SOAPBindingImpl(BindingID bindingID, WebServiceFeature ... webServiceFeatureArray) {
        super(bindingID);
        this.soapVersion = bindingID.getSOAPVersion();
        this.setRoles(new HashSet<String>());
        this.setFeatures(webServiceFeatureArray);
        this.features.addAll(bindingID.createBuiltinFeatureList());
        this.populateBindingUnderstoodHeaders();
    }

    public void setPortKnownHeaders(@NotNull Set<QName> set) {
        this.portKnownHeaders = set;
    }

    public boolean understandsHeader(QName qName) {
        if (this.serviceMode == Service.Mode.MESSAGE) {
            return true;
        }
        if (this.portKnownHeaders.contains(qName)) {
            return true;
        }
        return this.bindingUnderstoodHeaders.contains(qName);
    }

    private void populateBindingUnderstoodHeaders() {
        AddressingVersion addressingVersion = this.getAddressingVersion();
        if (addressingVersion != null) {
            this.bindingUnderstoodHeaders.add(addressingVersion.actionTag);
            this.bindingUnderstoodHeaders.add(addressingVersion.faultToTag);
            this.bindingUnderstoodHeaders.add(addressingVersion.fromTag);
            this.bindingUnderstoodHeaders.add(addressingVersion.messageIDTag);
            this.bindingUnderstoodHeaders.add(addressingVersion.relatesToTag);
            this.bindingUnderstoodHeaders.add(addressingVersion.replyToTag);
            this.bindingUnderstoodHeaders.add(addressingVersion.toTag);
        }
    }

    @Override
    public void setHandlerChain(List<Handler> list) {
        this.handlerConfig = new HandlerConfiguration(this.handlerConfig.getRoles(), list);
    }

    protected void addRequiredRoles(Set<String> set) {
        set.addAll(this.soapVersion.requiredRoles);
    }

    @Override
    public Set<String> getRoles() {
        return this.handlerConfig.getRoles();
    }

    @Override
    public void setRoles(Set<String> set) {
        if (set == null) {
            set = new HashSet<String>();
        }
        if (set.contains(ROLE_NONE)) {
            throw new WebServiceException(ClientMessages.INVALID_SOAP_ROLE_NONE());
        }
        this.addRequiredRoles(set);
        this.handlerConfig = new HandlerConfiguration(set, this.getHandlerConfig());
    }

    @Override
    public boolean isMTOMEnabled() {
        return this.isFeatureEnabled(MTOMFeature.class);
    }

    @Override
    public void setMTOMEnabled(boolean bl) {
        this.setFeatures(new MTOMFeature(bl));
    }

    @Override
    public SOAPFactory getSOAPFactory() {
        return this.soapVersion.saajSoapFactory;
    }

    @Override
    public MessageFactory getMessageFactory() {
        return this.soapVersion.saajMessageFactory;
    }
}

