/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.org.glassfish.gmbal.ManagedObjectManager;
import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.ws.addressing.WSEPRExtension;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.client.WSPortInfo;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.Engine;
import com.sun.xml.internal.ws.api.pipe.Fiber;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubelineAssembler;
import com.sun.xml.internal.ws.api.pipe.TubelineAssemblerFactory;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.client.MonitorRootClient;
import com.sun.xml.internal.ws.client.RequestContext;
import com.sun.xml.internal.ws.client.ResponseContext;
import com.sun.xml.internal.ws.client.ResponseContextReceiver;
import com.sun.xml.internal.ws.client.SEIPortInfo;
import com.sun.xml.internal.ws.client.WSServiceDelegate;
import com.sun.xml.internal.ws.developer.WSBindingProvider;
import com.sun.xml.internal.ws.model.SOAPSEIModel;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLProperties;
import com.sun.xml.internal.ws.resources.ClientMessages;
import com.sun.xml.internal.ws.server.MonitorBase;
import com.sun.xml.internal.ws.util.Pool;
import com.sun.xml.internal.ws.util.RuntimeVersion;
import com.sun.xml.internal.ws.wsdl.OperationDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

public abstract class Stub
implements WSBindingProvider,
ResponseContextReceiver {
    private Pool<Tube> tubes;
    private final Engine engine;
    protected final WSServiceDelegate owner;
    @Nullable
    protected WSEndpointReference endpointReference;
    protected final BindingImpl binding;
    protected final WSPortInfo portInfo;
    protected final AddressingVersion addrVersion;
    public final RequestContext requestContext = new RequestContext();
    private ResponseContext responseContext;
    @Nullable
    protected final WSDLPort wsdlPort;
    @Nullable
    private volatile Header[] userOutboundHeaders;
    @Nullable
    private final WSDLProperties wsdlProperties;
    protected OperationDispatcher operationDispatcher = null;
    @NotNull
    private final ManagedObjectManager managedObjectManager;
    private boolean managedObjectManagerClosed = false;

    @Deprecated
    protected Stub(WSServiceDelegate wSServiceDelegate, Tube tube, BindingImpl bindingImpl, WSDLPort wSDLPort, EndpointAddress endpointAddress, @Nullable WSEndpointReference wSEndpointReference) {
        this(wSServiceDelegate, tube, null, bindingImpl, wSDLPort, endpointAddress, wSEndpointReference);
    }

    protected Stub(WSPortInfo wSPortInfo, BindingImpl bindingImpl, EndpointAddress endpointAddress, @Nullable WSEndpointReference wSEndpointReference) {
        this((WSServiceDelegate)wSPortInfo.getOwner(), null, wSPortInfo, bindingImpl, wSPortInfo.getPort(), endpointAddress, wSEndpointReference);
    }

    private Stub(WSServiceDelegate wSServiceDelegate, @Nullable Tube tube, @Nullable WSPortInfo wSPortInfo, BindingImpl bindingImpl, @Nullable WSDLPort wSDLPort, EndpointAddress endpointAddress, @Nullable WSEndpointReference wSEndpointReference) {
        this.owner = wSServiceDelegate;
        this.portInfo = wSPortInfo;
        this.wsdlPort = wSPortInfo.getPort();
        this.binding = bindingImpl;
        this.addrVersion = bindingImpl.getAddressingVersion();
        if (wSEndpointReference != null) {
            this.requestContext.setEndPointAddressString(wSEndpointReference.getAddress());
        } else {
            this.requestContext.setEndpointAddress(endpointAddress);
        }
        this.engine = new Engine(this.toString(), wSServiceDelegate.getExecutor());
        this.endpointReference = wSEndpointReference;
        this.wsdlProperties = wSDLPort == null ? null : new WSDLProperties(wSDLPort);
        this.managedObjectManager = new MonitorRootClient(this).createManagedObjectManager(this);
        this.tubes = tube != null ? new Pool.TubePool(tube) : new Pool.TubePool(this.createPipeline(wSPortInfo, bindingImpl));
        this.managedObjectManager.resumeJMXRegistration();
    }

    private Tube createPipeline(WSPortInfo wSPortInfo, WSBinding wSBinding) {
        Stub.checkAllWSDLExtensionsUnderstood(wSPortInfo, wSBinding);
        SOAPSEIModel sOAPSEIModel = null;
        if (wSPortInfo instanceof SEIPortInfo) {
            sOAPSEIModel = ((SEIPortInfo)wSPortInfo).model;
        }
        BindingID bindingID = wSPortInfo.getBindingId();
        TubelineAssembler tubelineAssembler = TubelineAssemblerFactory.create(Thread.currentThread().getContextClassLoader(), bindingID);
        if (tubelineAssembler == null) {
            throw new WebServiceException("Unable to process bindingID=" + bindingID);
        }
        return tubelineAssembler.createClient(new ClientTubeAssemblerContext(wSPortInfo.getEndpointAddress(), wSPortInfo.getPort(), this, wSBinding, this.owner.getContainer(), ((BindingImpl)wSBinding).createCodec(), (SEIModel)sOAPSEIModel));
    }

    private static void checkAllWSDLExtensionsUnderstood(WSPortInfo wSPortInfo, WSBinding wSBinding) {
        if (wSPortInfo.getPort() != null && wSBinding.isFeatureEnabled(RespectBindingFeature.class)) {
            ((WSDLPortImpl)wSPortInfo.getPort()).areRequiredExtensionsUnderstood();
        }
    }

    @Override
    public WSPortInfo getPortInfo() {
        return this.portInfo;
    }

    @Nullable
    public OperationDispatcher getOperationDispatcher() {
        if (this.operationDispatcher == null && this.wsdlPort != null) {
            this.operationDispatcher = new OperationDispatcher(this.wsdlPort, this.binding, null);
        }
        return this.operationDispatcher;
    }

    @NotNull
    protected abstract QName getPortName();

    @NotNull
    protected final QName getServiceName() {
        return this.owner.getServiceName();
    }

    public final Executor getExecutor() {
        return this.owner.getExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Packet process(Packet packet, RequestContext requestContext, ResponseContextReceiver responseContextReceiver) {
        Packet packet2;
        Packet packet3;
        this.configureRequestPacket(packet, requestContext);
        Pool<Tube> pool = this.tubes;
        if (pool == null) {
            throw new WebServiceException("close method has already been invoked");
        }
        Fiber fiber = this.engine.createFiber();
        Tube tube = pool.take();
        try {
            packet3 = fiber.runSync(tube, packet);
            packet2 = fiber.getPacket() == null ? packet : fiber.getPacket();
        }
        catch (Throwable throwable) {
            Packet packet4 = fiber.getPacket() == null ? packet : fiber.getPacket();
            responseContextReceiver.setResponseContext(new ResponseContext(packet4));
            pool.recycle(tube);
            throw throwable;
        }
        responseContextReceiver.setResponseContext(new ResponseContext(packet2));
        pool.recycle(tube);
        return packet3;
    }

    private void configureRequestPacket(Packet packet, RequestContext requestContext) {
        Header[] headerArray;
        packet.proxy = this;
        packet.handlerConfig = this.binding.getHandlerConfig();
        requestContext.fill(packet, this.binding.getAddressingVersion() != null);
        if (this.wsdlProperties != null) {
            packet.addSatellite(this.wsdlProperties);
        }
        if (this.addrVersion != null) {
            headerArray = packet.getMessage().getHeaders();
            headerArray.fillRequestAddressingHeaders(this.wsdlPort, this.binding, packet);
            if (this.endpointReference != null) {
                this.endpointReference.addReferenceParameters(packet.getMessage().getHeaders());
            }
        }
        if ((headerArray = this.userOutboundHeaders) != null) {
            packet.getMessage().getHeaders().addAll(headerArray);
        }
    }

    protected final void processAsync(Packet packet, RequestContext requestContext, final Fiber.CompletionCallback completionCallback) {
        this.configureRequestPacket(packet, requestContext);
        final Pool<Tube> pool = this.tubes;
        if (pool == null) {
            throw new WebServiceException("close method has already been invoked");
        }
        Fiber fiber = this.engine.createFiber();
        final Tube tube = pool.take();
        fiber.start(tube, packet, new Fiber.CompletionCallback(){

            @Override
            public void onCompletion(@NotNull Packet packet) {
                pool.recycle(tube);
                completionCallback.onCompletion(packet);
            }

            @Override
            public void onCompletion(@NotNull Throwable throwable) {
                completionCallback.onCompletion(throwable);
            }
        });
    }

    @Override
    public void close() {
        if (this.tubes != null) {
            Tube tube = this.tubes.take();
            this.tubes = null;
            tube.preDestroy();
        }
        if (this.managedObjectManagerClosed) {
            return;
        }
        MonitorBase.closeMOM(this.managedObjectManager);
        this.managedObjectManagerClosed = true;
    }

    @Override
    public final WSBinding getBinding() {
        return this.binding;
    }

    @Override
    public final Map<String, Object> getRequestContext() {
        return this.requestContext.getMapView();
    }

    public final ResponseContext getResponseContext() {
        return this.responseContext;
    }

    @Override
    public void setResponseContext(ResponseContext responseContext) {
        this.responseContext = responseContext;
    }

    public String toString() {
        return RuntimeVersion.VERSION + ": Stub for " + this.getRequestContext().get("javax.xml.ws.service.endpoint.address");
    }

    @Override
    public final WSEndpointReference getWSEndpointReference() {
        Object object;
        if (this.binding.getBindingID().equals("http://www.w3.org/2004/08/wsdl/http")) {
            throw new UnsupportedOperationException(ClientMessages.UNSUPPORTED_OPERATION("BindingProvider.getEndpointReference(Class<T> class)", "XML/HTTP Binding", "SOAP11 or SOAP12 Binding"));
        }
        if (this.endpointReference != null) {
            return this.endpointReference;
        }
        String string = this.requestContext.getEndpointAddress().toString();
        QName qName = null;
        String string2 = null;
        ArrayList<WSEndpointReference.EPRExtension> arrayList = new ArrayList<WSEndpointReference.EPRExtension>();
        if (this.wsdlPort != null) {
            qName = this.wsdlPort.getBinding().getPortTypeName();
            string2 = string + "?wsdl";
            try {
                object = ((WSDLPortImpl)this.wsdlPort).getEPR();
                if (object != null) {
                    for (WSEndpointReference.EPRExtension ePRExtension : ((WSEndpointReference)object).getEPRExtensions()) {
                        arrayList.add(new WSEPRExtension(XMLStreamBuffer.createNewBufferFromXMLStreamReader(ePRExtension.readAsXMLStreamReader()), ePRExtension.getQName()));
                    }
                }
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException(xMLStreamException);
            }
        }
        object = AddressingVersion.W3C;
        this.endpointReference = new WSEndpointReference((AddressingVersion)((Object)object), string, this.getServiceName(), this.getPortName(), qName, null, string2, null, arrayList, null);
        return this.endpointReference;
    }

    @Override
    public final W3CEndpointReference getEndpointReference() {
        if (this.binding.getBindingID().equals("http://www.w3.org/2004/08/wsdl/http")) {
            throw new UnsupportedOperationException(ClientMessages.UNSUPPORTED_OPERATION("BindingProvider.getEndpointReference()", "XML/HTTP Binding", "SOAP11 or SOAP12 Binding"));
        }
        return this.getEndpointReference(W3CEndpointReference.class);
    }

    @Override
    public final <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        return this.getWSEndpointReference().toSpec(clazz);
    }

    @Override
    @NotNull
    public ManagedObjectManager getManagedObjectManager() {
        return this.managedObjectManager;
    }

    @Override
    public final void setOutboundHeaders(List<Header> list) {
        if (list == null) {
            this.userOutboundHeaders = null;
        } else {
            for (Header header : list) {
                if (header != null) continue;
                throw new IllegalArgumentException();
            }
            this.userOutboundHeaders = list.toArray(new Header[list.size()]);
        }
    }

    @Override
    public final void setOutboundHeaders(Header ... headerArray) {
        if (headerArray == null) {
            this.userOutboundHeaders = null;
        } else {
            for (Header header : headerArray) {
                if (header != null) continue;
                throw new IllegalArgumentException();
            }
            Header[] headerArray2 = new Header[headerArray.length];
            System.arraycopy(headerArray, 0, headerArray2, 0, headerArray.length);
            this.userOutboundHeaders = headerArray2;
        }
    }

    @Override
    public final List<Header> getInboundHeaders() {
        return Collections.unmodifiableList((HeaderList)this.responseContext.get("com.sun.xml.internal.ws.api.message.HeaderList"));
    }

    @Override
    public final void setAddress(String string) {
        this.requestContext.put("javax.xml.ws.service.endpoint.address", string);
    }
}

