/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.resource.ResourceUrlProvider;
import org.springframework.web.servlet.resource.ResourceUrlProviderExposingInterceptor;

public class ResourceUrlEncodingFilter
extends OncePerRequestFilter {
    private static final Log logger = LogFactory.getLog(ResourceUrlEncodingFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)new ResourceUrlEncodingResponseWrapper(request, response));
    }

    private static class ResourceUrlEncodingResponseWrapper
    extends HttpServletResponseWrapper {
        private HttpServletRequest request;
        private Integer indexLookupPath;

        private ResourceUrlEncodingResponseWrapper(HttpServletRequest request, HttpServletResponse wrapped) {
            super(wrapped);
            this.request = request;
        }

        public String encodeURL(String url) {
            ResourceUrlProvider resourceUrlProvider = this.getResourceUrlProvider();
            if (resourceUrlProvider == null) {
                logger.debug((Object)"Request attribute exposing ResourceUrlProvider not found.");
                return super.encodeURL(url);
            }
            this.initIndexLookupPath(resourceUrlProvider);
            String prefix = url.substring(0, this.indexLookupPath);
            String lookupPath = url.substring(this.indexLookupPath);
            lookupPath = resourceUrlProvider.getForLookupPath(lookupPath);
            return lookupPath != null ? super.encodeURL(prefix + lookupPath) : super.encodeURL(url);
        }

        private ResourceUrlProvider getResourceUrlProvider() {
            String name = ResourceUrlProviderExposingInterceptor.RESOURCE_URL_PROVIDER_ATTR;
            return (ResourceUrlProvider)this.request.getAttribute(name);
        }

        private void initIndexLookupPath(ResourceUrlProvider urlProvider) {
            if (this.indexLookupPath == null) {
                String requestUri = urlProvider.getPathHelper().getRequestUri(this.request);
                String lookupPath = urlProvider.getPathHelper().getLookupPathForRequest(this.request);
                this.indexLookupPath = requestUri.lastIndexOf(lookupPath);
            }
        }
    }
}

