/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.util.HashMap;
import java.util.Map;

public enum VerticalAlign {
    BASELINE(1),
    SUPERSCRIPT(2),
    SUBSCRIPT(3);

    private final int value;
    private static Map<Integer, VerticalAlign> imap;

    private VerticalAlign(int val) {
        this.value = val;
    }

    public int getValue() {
        return this.value;
    }

    public static VerticalAlign valueOf(int type) {
        VerticalAlign align = imap.get(new Integer(type));
        if (align == null) {
            throw new IllegalArgumentException("Unknown vertical alignment: " + type);
        }
        return align;
    }

    static {
        imap = new HashMap<Integer, VerticalAlign>();
        for (VerticalAlign p : VerticalAlign.values()) {
            imap.put(new Integer(p.getValue()), p);
        }
    }
}

