/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Version;

final class DataBlock {
    private final int numDataCodewords;
    private final byte[] codewords;

    private DataBlock(int numDataCodewords, byte[] codewords) {
        this.numDataCodewords = numDataCodewords;
        this.codewords = codewords;
    }

    static DataBlock[] getDataBlocks(byte[] rawCodewords, Version version, ErrorCorrectionLevel ecLevel) {
        int i;
        Version.ECB[] ecBlockArray;
        if (rawCodewords.length != version.getTotalCodewords()) {
            throw new IllegalArgumentException();
        }
        Version.ECBlocks ecBlocks = version.getECBlocksForLevel(ecLevel);
        int totalBlocks = 0;
        Version.ECB[] eCBArray = ecBlockArray = ecBlocks.getECBlocks();
        int n = ecBlockArray.length;
        int n2 = 0;
        while (n2 < n) {
            Version.ECB ecBlock = eCBArray[n2];
            totalBlocks += ecBlock.getCount();
            ++n2;
        }
        DataBlock[] result = new DataBlock[totalBlocks];
        int numResultBlocks = 0;
        Version.ECB[] eCBArray2 = ecBlockArray;
        int n3 = ecBlockArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Version.ECB ecBlock = eCBArray2[n4];
            i = 0;
            while (i < ecBlock.getCount()) {
                int numDataCodewords = ecBlock.getDataCodewords();
                int numBlockCodewords = ecBlocks.getECCodewordsPerBlock() + numDataCodewords;
                result[numResultBlocks++] = new DataBlock(numDataCodewords, new byte[numBlockCodewords]);
                ++i;
            }
            ++n4;
        }
        int shorterBlocksTotalCodewords = result[0].codewords.length;
        int longerBlocksStartAt = result.length - 1;
        while (longerBlocksStartAt >= 0) {
            int numCodewords = result[longerBlocksStartAt].codewords.length;
            if (numCodewords == shorterBlocksTotalCodewords) break;
            --longerBlocksStartAt;
        }
        ++longerBlocksStartAt;
        int shorterBlocksNumDataCodewords = shorterBlocksTotalCodewords - ecBlocks.getECCodewordsPerBlock();
        int rawCodewordsOffset = 0;
        i = 0;
        while (i < shorterBlocksNumDataCodewords) {
            int j = 0;
            while (j < numResultBlocks) {
                result[j].codewords[i] = rawCodewords[rawCodewordsOffset++];
                ++j;
            }
            ++i;
        }
        int j = longerBlocksStartAt;
        while (j < numResultBlocks) {
            result[j].codewords[shorterBlocksNumDataCodewords] = rawCodewords[rawCodewordsOffset++];
            ++j;
        }
        int max = result[0].codewords.length;
        int i2 = shorterBlocksNumDataCodewords;
        while (i2 < max) {
            int j2 = 0;
            while (j2 < numResultBlocks) {
                int iOffset = j2 < longerBlocksStartAt ? i2 : i2 + 1;
                result[j2].codewords[iOffset] = rawCodewords[rawCodewordsOffset++];
                ++j2;
            }
            ++i2;
        }
        return result;
    }

    int getNumDataCodewords() {
        return this.numDataCodewords;
    }

    byte[] getCodewords() {
        return this.codewords;
    }
}

