/*
 * Decompiled with CFR 0.152.
 */
package com.llisoft.common.util;

import com.llisoft.common.util.ResourceLoader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PropertiesUtil {
    private static ResourceLoader loader = ResourceLoader.getInstance();
    private static ConcurrentMap<String, String> configMap = new ConcurrentHashMap<String, String>();
    private static final String DEFAULT_CONFIG_FILE = "project_config.properties";
    private static Properties prop = null;

    public static String getStringByKey(String key, String propName) {
        try {
            prop = loader.getPropFromProperties(propName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        key = key.trim();
        if (!configMap.containsKey(key) && prop.getProperty(key) != null) {
            configMap.put(key, prop.getProperty(key));
        }
        return (String)configMap.get(key);
    }

    public static String[] getStringByKey(String[] keys, String propName) {
        String[] resArray = new String[keys.length];
        try {
            prop = loader.getPropFromProperties(propName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int i = 0;
        while (i < keys.length) {
            String key = keys[i].trim();
            if (!configMap.containsKey(key) && prop.getProperty(key) != null) {
                configMap.put(key, prop.getProperty(key));
            }
            resArray[i] = (String)configMap.get(key);
            ++i;
        }
        return resArray;
    }

    public static String getStringByKey(String key) {
        return PropertiesUtil.getStringByKey(key, DEFAULT_CONFIG_FILE);
    }

    public static String[] getStringArrayByKey(String[] keys) {
        return PropertiesUtil.getStringByKey(keys, DEFAULT_CONFIG_FILE);
    }

    public static String getStringByKeyNotInCache(String key, String propName) {
        try {
            prop = loader.getPropFromProperties(propName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        key = key.trim();
        return prop.getProperty(key);
    }

    public static String[] getStringByKeyNotInCache(String[] keys, String propName) {
        String[] resArray = new String[keys.length];
        try {
            prop = loader.getPropFromProperties(propName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int i = 0;
        while (i < keys.length) {
            String key = keys[i].trim();
            resArray[i] = prop.getProperty(key);
            ++i;
        }
        return resArray;
    }

    public static String getStringByKeyNotInCache(String key) {
        return PropertiesUtil.getStringByKeyNotInCache(key, DEFAULT_CONFIG_FILE);
    }

    public static String[] getStringArrayByKeyNotInCache(String[] keys) {
        return PropertiesUtil.getStringByKeyNotInCache(keys, DEFAULT_CONFIG_FILE);
    }

    public static Properties getProperties() {
        try {
            return loader.getPropFromProperties(DEFAULT_CONFIG_FILE);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int setProperties(String key, String value, String propName) {
        try {
            if (propName != null) {
                prop = loader.getPropFromProperties(propName);
            } else {
                prop = PropertiesUtil.getProperties();
                propName = DEFAULT_CONFIG_FILE;
            }
            prop.setProperty(key, value);
            FileOutputStream fos = new FileOutputStream(propName);
            prop.store(fos, null);
            fos.close();
            return 1;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static int setProperties(String[] keys, String[] values, String propName) {
        try {
            if (propName != null) {
                prop = loader.getPropFromProperties(propName);
            } else {
                prop = PropertiesUtil.getProperties();
                propName = DEFAULT_CONFIG_FILE;
            }
            int i = 0;
            while (i < keys.length) {
                String key = keys[i].trim();
                String value = values[i].trim();
                prop.setProperty(key, value);
                ++i;
            }
            FileOutputStream fos = new FileOutputStream(String.valueOf(PropertiesUtil.class.getResource("/").getPath()) + "/" + propName);
            prop.store(fos, null);
            fos.close();
            return 1;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return -1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }
}

