/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.io;

import java.io.InputStream;
import java.net.URL;

public class ClassLoaderWrapper {
    ClassLoader defaultClassLoader;
    ClassLoader systemClassLoader;

    ClassLoaderWrapper() {
        try {
            this.systemClassLoader = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public URL getResourceAsURL(String resource) {
        return this.getResourceAsURL(resource, this.getClassLoaders(null));
    }

    public URL getResourceAsURL(String resource, ClassLoader classLoader) {
        return this.getResourceAsURL(resource, this.getClassLoaders(classLoader));
    }

    public InputStream getResourceAsStream(String resource) {
        return this.getResourceAsStream(resource, this.getClassLoaders(null));
    }

    public InputStream getResourceAsStream(String resource, ClassLoader classLoader) {
        return this.getResourceAsStream(resource, this.getClassLoaders(classLoader));
    }

    public Class<?> classForName(String name) throws ClassNotFoundException {
        return this.classForName(name, this.getClassLoaders(null));
    }

    public Class<?> classForName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        return this.classForName(name, this.getClassLoaders(classLoader));
    }

    InputStream getResourceAsStream(String resource, ClassLoader[] classLoader) {
        ClassLoader[] classLoaderArray = classLoader;
        int n = classLoader.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader cl = classLoaderArray[n2];
            if (cl != null) {
                InputStream returnValue = cl.getResourceAsStream(resource);
                if (returnValue == null) {
                    returnValue = cl.getResourceAsStream("/" + resource);
                }
                if (returnValue != null) {
                    return returnValue;
                }
            }
            ++n2;
        }
        return null;
    }

    URL getResourceAsURL(String resource, ClassLoader[] classLoader) {
        ClassLoader[] classLoaderArray = classLoader;
        int n = classLoader.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader cl = classLoaderArray[n2];
            if (cl != null) {
                URL url = cl.getResource(resource);
                if (url == null) {
                    url = cl.getResource("/" + resource);
                }
                if (url != null) {
                    return url;
                }
            }
            ++n2;
        }
        return null;
    }

    Class<?> classForName(String name, ClassLoader[] classLoader) throws ClassNotFoundException {
        ClassLoader[] classLoaderArray = classLoader;
        int n = classLoader.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader cl = classLoaderArray[n2];
            if (cl != null) {
                try {
                    Class<?> c = Class.forName(name, true, cl);
                    if (c != null) {
                        return c;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        throw new ClassNotFoundException("Cannot find class: " + name);
    }

    ClassLoader[] getClassLoaders(ClassLoader classLoader) {
        return new ClassLoader[]{classLoader, this.defaultClassLoader, Thread.currentThread().getContextClassLoader(), this.getClass().getClassLoader(), this.systemClassLoader};
    }
}

