/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.channel.netty;

import com.taobao.top.link.Logger;
import com.taobao.top.link.Text;
import com.taobao.top.link.channel.ChannelContext;
import com.taobao.top.link.channel.ChannelHandler;
import com.taobao.top.link.channel.netty.NettyClientChannel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public class NettyClientUpstreamHandler
extends SimpleChannelUpstreamHandler {
    protected Logger logger;
    protected NettyClientChannel clientChannel;
    protected String closedReason;

    public NettyClientUpstreamHandler(Logger logger, NettyClientChannel clientChannel) {
        this.logger = logger;
        this.clientChannel = clientChannel;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.clientChannel.setChannel(ctx.getChannel());
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.closedReason == null) {
            this.logger.warn(Text.CHANNEL_CLOSED);
        }
        if (this.haveHandler()) {
            this.getHandler().onClosed(this.closedReason);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (this.haveHandler()) {
            this.getHandler().onError(this.createContext(e.getCause()));
        }
        this.clear(ctx);
        this.logger.error(Text.ERROR_AT_CLIENT, e.getCause());
    }

    protected boolean haveHandler() {
        return this.clientChannel != null && this.clientChannel.getChannelHandler() != null;
    }

    protected ChannelHandler getHandler() {
        return this.clientChannel.getChannelHandler();
    }

    protected ChannelContext createContext(Object message) {
        ChannelContext ctx = new ChannelContext();
        ctx.setSender(this.clientChannel);
        ctx.setMessage(message);
        return ctx;
    }

    protected ChannelContext createContext(Throwable error) {
        ChannelContext ctx = new ChannelContext();
        ctx.setSender(this.clientChannel);
        ctx.setError(error);
        return ctx;
    }

    protected void clear(ChannelHandlerContext ctx) {
        ctx.getChannel().close();
    }
}

