﻿var items_uid = new Array();
var items_name=new Array();
var items_Email = new Array();
$(function() {
	$('#updateWin').window({
		width : 830,
		height : 445,
		draggable : false,
		resizable : false,
		collapsible : false,
		minimizable : true,
		maximizable : true,
		closable : true,
		closed : true,
		inline : true,
		title : '编辑公告',
		modal : true,
		onClose:function(){
			$("#msgid").val(0);
			$("#msgtitle1").val("");
			msgContentEditor.setContent("");
		},
		onOpen: function(){
			$(".panel").css("z-index","9999");
			$(".window-shadow").css("z-index","2");
			$(".window-mask").css("z-index","1");
		},
		onMove:function(){
			$(".panel").css("z-index","999");
			$(".window-shadow").css("z-index","2");
			$(".window-mask").css("z-index","1");
		}
	});

	//编辑已发布的公告，修改内容和标题
	$('#editForm').form({
		url : baseUrl + "/admin/N010/updMessage.html",
		onSubmit : function() {
			return $('#editForm').form("validate");
		},
		success : function(data) {
			$("#tt").tabs("select", 1);
			$('#itemlist').datagrid('reload');
			$('#updateWin').window('close');
		}
	});
	creatGrid();
});

/**
 * easyUi dataGrid注册方式说明，防止二次渲染 class注册方式一般是为了初始化属性，js方式则属性和事件都可初始化
 * 但是不管是class方式还是js方式注册组件，每次注册，只要被设置过url属性就会做请求。
 * 所以在不可避免要使用js方式注册的情况下，索性就不要使用class方式注册了。
 */
function creatGrid() {
	$('#itemlist').datagrid({
		fit : true,// 设置为true时铺满它所在的容器.
		fitColumns : true,// 设置为true将自动使列适应表格宽度以防止出现水平滚动
		nowrap : false,// 设置为true，当数据长度超出列宽时将会自动截取。
		striped : true,// 设置为true将交替显示行背景。
		collapsible : true,// 定义是否显示可折叠按钮。
		singleSelect : false,// 设置为true将只允许选择一行。
		border : false,
		remoteSort : false,// 定义是否通过远程服务器对数据排序。
		pagination : true,// 分页组件是否显示
		pageNumber : 1,// 起始页
		pageSize : 10,// 每页显示的记录条数，默认为10
		pageList : [ 10, 20, 50 ],// 每页显示多少行
		rownumbers : true,// 行号
		url : baseUrl + "/admin/N010/listAllMessage.html",
		// queryParams:{},//查询参数
		// queryParams:data,
		toolbar : '#tbar',
		frozenColumns : [ [ {
			field : 'select',
			title : '选择',
			width : 50,
			checkbox : true
		} ] ],
		columns : [ [ {
			field : 'msgTitle',
			title : '公告标题',
			width : 120,
			sortable : true,
			sorter : datasort,
			align : 'left',
			halign: 'center'
		}, {
			field : 'msgContent',
			title : '公告内容',
			width : 280,
			sortable : true,
			sorter : datasort,
			align : 'left',
			halign: 'center'
		}, {
			field : 'sendTime',
			title : '发布时间',
			width : 80,
			sortable : true,
			sorter : datasort,
			align : 'center',
			formatter : fmdate
		}, 
		{
			field : 'manage',
			title : '操作',
			align : 'center',
			width : 120,
			sortable : true,
			sorter : datasort,
			formatter : fmup
		} ] ],
		// 当数据载入成功时触发。
		onLoadSuccess : function(data) {
			$('.edit_message').linkbutton({
				iconCls : 'icon-edit',
				plain : true
			});
			$('.drop_message').linkbutton({
				iconCls : 'icon-no',
				plain : true
			});
		}
	});
}


function datasort(a, b) {
	return (a > b ? 1 : -1);
}
function seachMessageByParam(){
	var messageName=$("#msgtitleCondition").val();
	var sendTimeStart=$("#sendTimeStartCondition").next().find(".textbox-value").val();
	var sendTimeEnd=$("#sendTimeEndCondition").next().find(".textbox-value").val();
	$('#itemlist').datagrid('load', {
		msgtitle: messageName,
		sendTimeStart:sendTimeStart,
		sendTimeEnd:sendTimeEnd
	});
}

// 打开编辑窗口
function openUpdWin(id) {
	$.post(baseUrl + "/admin/N010/getUpdMessage.html", {
		id: id
	}, 
	function(data) {
		// 为更新form赋值
		$("#msgid").val(data.id);
		$("#msgtitle1").val(data.msgtitle);
		msgContentEditor.setContent(data.msgcontent);
	}, "json");
	$('#updateWin').window('open');
}

function creatNews() {
	$("#msgid").val(0);
	$('#updateWin').window('open');
}

function fmup(value, rowData, rowIndex) {
	var id = rowData.id;
	var str="<a onclick='openUpdWin("+ id+ ")' class='edit_message'>编辑</a>";
	str += "<a onclick='delMessageById("+ id+ ");' class='drop_message'>删除</a>";
	return str;
}

// 日期转换
function fmdate(value, rowData, rowIndex) {
	// fmtLongDate--common.js
	return fmtLongDate(new Date(value));
}
// 刷新
function reloadGrid() {
	$('#itemlist').datagrid('clearSelections');
	$('#itemlist').datagrid('reload');
}

//更新公告
function editForm(){
	$('#editForm').submit();
}

// 删除公告提示
function delMessage() {
	$.messager.confirm('删除提示', '确定要删除选中公告?', function(r) {
		if (r) {
			delMsg();
		}
	});
}
// 删除公告
function delMsg() {
	var items_id = new Array();
	var items = $('#itemlist').datagrid('getSelections');
	if (items.length <= 0) {
		msgShow('请选择要删除的公告');
		return;
	}
	// 获取选中消息的ID，并组成集合
	for ( var i = 0; i < items.length; i++) {
		items_id.push(items[i].id);
	}

	$.post(baseUrl + "/admin/N010/deleteMtaSysMessage.html", {
		mid : items_id
	}, function(data) {
		if (data > 0) {
			msgShow('删除成功');
			reloadGrid();
		} else {
			msgShow('删除失败，请稍后重试');
			reloadGrid();
		}
	}, "json");
}
//单个删除
function delMessageById(mId) {
	$.messager.confirm('删除提示', '确定要删除这条公告?', function(r) {
		if (r) {
			$.post(baseUrl + "/admin/N010/deleteMessage.html", {
				id : mId
			}, function(data) {
				if (data > 0) {
					msgShow('删除成功');
					reloadGrid();
				} else {
					msgShow('删除失败，请稍后重试');
					reloadGrid();
				}
			}, "json");
		}
	});
}
