﻿$(function() {
	creatGrid();
});

/**
 * easyUi dataGrid注册方式说明，防止二次渲染 class注册方式一般是为了初始化属性，js方式则属性和事件都可初始化
 * 但是不管是class方式还是js方式注册组件，每次注册，只要被设置过url属性就会做请求。
 * 所以在不可避免要使用js方式注册的情况下，索性就不要使用class方式注册了。
 */
function creatGrid() {
	$('#itemlist').datagrid(
		{
			fit : true,// 设置为true时铺满它所在的容器.
			fitColumns : true,// 设置为true将自动使列适应表格宽度以防止出现水平滚动
			nowrap : false,// 设置为true，当数据长度超出列宽时将会自动截取。
			striped : true,// 设置为true将交替显示行背景。
			collapsible : true,// 定义是否显示可折叠按钮。
			singleSelect : false,// 设置为true将只允许选择一行。
			border : false,
			remoteSort : false,// 定义是否通过远程服务器对数据排序。
			pagination : true,// 分页组件是否显示
			pageNumber : 1,// 起始页
			pageSize : 15,// 每页显示的记录条数，默认为10
			pageList : [ 15, 30, 50 ],// 每页显示多少行
			rownumbers : true,// 行号
			idField : 'dailyid',
			url : baseUrl + '/admin/T100/listDailyPractice.html',
			toolbar : '#tbar',
			frozenColumns : [ [ {
				field : 'select',title : '选择',width : 50,checkbox : true
			} ] ],
			columns : [ [ {
				field : 'name',
				title : '名称',
				width : 250,
				fixed : true,
				align : 'left',
				sortable : true,
				sorter : datasort,
				formatter:titleLength
			},{
				field : 'totalTm',
				title : '答卷时长',
				width : 60,
				align : 'center',
				sortable : true,
				sorter : datasort
			},{
				field : 'totalsorce',
				title : '总分',
				width : 60,
				align : 'center',
				sortable : true,
				sorter : datasort
			},{
				field : 'groupName',
				title : '可练用户组',
				width : 500,
				align : 'center',
				sortable : true,
				sorter : datasort
			},{
				field : 'username',
				title : '创建人',
				width : 80,
				align : 'center',
				sortable : true,
				sorter : datasort
			},{
				field : 'insDate',
				title : '创建时间',
				width : 120,
				align : 'center',
				sortable : true,
				sorter : datasort,
				formatter : fmdate
			},{
				field : 'dailyid',
				title : '操作',
				align : 'center',
				width : 120,
				formatter : operate
			} ] ],
			// 当数据载入成功时触发。
			onLoadSuccess : function(data) {
				$('.edit_course').linkbutton({
					iconCls : 'icon-edit',
					plain : true
				});
				$('.drop_course').linkbutton({
					iconCls : 'icon-no',
					plain : true
				});
			}
		});
}
function titleLength(value, rowData, rowIndex){
	if(value.length>20){
		return value.substr(0,20);
	}
	return value;
}

function operate(value, rowData, rowIndex) {
	return "<a onclick='editById(" + value + ")' class='edit_course'>编辑</a>" +
		"<a onclick='delById(" + value + ")' class='drop_course' >删除</a>";
}

// 排序
function datasort(a, b) {
	return (a > b ? 1 : -1);
}

// 日期转换
function fmdate(value, rowData, rowIndex) {
	// fmtLongDate--common.js
	if (value != null && value != '') {
		return fmtLongDate(new Date(value));
	}
	return "";
}

// 查询
function seachByParam() {
	var param = {
		title : '',
		username : ''
	};

	param.title = $("#searchtitle").val();
	param.username = $("#username").val();
	$('#itemlist').datagrid('load', param);
}
//添加考试
function addDailyPractice() {
	window.parent.openTab("编辑每日一练", baseUrl + "/admin/T100/saveDailyPracticeLoad.html");
}
//编辑考试
function editById(id) {
	window.parent.closeTabByTitle("编辑每日一练");
	window.parent.openTab("编辑每日一练", baseUrl + "/admin/T100/editDailyPracticeLoad.html?id="+id);
}
function delById(id){
	$.messager.confirm('删除提示', '确定要删除选中每日一练?', function(r) {
		if (r) {
			var ids = new Array();
			ids.push(id);
			$.ajax({
				url: baseUrl + '/admin/T100/removeDailyPractice.html',
				type:'post',
				data: {'ids':ids},
				success : function(result){
					$('#itemlist').datagrid('reload');
				}
			});
		}
	});
}
function deleteDailyPractice(){
	$.messager.confirm('删除提示', '确定要删除选中每日一练?', function(r) {
		if (r) {
			var items = $('#itemlist').datagrid('getSelections');
			var ids = new Array();
			for(var i in items){
				ids.push(items[i].dailyid);
			}
			$.ajax({
				url: baseUrl + '/admin/T100/removeDailyPractice.html',
				data: {'ids':ids},
				type: 'post',
				dataType: 'json',
				success : function(result){
					$('#itemlist').datagrid('reload');
				}
			});
		}
	});
}