// 操作ini文件

function parseINIString(data){
	var regex = {
		section: /^\s*\[\s*([^\]]*)\s*\]\s*$/,
		param: /^\s*([\w\.\-\_]+)\s*=\s*(.*?)\s*$/,
		comment: /^\s*;.*$/
	};
	var value = {};
	var lines = data.split(/\r\n|\r|\n/);
	var section = null;
	for(var key in lines){
		line = lines[key];
		if(regex.comment.test(line)){
			continue;
		}else if(regex.param.test(line)){
			var match = line.match(regex.param);
			var m2 = match[2];
			if( m2 == "true" ) { m2 = true; } else if( m2 == "false"){ m2 = false; }
			if(section){
				value[section][match[1]] = m2;
			}else{
				value[match[1]] = m2;
			}
		}else if(regex.section.test(line)){
			var match = line.match(regex.section);
			value[match[1]] = {};
			section = match[1];
		}else if(line.length == 0 && section){
			section = null;
		}
	}
	return value;
}
