unit Ini;

interface
uses
  inifiles,SysUtils,Dialogs,Classes;
Type
  TIni = class(TInifile)
  private
    IniFileName :String;
    FilePath:String;
    Section:String;
    Key:String;
    Value:String;
  public
    constructor Create(const FileName_:String;Section_:String=''; Ident_:string='');
    destructor Destroy; override;
    function G(const Section_:string; Ident_: string=''; Val_: string=''):String;
    procedure W(const Section_:string; Ident_: string=''; Val_: string='');
    procedure ParsingKey(const Section_:String=''; Ident_:string=''; Val_:string='');
  protected
  
  end;
implementation

{ֵԱΪsection:key}

constructor TIni.Create(const FileName_:String;Section_:String=''; Ident_:string='');
begin
     FilePath := ExtractFilePath(paramstr(0)) + 'inc\' ;
     IniFileName:=FilePath +FileName_ +'.ini';

     ParsingKey(Section_,Ident_,'');
     inherited Create(IniFileName);
end;
destructor TIni.Destroy;
begin
     inherited Destroy;
end;

function TIni.G(const Section_:string; Ident_: string=''; Val_: string=''):String;
begin
     ParsingKey(Section_, Ident_, Val_);
     result :='';
     if (length(Section)  >0) and (length(Key)>0) then
       result := ReadString(Section,Key,Value) ;
end;

procedure TIni.W(const Section_:string; Ident_: string=''; Val_: string='');
begin
     ParsingKey(Section_, Ident_, Val_);
     if (length(Section)  >0) and (length(Key)>0) then
       exit;
    
     WriteString(Section,Key,Value);
end;




procedure TIni.ParsingKey(const Section_:String=''; Ident_:string=''; Val_:string='');
var i:integer;
var li:TStringlist;
begin
   //Section:='';
   //Key:='';
   //Value:='';

   if (length(Section_)>0) and  (length(Ident_)>0) and   (length(Val_)>0) then
   begin
      Section:=Section_;
      Key:=Ident_;
      Value:=Val_ ;
   end
   else if (length(Section_)>0) and  (length(Ident_)>0) then
   begin
      Section:=Section_;
      Key:=Ident_;     
   end
   else if  length(Section_)>0 then
   begin
      if POS(':',Section_)>0 then
      begin
         li:= TStringlist.Create;
         li.Delimiter := ':';
         li.DelimitedText := Section_;
         Section:=li.Strings[0];
         if li.Count>1 then
            Key:= li.Strings[1];
         if li.Count>2 then
            Value:= li.Strings[2];
      end
      else
      begin
          Section:=Section_;
      end;
   end;
end;

end.
