unit app;

interface
  uses
    Classes,Windows,SysUtils,Dialogs,appVariable,Ini, appFun;

  Type
    recordsArrayList = array of TStringList;

    TcommOperat= Class(TObject)
    public
      constructor Create;
      destructor Destroy; override;

      function GetHex(val:integer):byte;
      function BDCToInt(val:Cardinal):integer;
      procedure GetSet;

      function CardNumber(cardNo:Cardinal):string;

      procedure DataReset(var data: array of Byte);
      procedure GetBuffData(sn:Cardinal;Action:Integer);

      //п
      function SearchControlers(sn:Cardinal=0):TControllerType;

      //ѯ״̬
      function ControlersStatus(sn:Cardinal):TStringList;

      //Ŷ
      function OpenDoor(sn:Cardinal; door:Integer):Integer;
      //ȡʱ
      function GetControllerTime(sn:Cardinal):String;
      //ÿʱ
      function SetControllerTime(sn:Cardinal;ValDateTime:TDateTime):Integer;
      //ȡˢ¼  ŷʽȡ
      function GetRecords(sn:Cardinal;indexValue:Cardinal):TStringList;

      //ȡ¼
      function GetRecordList(sn:Cardinal;rcount:Integer=2000):recordsArrayList;

      //Ѷȡļ¼
      function SetRecordsFlat(sn:Cardinal;indexValue:Cardinal):Integer;
      //ȡѻȡļ¼
      function GetFlatRecords(sn:Cardinal):Integer;


      //ɾȨ
      function DelCompetence(sn:Cardinal;cardNo:Cardinal):Integer;
      //Ȩ
      function ClearCompetence(sn:Cardinal):Integer;
      //ѯȨ޵
      function GetCompetenceTotle(sn:Cardinal):Integer;

      //ȡȨ
      function GetCompetence(sn:Cardinal;indexVal:integer;var data:TStringList):integer;
      function GetCompetenceList(sn:Cardinal):recordsArrayList;

      //ѯȨ
      function CheckCompetence(sn:Cardinal;cardNo:Cardinal):Integer;
      //ò  ſƲ(/ʱ)
      function SetConfig(sn:Cardinal;door:Cardinal;Online:Cardinal;Delay:Cardinal):Integer;
      //޸Ȩ
      function UpdateCompetence(sn:Cardinal;cardNo:Cardinal;sTime:TDateTime;eTime:TDateTime;door:array of Cardinal):Integer;

      //ÿIP
      function SetControlersIp(sn:Cardinal;Ip,gateWay:string;subnetMask:string='255.255.255.0'):Integer;

      //ȡſƲ(/ʱ)
      function GetControlersConfig(sn:Cardinal;door:integer):TStringList;

      //ýշIPͶ˿
      function SetServerIp(sn:Cardinal;Ip:string; Port:Integer=60000; sendType:Integer=$ff):integer;

      //ȡշIPͶ˿
      function GetServerIp(sn:Cardinal):TStringList;
    end;
    
  var
    UDP_operat: TcommOperat;
implementation
    uses WinControls, Unit_Main;

constructor TcommOperat.Create;
begin
   inherited Create();
   controllerCount:=0;
end;
destructor TcommOperat.Destroy;
begin
    inherited Destroy;
end;


//ȡini
procedure TcommOperat.GetSet;
var
  ini: TIni;
  i,n:Integer;
  iniKey:string;
begin
    ini:=  TIni.Create(IniConfigPath);
    controllerCount:=ini.ReadInteger('site','count1',0);
    ReceiveTimeout:= ini.ReadInteger('site','ReceiveTimeout',400);
    i:=0;
    if controllerCount>0 then
    begin
       for n:=0 to  controllerCount-1 do begin
         iniKey:= 'controller'+inttostr(n+1);
         controllerList[n].title :=ini.ReadString(iniKey,'title','');
         controllerList[n].sn :=ini.ReadInteger(iniKey,'sn',0);
         controllerList[n].controllerIP:=(ini.ReadString(iniKey,'ip',''));
         controllerList[n].controllerPort:=(ini.ReadInteger(iniKey,'controllerPort',60000));
         controllerList[n].mac:=(ini.ReadString(iniKey,'mac',''));
         controllerList[n].subnetMask:=(ini.ReadString(iniKey,'subnetMask',''));
         controllerList[n].gateWay:=(ini.ReadString(iniKey,'gateWay',''));
         controllerList[n].serverIP:=(ini.ReadString(iniKey,'serverIP',''));
         controllerList[n].serverPort:=ini.ReadInteger(iniKey,'serverPort',0);
         controllerList[n].v:=(ini.ReadString(iniKey,'v',''));
         controllerList[n].vTime:=ini.ReadString(iniKey,'vTime','');
         i:=i+1;
         if i>3 then Break;
       end;
    end;
    ini.Destroy;
end;


function TcommOperat.GetHex(val:integer):byte; //ȡHexֵ, Ҫʱʽ
begin
  GetHex :=  ((val mod 10) + (((val -(val mod 10)) div 10) mod  10) *16);
end;

function TcommOperat.BDCToInt(val:Cardinal):integer;
begin
   BDCToInt:= trunc(val-((val/16)*6));
end;

function TcommOperat.CardNumber(cardNo:Cardinal):string;
var str:string;
begin
   str:= '0000'+IntToStr(cardNo);
   Result:= Copy(str,Length(str)-7,8);
end;

//÷Ͱ
procedure TcommOperat.DataReset(var data: array of Byte);
var
i:integer;
begin
  for i:=0 to Length(data)-1 do data[i]:= 0;
end;


//ȡݹ
procedure TcommOperat.GetBuffData(sn:Cardinal;Action:Integer);

begin

   Self.DataReset(appVariable.BuffData);
   appVariable.BuffData[0] :=  appVariable.PacketType;
   appVariable.BuffData[1] :=  Action;
   CopyMemory(@(appVariable.BuffData[4]),@sn,4);
end;




//ҿ
function TcommOperat.SearchControlers(sn:Cardinal): TControllerType;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  resval:Integer;
  tempval:Cardinal;
begin
  Self.GetBuffData(sn,appVariable.SEARCH_CONTROLLER);
  resval:=frm_Main.send(appVariable.BuffData,recvBuff);
  if resval=1 then begin
      CopyMemory(@Result.sn, @(recvBuff[4]),4); //SN

      //ip 192.168.1.1
      //CopyMemory(@tempval, @(recvBuff[8]),1);
      tempval:= recvBuff[8];
      Result.controllerIP:=IntToStr(tempval);

      //CopyMemory(@tempval, @(recvBuff[9]),1);
      tempval:= recvBuff[9];
      Result.controllerIP:=Result.controllerIP+'.'+IntToStr(tempval);

      //CopyMemory(@tempval, @(recvBuff[10]),1);
      tempval:= recvBuff[10];
      Result.controllerIP:=Result.controllerIP+'.'+IntToStr(tempval);

      //CopyMemory(@tempval, @(recvBuff[11]),1);
      tempval:= recvBuff[11];
      Result.controllerIP:=Result.controllerIP+'.'+IntToStr(tempval);

      //
      tempval:= recvBuff[12];
      Result.subnetMask:=IntToStr(tempval);

      tempval:= recvBuff[13];
      Result.subnetMask:=Result.subnetMask+'.'+IntToStr(tempval);

      tempval:= recvBuff[14];
      Result.subnetMask:=Result.subnetMask+'.'+IntToStr(tempval);

      tempval:= recvBuff[15];
      Result.subnetMask:=Result.subnetMask+'.'+IntToStr(tempval);

      //
      tempval:= recvBuff[16];
      Result.gateWay:=IntToStr(tempval);

      tempval:= recvBuff[17];
      Result.gateWay:=Result.gateWay+'.'+IntToStr(tempval);

      tempval:= recvBuff[18];
      Result.gateWay:=Result.gateWay+'.'+IntToStr(tempval);

      tempval:= recvBuff[19];
      Result.gateWay:=Result.gateWay+'.'+IntToStr(tempval);

      //MACַ
      tempval:= recvBuff[20];
      Result.mac:=IntToStr(tempval);

      tempval:= recvBuff[21];
      Result.mac:=Result.mac+'-'+IntToHex(tempval,2);

      tempval:= recvBuff[22];
      Result.mac:=Result.mac+'-'+IntToHex(tempval,2);

      tempval:= recvBuff[23];
      Result.mac:=Result.mac+'-'+IntToHex(tempval,2);

      tempval:= recvBuff[24];
      Result.mac:=Result.mac+'-'+IntToHex(tempval,2);

      tempval:= recvBuff[25];
      Result.mac:=Result.mac+'-'+IntToHex(tempval,2);

      //汾 (BCDʾ)
      tempval:=recvBuff[26];
      Result.v:= 'V'+IntToStr(tempval);
      tempval:=recvBuff[27];
      Result.v:= Result.v+'.'+IntToStr(tempval);

      //
      Result.vTime:=inttohex(recvBuff[28],2)+inttohex(recvBuff[29],2)+'-'+inttohex(recvBuff[30],2)+'-'+inttohex(recvBuff[31],2);
  end;
end;


//ѯ״̬
function TcommOperat.ControlersStatus(sn:Cardinal):TStringList;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  resval:Integer;
  tempval:Cardinal;
  data: TStringList;
  recordTime,controllerTime:TDateTime;
begin
  data:=TStringList.Create;

  Self.GetBuffData(sn,appVariable.READ_INFO);
  resval:=frm_Main.send(appVariable.BuffData,recvBuff);
  if resval=1 then begin
     //	  	һ¼Ϣ
		 //8-11	һ¼
	   //(=0ʾûм¼)	4	0x00000000
     tempval:=0;
     CopyMemory(@tempval, @(recvBuff[8]),4);  //һ¼
     data.Values['lastID']:= IntToStr(tempval);

     //12	¼
		 //0=޼¼
		 //1=ˢ¼
     //2=Ŵ,ť, 豸, Զ̿ż¼
		 //3=¼	1
     tempval := recvBuff[12];
     data.Values['recordType']:= IntToStr(tempval);

     //13	Ч(0 ʾͨ, 1ʾͨ)	1
	   tempval := recvBuff[13];
     data.Values['valid']:= IntToStr(tempval);

     //14	ź(1,2,3,4)	1
	   tempval := recvBuff[14];
     data.Values['door']:= IntToStr(tempval);

     //15	/(1ʾ, 2ʾ)	1	0x01
     tempval:= recvBuff[15];
     data.Values['inOrOut']:= IntToStr(tempval);

     //16-19	(ˢ¼ʱ)(ͼ¼)	4
     CopyMemory(@tempval, @(recvBuff[16]),4);
     data.Values['cardNo']:= Self.CardNumber(tempval);

     //20-26	ˢʱ:
     TryStrToDateTime((format('%02X%02X-%02X-%02X %02X:%02X:%02X',
     [recvBuff[20],recvBuff[21],recvBuff[22],recvBuff[23],recvBuff[24],recvBuff[25],recvBuff[26]])),recordTime);
     data.Values['iTime']:=FormatDateTime('YYYY-MM-DD HH:mm:ss', recordTime);

     //27	¼ԭ(Բ ˢ¼˵.xlsļReasonNO)  //Ϣ	1
     tempval:= recvBuff[27];
     data.Values['zt']:= IntToStr(tempval);

     //Ϣ
	   //28	1Ŵ(0ʾ, 1ʾ)	1	0x00
		 tempval := recvBuff[28];
     data.Values['Mage1']:= IntToStr(tempval);

		 //29	2Ŵ(0ʾ, 1ʾ)	1	0x00
		 tempval := recvBuff[29];
     data.Values['Mage2']:= IntToStr(tempval);

		 //30	3Ŵ(0ʾ, 1ʾ)	1	0x00
		 tempval := recvBuff[30];
     data.Values['Mage3']:= IntToStr(tempval);

	   //31	4Ŵ(0ʾ, 1ʾ)	1	0x00
	   tempval := recvBuff[31];
     data.Values['Mage4']:= IntToStr(tempval);

	  	//32	1Űť(0ʾɿ, 1ʾ)	1	0x00
		 tempval := recvBuff[32];
     data.Values['push1']:= IntToStr(tempval);

		 //33	2Űť(0ʾɿ, 1ʾ)	1	0x00
		 tempval := recvBuff[33];
     data.Values['push2']:= IntToStr(tempval);
     
		 //34	3Űť(0ʾɿ, 1ʾ)	1	0x00
		 tempval := recvBuff[34];
     data.Values['push3']:= IntToStr(tempval);

		 //35	4Űť(0ʾɿ, 1ʾ)	1	0x00
	   tempval := recvBuff[35];
     data.Values['push4']:= IntToStr(tempval);

		 //36	Ϻ
		 //0 ޹
		 //0, й(ʱ, , Ҫά)	1
		 tempval := recvBuff[36];
     data.Values['errCode']:= IntToStr(tempval);

     //37	ǰʱ
		 //ʱ	1	0x21
		 //38		1	0x30
		 //39		1	0x58

     //40-43	ˮ	4
		 CopyMemory(@tempval, @(recvBuff[40]),4);
     data.Values['serialNumber']:= IntToStr(tempval);

     //48
		 //Ϣ1(ʵʹз)
		 //̰Ϣ	1
		 //49	̵״̬	1
		 tempval := recvBuff[49];
     data.Values['relayStatus']:= IntToStr(tempval);

     //50	Ŵ״̬8-15bitλ[/ǿ]
	   //Bit0  ǿ
	   //Bit1  
		 tempval := recvBuff[50];
     data.Values['otherInputStatus']:= '0';
		 if ((tempval and 1) > 0) then data.Values['otherInputStatus']:= '1';
		 if ((tempval and 2) > 0)  then  data.Values['otherInputStatus']:= '2';

     //51	V5.46汾֧ ǰ	1	0x13
	   //52	V5.46汾֧ 	1	0x06
	   //53	V5.46汾֧ 	1	0x22
     //ǰʱ
     TryStrToDateTime((format('20%02X-%02X-%02X %02X:%02X:%02X',
     [recvBuff[51],recvBuff[52],recvBuff[53],recvBuff[37],recvBuff[38],recvBuff[39]])), controllerTime);
     
     data.Values['controllerTime']:= FormatDateTime('YYYY-MM-DD HH:mm:ss', controllerTime);
  end;

  Result:= data;
end;


//
function TcommOperat.OpenDoor(sn:Cardinal; door:Integer):Integer;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  resval:Integer;
begin
    Self.GetBuffData(sn,appVariable.OPEN_DOOR);
    BuffData[8] := door;
    resval:=frm_Main.send(appVariable.BuffData,recvBuff);
    OpenDoor:=0;
    if resval=1 then begin
      if recvBuff[8]=1 then begin
        OpenDoor:=1;
      end;
    end;
end;


//ȡʱ ɹʱ䴮 Ϊ
function TcommOperat.GetControllerTime(sn:Cardinal):String;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  resval:Integer;
  controllerTime:TDateTime;
begin
    Self.GetBuffData(sn,appVariable.READ_CTIME);  //ȡݰ
    resval:= frm_Main.send(appVariable.BuffData,recvBuff);
    GetControllerTime:='';
    if resval=1 then begin
        controllerTime:=StrToDateTime(format('%02X%02X-%02X-%02X %02X:%02X:%02X',[recvBuff[8],recvBuff[9],recvBuff[10],recvBuff[11],recvBuff[12],recvBuff[13],recvBuff[14]]));
        GetControllerTime:=FormatDateTime('YYYY-MM-DD HH:mm:ss', controllerTime);
    end;
end;


//ÿʱ ɹ1 
function TcommOperat.SetControllerTime(sn:Cardinal;ValDateTime:TDateTime):Integer;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  resval:Integer;
  Year, Month, Day,Hour, Min, Sec, MSec:Word;
begin
  Self.GetBuffData(sn,appVariable.SET_CTIME);  //ȡݰ

  DecodeDate(ValDateTime, Year, Month, Day);
  DecodeTime(ValDateTime, Hour, Min, Sec, MSec);

  appVariable.BuffData[8 + 0] := GetHex((( Year -( Year mod 100)) div 100));
  appVariable.BuffData[8 + 1] := GetHex(Year mod 100);
  appVariable.BuffData[8 + 2] := GetHex(Month);
  appVariable.BuffData[8 + 3] := GetHex(Day);
  appVariable.BuffData[8 + 4] := GetHex(Hour);
  appVariable.BuffData[8 + 5] := GetHex(Min);
  appVariable.BuffData[8 + 6] := GetHex(Sec);

  resval:= frm_Main.send(appVariable.BuffData,recvBuff);
  SetControllerTime:=0;
  if (resval = 1)  then begin
     if (CompareMem(@(appVariable.BuffData[8]),@(recvBuff[8]),7)) then begin
        SetControllerTime:=1;
     end;
  end;   
end;


//ȡˢ¼  ŷʽȡ
function TcommOperat.GetRecords(sn:Cardinal;indexValue:Cardinal):TStringList;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  resval:Integer;
  list :TStringList;
  tempval:Cardinal;
  recordTime:TDateTime;
begin
  Self.GetBuffData(sn,appVariable.READ_FOR_ID);  //ȡݰ
  CopyMemory(@(appVariable.BuffData[8]), @indexValue, 4);

  list:= TStringList.Create;
  resval:=frm_Main.send(appVariable.BuffData,recvBuff);
  if resval=1 then begin
     tempval:=0;
     //8-11 Ϊ¼ID
     CopyMemory(@tempval, @(recvBuff[8]),4);
     if tempval>0 then begin
        list.Values['sn']:= IntToStr(sn); //sn
        list.Values['id']:= IntToStr(tempval); //id

        {12	¼
         0=޼¼
		     1=ˢ¼
		     2=Ŵ,ť, 豸, Զ̿ż¼
		     3=¼	1}
         
        tempval:= recvBuff[12];
        list.Values['recordType']:= IntToStr(tempval);

        //13	Ч(0 ʾͨ, 1ʾͨ)	1
        tempval:= recvBuff[13];
        list.Values['valid']:= IntToStr(tempval);

        //14	ź(1,2,3,4)	1
        tempval:= recvBuff[14];
        list.Values['door']:= IntToStr(tempval);

        //15	/(1ʾ, 2ʾ)	1	0x01
        tempval:= recvBuff[15];
        list.Values['inOrOut']:= IntToStr(tempval);

        //16-19	(ˢ¼ʱ)(ͼ¼)	4
        CopyMemory(@tempval, @(recvBuff[16]),4);
        list.Values['cardNo']:= Self.CardNumber(tempval);

        //20-26	ˢʱ:
        TryStrToDateTime((format('%02X%02X-%02X-%02X %02X:%02X:%02X',
			  [recvBuff[20],recvBuff[21],recvBuff[22],recvBuff[23],recvBuff[24],recvBuff[25],recvBuff[26]]))
        ,recordTime);
        list.Values['iTime']:=FormatDateTime('YYYY-MM-DD HH:mm:ss', recordTime);

        //27	¼ԭ(Բ ˢ¼˵.xlsļReasonNO)  //Ϣ	1
        tempval:= recvBuff[27];
        list.Values['zt']:= IntToStr(tempval);
     end;     
  end;

  GetRecords:=list;
end;


//Ȩޱʶ
function TcommOperat.SetRecordsFlat(sn:Cardinal;indexValue:Cardinal):Integer;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  resval:Integer;
begin
  Self.GetBuffData(sn,appVariable.SET_READ_ON);  //ȡݰ
  CopyMemory(@(appVariable.BuffData[8]), @indexValue, 4);
  resval:=appVariable.SpecialFlag;
  CopyMemory(@(appVariable.BuffData[8 + 4]), @resval, 4);

  SetRecordsFlat:=0;
  resval:=frm_Main.send(appVariable.BuffData,recvBuff);
  if (resval = 1)  then begin
     SetRecordsFlat:=1;
  end;   
end;


//ȡѶȡļ¼[
function TcommOperat.GetFlatRecords(sn:Cardinal):Integer;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  resval:Integer;
  indexNo:Cardinal;
begin
  Self.GetBuffData(sn,appVariable.GET_INDEX_LAST);  //ȡݰ
  resval:=frm_Main.send(appVariable.BuffData,recvBuff);
  GetFlatRecords:=0;
  if (resval = 1)  then begin
      CopyMemory( @indexNo,@(recvBuff[8]), 4);
      GetFlatRecords:= indexNo;
  end;
end;


//1.9	ȡ¼
//1. ͨ 0xB4ָ ȡѶȡļ¼ recordIndex
//2. ͨ 0xB0ָ ȡָŵļ¼  recordIndex + 1ʼȡ¼ ֱ¼ΪΪֹ
//3. ͨ 0xB2ָ Ѷȡļ¼  õֵΪȡˢ¼
//裬 ȡ¼Ĳ
function TcommOperat.GetRecordList(sn:Cardinal;rcount:Integer=2000): recordsArrayList;
var
  indexNo:Cardinal;
  data:TStringList;
  n,l:Integer;
begin
   indexNo:= Self.GetFlatRecords(sn);
  if indexNo>0 then begin
     n:=0;
     l:=0;
     Repeat
       inc(indexNo);
       data:=Self.GetRecords(sn,indexNo);
       if data.Count=0 then Break;//ûиļ¼
       if StrToInt(data.Values['recordType'])=$ff then begin //Ч
          SetLength( Result, 0);
          l:=0;
          Break;
       end;

       SetLength(Result, l+1);
       Result[l] :=data;
       inc(l);
       inc(n);
     until (n > rcount);

     if l>0 then begin //ȡм¼
       if Self.SetRecordsFlat(sn,strtoint(Result[l-1].Values['id']))>0 then begin
         //ȡ
       end;
     end;    
  end
  else begin
    SetLength(Result, 0);
  end;
end;

//ɾȨ
function TcommOperat.DelCompetence(sn:Cardinal;cardNo:Cardinal):Integer;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  resval:Integer;
begin
  Self.GetBuffData(sn,appVariable.DEL_PURVIEW);  //ȡݰ
  CopyMemory(@(appVariable.BuffData[8]),@cardNo,4);

  Result:=0;
  resval:=frm_Main.send(appVariable.BuffData,recvBuff);
  if resval=1 then  Result:=1;
end;


//Ȩ
function TcommOperat.ClearCompetence(sn:Cardinal):Integer;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  i,resval:Integer;
begin
  Self.GetBuffData(sn,appVariable.CLEAR_PURVIEW);  //ȡݰ
  i:= appVariable.SpecialFlag;
  CopyMemory(@(appVariable.BuffData[8]),@i,4);

  Result:=0;
  resval:=frm_Main.send(appVariable.BuffData,recvBuff);
  if resval=1 then begin
    Result:= 1;
  end;
end;


//ȡȨ
function TcommOperat.GetCompetenceTotle(sn:Cardinal):Integer;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  resval:Integer;
  privilegeCount :Integer;
begin
  Result:=0;
  Self.GetBuffData(sn,appVariable.GET_TOTLE_PURVIEW);  //ȡݰ
  resval:=frm_Main.send(appVariable.BuffData,recvBuff);
  if resval=1 then begin
    CopyMemory(@privilegeCount, @(recvBuff[8]),4);
    Result:=privilegeCount;
  end;
end;


//ѯȨ
function TcommOperat.CheckCompetence(sn:Cardinal;cardNo:Cardinal):Integer;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  resval:Integer;
  isYes: Cardinal;
begin
    Result:=0;
    Self.GetBuffData(sn,appVariable.SELECT_PURVIEW);  //ȡݰ
    CopyMemory(@(appVariable.BuffData[8]),@cardNo,4);
    resval:=frm_Main.send(appVariable.BuffData,recvBuff);
    if resval=1 then begin
      if (CompareMem(@isYes,@(recvBuff[8]),4)) then Result:=1;
    end;
end;


//ſƲ(/ʱ)
{SN,ţ״̬3ߣʱ}
function TcommOperat.SetConfig(sn:Cardinal;door:Cardinal;Online:Cardinal;Delay:Cardinal):Integer;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  resval:Integer;
begin
  Result:=0;
  Self.GetBuffData(sn,appVariable.SET_CONFIG);  //ȡݰ
  appVariable.BuffData[8 +0] := door; //2
	appVariable.BuffData[8 +1] := Online; //
	appVariable.BuffData[8 +2] := Delay; //ʱ
  resval:=frm_Main.send(appVariable.BuffData,recvBuff);
  if resval=1 then begin
      if (CompareMem(@(appVariable.BuffData[8]),@(recvBuff[8]),4)) then Result:=1;
  end;
end;


//Ȩӻ޸
function TcommOperat.UpdateCompetence(sn:Cardinal;cardNo:Cardinal;sTime:TDateTime;eTime:TDateTime;door:array of Cardinal):Integer;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  resval:Integer;
  str:string;
  Year, Month, Day,Hour, Min, Sec, MSec:Word;
begin
  Result:=0;
  Self.GetBuffData(sn,appVariable.SET_PURVIEW);  //ȡݰ 
  CopyMemory(@(appVariable.BuffData[8]),@cardNo,4);

  //20 10 01 01 ʼ:  20100101   (2001)
  DecodeDate(sTime, Year, Month, Day);
  DecodeTime(sTime, Hour, Min, Sec, MSec);
  //str:=IntToStr(Year);
	appVariable.BuffData[8 +4] := self.GetHex((( Year -( Year mod 100)) div 100));  
	appVariable.BuffData[8 +5] := self.GetHex(Year mod 100);
	appVariable.BuffData[8 +6] := self.GetHex(Month);
	appVariable.BuffData[8 +7] := self.GetHex(Day);
  
	//20 29 12 31 ֹ:  20291231
  DecodeDate(eTime, Year, Month, Day);
  DecodeTime(eTime, Hour, Min, Sec, MSec);
	appVariable.BuffData[8 +8] := self.GetHex((( Year -( Year mod 100)) div 100)); //self.GetHex(StrToInt(copy(str,1,2)));
	appVariable.BuffData[8 +9] := self.GetHex(Year mod 100); //self.GetHex(StrToInt(copy(str,3,2)));
	appVariable.BuffData[8 +10] := self.GetHex(Month);
	appVariable.BuffData[8 +11] := self.GetHex(Day);
  
	//01 ͨ һ [Ե, ˫, ſЧ]
	appVariable.BuffData[8 +12] := door[0]; //$01;
	//01 ͨ  [˫, ſЧ]
	appVariable.BuffData[8 +13] := door[1]; //$01;  //ֹ2, ֻҪΪ 0x00
	//01 ͨ  [ſЧ]
	//appVariable.BuffData[8 +14] := door[2]; //$01;
	//01 ͨ ĺ [ſЧ]
	//appVariable.BuffData[8 +15] := door[3]; //$01;

  resval:=frm_Main.send(appVariable.BuffData,recvBuff);
  if resval=1 then begin
      Result:=1;
  end;
end;


//ÿIP
function TcommOperat.SetControlersIp(sn:Cardinal;Ip,gateWay:string;subnetMask:string='255.255.255.0'):Integer;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  resval:Integer;
  iparray:TStringList;
begin
  iparray:=split(Ip,'.');
  Self.GetBuffData(sn,appVariable.SET_CONTROLLER_IP);  //ȡݰ
  //ip
  appVariable.BuffData[8 +0]:= StrToInt(iparray.Strings[0]);
  appVariable.BuffData[8 +1]:= StrToInt(iparray.Strings[1]);
  appVariable.BuffData[8 +2]:= StrToInt(iparray.Strings[2]);
  appVariable.BuffData[8 +3]:= StrToInt(iparray.Strings[3]);
  
  //
  iparray:=split(subnetMask,'.');
  appVariable.BuffData[12 +0]:= StrToInt(iparray.Strings[0]);
  appVariable.BuffData[12 +1]:= StrToInt(iparray.Strings[1]);
  appVariable.BuffData[12 +2]:= StrToInt(iparray.Strings[2]);
  appVariable.BuffData[12 +3]:= StrToInt(iparray.Strings[3]);

  
  //
  iparray:=split(gateWay,'.');
  appVariable.BuffData[16 +0]:= StrToInt(iparray.Strings[0]);
  appVariable.BuffData[16 +1]:= StrToInt(iparray.Strings[1]);
  appVariable.BuffData[16 +2]:= StrToInt(iparray.Strings[2]);
  appVariable.BuffData[16 +3]:= StrToInt(iparray.Strings[3]);
  Result:=1;
  
  resval:=frm_Main.send(appVariable.BuffData,recvBuff);
  
end;

//ȡſƲ(/ʱ)
function TcommOperat.GetControlersConfig(sn:Cardinal;door:integer):TStringList;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  resval:Integer;
  tempval:Cardinal;
  data:TStringList;
begin
  data:=TStringList.Create; 
  Self.GetBuffData(sn,appVariable.GET_IN_LINE);  //ȡݰ
  appVariable.BuffData[8]:= door;
  resval:=frm_Main.send(appVariable.BuffData,recvBuff);
  if resval=1 then begin
     CopyMemory(@tempval, @(recvBuff[4]),4);
     data.Values['sn']:=IntToStr(tempval);
     tempval:= recvBuff[8];
     data.Values['door']:=IntToStr(tempval);

     tempval:= recvBuff[9];
     data.Values['doorType']:=IntToStr(tempval);

     tempval:= recvBuff[10];
     data.Values['doorTime']:=IntToStr(tempval);
  end;                       
  GetControlersConfig:=data;
end;

//ýշIPͶ˿
function TcommOperat.SetServerIp(sn:Cardinal;Ip:string; Port:Integer=60000; sendType:Integer=$ff):integer;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  resval:Integer;
  iparray:TStringList;
begin
  Result:=0;
  iparray:=split(Ip,'.');
  Self.GetBuffData(sn,appVariable.SET_SERVER_IP);  //ȡݰ
  //ip
  appVariable.BuffData[8 +0]:= StrToInt(iparray.Strings[0]);
  appVariable.BuffData[8 +1]:= StrToInt(iparray.Strings[1]);
  appVariable.BuffData[8 +2]:= StrToInt(iparray.Strings[2]);
  appVariable.BuffData[8 +3]:= StrToInt(iparray.Strings[3]);

  CopyMemory(@(appVariable.BuffData[12]),@Port,2);
  appVariable.BuffData[14]:= sendType;
  resval:=frm_Main.send(appVariable.BuffData,recvBuff); 
  if resval=1 then begin
     Result:=1;
  end;
end;

//ȡշIPͶ˿
function TcommOperat.GetServerIp(sn:Cardinal):TStringList;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  resval:Integer;
  tempval:Integer;
begin
  Result:= TStringList.Create;
  Self.GetBuffData(sn,appVariable.GET_SERVER_IP);  //ȡݰ
  resval:=frm_Main.send(appVariable.BuffData,recvBuff);
  if resval=1 then begin
     //ip
     tempval:= recvBuff[8];
     Result.Values['serverIP']:= IntToStr(tempval);
     tempval:= recvBuff[9];
     Result.Values['serverIP']:= Result.Values['serverIP']+'.'+IntToStr(tempval);
     tempval:= recvBuff[10];
     Result.Values['serverIP']:= Result.Values['serverIP']+'.'+IntToStr(tempval);
     tempval:= recvBuff[11];
     Result.Values['serverIP']:= Result.Values['serverIP']+'.'+IntToStr(tempval);
     //port
     CopyMemory(@tempval,@(recvBuff[12]),2);
     Result.Values['serverPort']:=IntToStr(tempval);
     //
     tempval:= recvBuff[14];
     Result.Values['sendType']:=IntToStr(tempval);
  end;
end;


//1Ϊȡ¼   2Ϊü¼ɾ   0Ϊλ޼¼  أ1ͨʧ    ݷڲdata
function TcommOperat.GetCompetence(sn:Cardinal;indexVal:integer;var data:TStringList):integer;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  resval:Integer;
  tempval,cardNo:Cardinal;
  recordTime:TDateTime;
begin
  Self.GetBuffData(sn,appVariable.GET_COMPETENCE);  //ȡݰ
  CopyMemory(@(appVariable.BuffData[8]),@indexVal,4);
  resval:=frm_Main.send(appVariable.BuffData,recvBuff);
  Result:=-1;
  if  resval=1 then begin
     CopyMemory(@cardNo,@(recvBuff[8]),4);  //
     
     if cardNo=$ffffffff then begin    //ü¼ɾ
       Result:=2;
     end
     else if cardNo>0 then begin  //м¼
        data.Values['id']:=IntToStr(indexVal);
        data.Values['sn']:=IntToStr(sn);
        data.Values['cardNo']:=self.CardNumber(cardNo);

        //
        TryStrToDateTime(format('%02X%02X-%02X-%02X',[recvBuff[12],recvBuff[13],recvBuff[14],recvBuff[15]]),recordTime);
        data.Values['sd']:=FormatDateTime('YYYY-MM-DD', recordTime);
         //ֹ
        TryStrToDateTime(format('%02X%02X-%02X-%02X',[recvBuff[16],recvBuff[17],recvBuff[18],recvBuff[19]]),recordTime);
        data.Values['ed']:=FormatDateTime('YYYY-MM-DD', recordTime);

        // 1
        tempval:= recvBuff[20];
        data.Values['door1']:=IntToStr(tempval);

        // 2
        tempval:= recvBuff[21];
        data.Values['door2']:=IntToStr(tempval);

        // 3
        tempval:= recvBuff[22];
        data.Values['door3']:=IntToStr(tempval);

        // 4
        tempval:= recvBuff[23];
        data.Values['door4']:=IntToStr(tempval);

        CopyMemory(@tempval,@(recvBuff[24]),3);  //
        data.Values['pass']:=IntToStr(tempval);
        Result:=1;
     end
     else begin   //Ѿ޼¼
        Result:=0;
     end;
  end;
end;

function TcommOperat.GetCompetenceList(sn:Cardinal):recordsArrayList;
var
  recvBuff: array[0..(PacketSize-1)] of Byte;
  resval:Integer;
  data:TStringList;
  tempval,l:Integer;
  indexVal:Integer;
begin
  indexVal:=1;
  l:=0;
  data:= TStringList.Create;
  tempval:=Self.GetCompetence(sn,indexVal,data);
  while tempval>0 do begin
     if  tempval=1 then begin
       SetLength( Result, l+1);
       Result[l]:=data;
       inc(l);
       data:= TStringList.Create;
     end;
     inc(indexVal);
     tempval:=Self.GetCompetence(sn,indexVal,data);
  end;
end;
end.
