


local function OnTaskTick(inst, self, period)
    self:DoDec(period)
end


--
local ml = Class(function(self, inst)
	self.inst = inst
	self.current = 0
	self.max = 100

self.overridestarvefn = nil
local period = 1
self.inst:DoPeriodicTask(period, OnTaskTick, nil, self, period)
end)

function ml:DoDelta(delta)
	local oldval = self.current
	local val = self.current + delta
	if val >= self.max then
		self.current = self.max
	elseif val <= 0 then
		self.current = 0
	else
		self.current = val
	end
	local del = self.current - oldval
	self.inst:PushEvent("ml_delta", {val = self.current, oldval = oldval, delta = del})
end

--浵
function ml:OnSave()
	return 
	{
		current = self.current,
		max = self.max,
	}
end
function ml:OnLoad(data)
	if data then
		self.current = data.current
		self.max = data.max
	end
end


function ml:DoDec(dt, ignore_damage)
   

    
        if self.current > 0 then
            self:DoDelta(-1 * dt * 1 * .3, true)
        elseif not ignore_damage then
            if self.overridestarvefn ~= nil then
                self.overridestarvefn(self.inst, dt)
           
            end
        end
   
end

function ml:GetPercent()
    return self.current / self.max
end


return ml