/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.io.IOException;
import java.io.InputStream;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ResourceFinder;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class BaseLib
extends OneArgFunction
implements ResourceFinder {
    Globals globals;

    public LuaValue call(LuaValue luaValue) {
        this.globals = luaValue.checkglobals();
        this.globals.FINDER = this;
        this.globals.baselib = this;
        luaValue.set("_G", luaValue);
        luaValue.set("_VERSION", "Luaj-jse 3.0-alpha2");
        luaValue.set("assert", (LuaValue)new _assert());
        luaValue.set("collectgarbage", (LuaValue)new collectgarbage());
        luaValue.set("dofile", (LuaValue)new dofile());
        luaValue.set("error", (LuaValue)new error());
        luaValue.set("getmetatable", (LuaValue)new getmetatable());
        luaValue.set("load", (LuaValue)new load());
        luaValue.set("loadfile", (LuaValue)new loadfile());
        luaValue.set("pcall", (LuaValue)new pcall());
        luaValue.set("print", (LuaValue)new print(this));
        luaValue.set("rawequal", (LuaValue)new rawequal());
        luaValue.set("rawget", (LuaValue)new rawget());
        luaValue.set("rawlen", (LuaValue)new rawlen());
        luaValue.set("rawset", (LuaValue)new rawset());
        luaValue.set("select", (LuaValue)new select());
        luaValue.set("setmetatable", (LuaValue)new setmetatable());
        luaValue.set("tonumber", (LuaValue)new tonumber());
        luaValue.set("tostring", (LuaValue)new tostring());
        luaValue.set("type", (LuaValue)new type());
        luaValue.set("xpcall", (LuaValue)new xpcall());
        next next2 = new next();
        luaValue.set("next", (LuaValue)next2);
        luaValue.set("pairs", (LuaValue)new pairs(next2));
        luaValue.set("ipairs", (LuaValue)new ipairs());
        return luaValue;
    }

    public InputStream findResource(String string) {
        return this.getClass().getResourceAsStream(string.startsWith("/") ? string : "/" + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Varargs pcall(LuaValue luaValue, Varargs varargs, LuaValue luaValue2) {
        LuaValue luaValue3 = this.globals.errorfunc;
        this.globals.errorfunc = luaValue2;
        try {
            Varargs varargs2 = BaseLib.varargsOf(LuaValue.TRUE, luaValue.invoke(varargs));
            this.globals.errorfunc = luaValue3;
            return varargs2;
        }
        catch (Throwable throwable) {
            try {
                this.globals.errorfunc = luaValue3;
                throw throwable;
            }
            catch (LuaError luaError) {
                String string = luaError.getMessage();
                return BaseLib.varargsOf(FALSE, (Varargs)(string != null ? BaseLib.valueOf(string) : NIL));
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                return BaseLib.varargsOf(FALSE, (Varargs)BaseLib.valueOf(string != null ? string : exception.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Varargs loadFile(String string, String string2, LuaValue luaValue) {
        InputStream inputStream = this.globals.FINDER.findResource(string);
        if (inputStream == null) {
            return BaseLib.varargsOf(NIL, (Varargs)BaseLib.valueOf("cannot open " + string + ": No such file or directory"));
        }
        try {
            Varargs varargs = this.loadStream(inputStream, "@" + string, string2, luaValue);
            return varargs;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Varargs loadStream(InputStream inputStream, String string, String string2, LuaValue luaValue) {
        try {
            if (inputStream == null) {
                return BaseLib.varargsOf(NIL, (Varargs)BaseLib.valueOf("not found: " + string));
            }
            return LoadState.load(inputStream, string, string2, luaValue);
        }
        catch (Exception exception) {
            return BaseLib.varargsOf(NIL, (Varargs)BaseLib.valueOf(exception.getMessage()));
        }
    }

    private static class StringInputStream
    extends InputStream {
        final LuaValue func;
        byte[] bytes;
        int offset;
        int remaining = 0;

        StringInputStream(LuaValue luaValue) {
            this.func = luaValue;
        }

        public int read() throws IOException {
            if (this.remaining <= 0) {
                LuaValue luaValue = this.func.call();
                if (luaValue.isnil()) {
                    return -1;
                }
                LuaString luaString = luaValue.strvalue();
                this.bytes = luaString.m_bytes;
                this.offset = luaString.m_offset;
                this.remaining = luaString.m_length;
                if (this.remaining <= 0) {
                    return -1;
                }
            }
            --this.remaining;
            return this.bytes[this.offset++];
        }
    }

    static final class inext
    extends VarArgFunction {
        inext() {
        }

        public Varargs invoke(Varargs varargs) {
            return varargs.checktable(1).inext(varargs.arg(2));
        }
    }

    static final class next
    extends VarArgFunction {
        next() {
        }

        public Varargs invoke(Varargs varargs) {
            return varargs.checktable(1).next(varargs.arg(2));
        }
    }

    static final class ipairs
    extends VarArgFunction {
        inext inext = new inext();

        ipairs() {
        }

        public Varargs invoke(Varargs varargs) {
            return ipairs.varargsOf(this.inext, varargs.checktable(1), ZERO);
        }
    }

    static final class pairs
    extends VarArgFunction {
        final next next;

        pairs(next next2) {
            this.next = next2;
        }

        public Varargs invoke(Varargs varargs) {
            return pairs.varargsOf(this.next, varargs.checktable(1), NIL);
        }
    }

    final class xpcall
    extends VarArgFunction {
        xpcall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Varargs invoke(Varargs varargs) {
            if (BaseLib.this.globals != null && BaseLib.this.globals.debuglib != null) {
                BaseLib.this.globals.debuglib.onCall(this);
            }
            try {
                Varargs varargs2 = BaseLib.this.pcall(varargs.arg1(), varargs.subargs(3), varargs.checkvalue(2));
                return varargs2;
            }
            finally {
                if (BaseLib.this.globals != null && BaseLib.this.globals.debuglib != null) {
                    BaseLib.this.globals.debuglib.onReturn();
                }
            }
        }
    }

    static final class type
    extends LibFunction {
        type() {
        }

        public LuaValue call(LuaValue luaValue) {
            return type.valueOf(luaValue.typename());
        }
    }

    static final class tostring
    extends LibFunction {
        tostring() {
        }

        public LuaValue call(LuaValue luaValue) {
            LuaValue luaValue2 = luaValue.metatag(TOSTRING);
            if (!luaValue2.isnil()) {
                return luaValue2.call(luaValue);
            }
            LuaValue luaValue3 = luaValue.tostring();
            if (!luaValue3.isnil()) {
                return luaValue3;
            }
            return tostring.valueOf(luaValue.tojstring());
        }
    }

    static final class tonumber
    extends LibFunction {
        tonumber() {
        }

        public LuaValue call(LuaValue luaValue) {
            return luaValue.tonumber();
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            if (luaValue2.isnil()) {
                return luaValue.tonumber();
            }
            int n = luaValue2.checkint();
            if (n < 2 || n > 36) {
                tonumber.argerror(2, "base out of range");
            }
            return luaValue.checkstring().tonumber(n);
        }
    }

    static final class setmetatable
    extends LibFunction {
        setmetatable() {
        }

        public LuaValue call(LuaValue luaValue) {
            return setmetatable.argerror(2, "value");
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            LuaValue luaValue3 = luaValue.getmetatable();
            if (luaValue3 != null && !luaValue3.rawget(METATABLE).isnil()) {
                setmetatable.error("cannot change a protected metatable");
            }
            return luaValue.setmetatable(luaValue2.isnil() ? null : luaValue2.checktable());
        }
    }

    static final class select
    extends VarArgFunction {
        select() {
        }

        public Varargs invoke(Varargs varargs) {
            int n = varargs.narg() - 1;
            if (varargs.arg1().equals(select.valueOf("#"))) {
                return select.valueOf(n);
            }
            int n2 = varargs.checkint(1);
            if (n2 == 0 || n2 < -n) {
                select.argerror(1, "index out of range");
            }
            return varargs.subargs(n2 < 0 ? n + n2 + 2 : n2 + 1);
        }
    }

    static final class rawset
    extends LibFunction {
        rawset() {
        }

        public LuaValue call(LuaValue luaValue) {
            return rawset.argerror(2, "value");
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            return rawset.argerror(3, "value");
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2, LuaValue luaValue3) {
            LuaTable luaTable = luaValue.checktable();
            luaTable.rawset(luaValue2.checknotnil(), luaValue3);
            return luaTable;
        }
    }

    static final class rawlen
    extends LibFunction {
        rawlen() {
        }

        public LuaValue call(LuaValue luaValue) {
            return rawlen.valueOf(luaValue.rawlen());
        }
    }

    static final class rawget
    extends LibFunction {
        rawget() {
        }

        public LuaValue call() {
            return rawget.argerror(1, "value");
        }

        public LuaValue call(LuaValue luaValue) {
            return rawget.argerror(2, "value");
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            return luaValue.checktable().rawget(luaValue2);
        }
    }

    static final class rawequal
    extends LibFunction {
        rawequal() {
        }

        public LuaValue call() {
            return rawequal.argerror(1, "value");
        }

        public LuaValue call(LuaValue luaValue) {
            return rawequal.argerror(2, "value");
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            return rawequal.valueOf(luaValue.raweq(luaValue2));
        }
    }

    final class print
    extends VarArgFunction {
        final BaseLib baselib;

        print(BaseLib baseLib2) {
            this.baselib = baseLib2;
        }

        public Varargs invoke(Varargs varargs) {
            LuaValue luaValue = BaseLib.this.globals.get("tostring");
            int n = varargs.narg();
            for (int i = 1; i <= n; ++i) {
                if (i > 1) {
                    BaseLib.this.globals.STDOUT.write(9);
                }
                LuaString luaString = luaValue.call(varargs.arg(i)).strvalue();
                BaseLib.this.globals.STDOUT.write(luaString.m_bytes, luaString.m_offset, luaString.m_length);
            }
            BaseLib.this.globals.STDOUT.println();
            return NONE;
        }
    }

    final class pcall
    extends VarArgFunction {
        pcall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Varargs invoke(Varargs varargs) {
            LuaValue luaValue = varargs.checkvalue(1);
            if (BaseLib.this.globals != null && BaseLib.this.globals.debuglib != null) {
                BaseLib.this.globals.debuglib.onCall(this);
            }
            try {
                Varargs varargs2 = BaseLib.this.pcall(luaValue, varargs.subargs(2), null);
                return varargs2;
            }
            finally {
                if (BaseLib.this.globals != null && BaseLib.this.globals.debuglib != null) {
                    BaseLib.this.globals.debuglib.onReturn();
                }
            }
        }
    }

    final class loadfile
    extends VarArgFunction {
        loadfile() {
        }

        public Varargs invoke(Varargs varargs) {
            varargs.argcheck(varargs.isstring(1) || varargs.isnil(1), 1, "filename must be string or nil");
            String string = varargs.isstring(1) ? varargs.tojstring(1) : null;
            String string2 = varargs.optjstring(2, "bt");
            LuaValue luaValue = varargs.optvalue(3, BaseLib.this.globals);
            return string == null ? BaseLib.this.loadStream(BaseLib.this.globals.STDIN, "=stdin", string2, luaValue) : BaseLib.this.loadFile(string, string2, luaValue);
        }
    }

    final class load
    extends VarArgFunction {
        load() {
        }

        public Varargs invoke(Varargs varargs) {
            LuaValue luaValue = varargs.arg1();
            varargs.argcheck(luaValue.isstring() || luaValue.isfunction(), 1, "ld must be string or function");
            String string = varargs.optjstring(2, luaValue.isstring() ? luaValue.tojstring() : "=(load)");
            String string2 = varargs.optjstring(3, "bt");
            LuaValue luaValue2 = varargs.optvalue(4, BaseLib.this.globals);
            return BaseLib.this.loadStream(luaValue.isstring() ? luaValue.strvalue().toInputStream() : new StringInputStream(luaValue.checkfunction()), string, string2, luaValue2);
        }
    }

    static final class getmetatable
    extends LibFunction {
        getmetatable() {
        }

        public LuaValue call() {
            return getmetatable.argerror(1, "value");
        }

        public LuaValue call(LuaValue luaValue) {
            LuaValue luaValue2 = luaValue.getmetatable();
            return luaValue2 != null ? luaValue2.rawget(METATABLE).optvalue(luaValue2) : NIL;
        }
    }

    static final class error
    extends TwoArgFunction {
        error() {
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            throw new LuaError(luaValue.isnil() ? null : luaValue.tojstring(), luaValue2.optint(1));
        }
    }

    final class dofile
    extends VarArgFunction {
        dofile() {
        }

        public Varargs invoke(Varargs varargs) {
            varargs.argcheck(varargs.isstring(1) || varargs.isnil(1), 1, "filename must be string or nil");
            String string = varargs.isstring(1) ? varargs.tojstring(1) : null;
            Varargs varargs2 = string == null ? BaseLib.this.loadStream(BaseLib.this.globals.STDIN, "=stdin", "bt", BaseLib.this.globals) : BaseLib.this.loadFile(varargs.checkjstring(1), "bt", BaseLib.this.globals);
            return varargs2.isnil(1) ? dofile.error(varargs2.tojstring(2)) : varargs2.arg1().invoke();
        }
    }

    static final class collectgarbage
    extends VarArgFunction {
        collectgarbage() {
        }

        public Varargs invoke(Varargs varargs) {
            String string = varargs.checkjstring(1);
            if ("collect".equals(string)) {
                System.gc();
                return ZERO;
            }
            if ("count".equals(string)) {
                Runtime runtime = Runtime.getRuntime();
                long l = runtime.totalMemory() - runtime.freeMemory();
                return collectgarbage.varargsOf(collectgarbage.valueOf((double)l / 1024.0), (Varargs)collectgarbage.valueOf(l % 1024L));
            }
            if ("step".equals(string)) {
                System.gc();
                return LuaValue.TRUE;
            }
            this.argerror("gc op");
            return NIL;
        }
    }

    static final class _assert
    extends VarArgFunction {
        _assert() {
        }

        public Varargs invoke(Varargs varargs) {
            if (!varargs.arg1().toboolean()) {
                _assert.error(varargs.narg() > 1 ? varargs.optjstring(2, "assertion failed!") : "assertion failed!");
            }
            return varargs;
        }
    }
}

