/*
 * Decompiled with CFR 0.152.
 */
package tcg;

import java.util.LinkedList;
import java.util.List;
import org.luaj.vm2.LuaClosure;
import tcg.Aura;
import tcg.Game;
import tcg.Player;
import tcg.Stat;

public abstract class Character {
    Game game;
    public String name;
    public int attack;
    public int health;
    public int maxHealth;
    public int armor = 0;
    public int attackCount = 0;
    protected int frozen = 0;
    public boolean windfury = false;
    public boolean divineShield = false;
    public boolean stealth = false;
    public Player owner;
    public Player controller;
    List<Aura> auras = new LinkedList<Aura>();

    public Character(Game game) {
        this.game = game;
    }

    protected void onDamage(Object source) {
        for (Aura a : this.getAuras()) {
            this.game.invoke(a.onDamage, source);
        }
    }

    protected void onDamageDealt(Object source, Object other) {
        for (Aura a : this.getAuras()) {
            this.game.invoke(a.onDamageDealt, source, other);
        }
    }

    protected void onStartOfTurn(Object source) {
        for (Aura a : this.getAuras()) {
            this.game.invoke(a.onStartOfTurn, source);
        }
    }

    protected void onEndOfTurn(Object source) {
        for (Aura a : this.getAuras()) {
            this.game.invoke(a.onEndOfTurn, source);
        }
    }

    protected void onDeath(Object source) {
        for (Aura a : this.getAuras()) {
            this.game.invoke(a.onDeath, source);
        }
    }

    protected void onCast(Object source) {
        for (Aura a : this.getAuras()) {
            this.game.invoke(a.onCast, source);
        }
    }

    protected void onHeal(Object source) {
        for (Aura a : this.getAuras()) {
            this.game.invoke(a.onHeal, source);
        }
    }

    protected void onDraw(Object source) {
        for (Aura a : this.getAuras()) {
            this.game.invoke(a.onDraw, source);
        }
    }

    public Aura addAura(String stat, int amount, boolean expires) {
        Aura a = new Aura(this, Stat.valueOf(stat), amount, expires);
        this.auras.add(a);
        return a;
    }

    public Aura addAura(String stat, LuaClosure calculation, boolean expires) {
        Aura a = new Aura(this, Stat.valueOf(stat), calculation, expires);
        this.auras.add(a);
        return a;
    }

    public Aura addGlobalAura(String stat, int amount, boolean expires) {
        Aura a = new Aura(this, Stat.valueOf(stat), amount, expires);
        this.game.globalAuras.add(a);
        return a;
    }

    public Aura addGlobalAura(String stat, LuaClosure calculation, boolean expires) {
        Aura a = new Aura(this, Stat.valueOf(stat), calculation, expires);
        this.game.globalAuras.add(a);
        return a;
    }

    protected LinkedList<Aura> getAuras() {
        LinkedList<Aura> l = new LinkedList<Aura>();
        l.addAll(this.auras);
        l.addAll(this.game.globalAuras);
        return l;
    }

    protected List<Aura> aurasByStat(Stat stat) {
        LinkedList<Aura> l = new LinkedList<Aura>();
        for (Aura a : this.getAuras()) {
            if (a.stat != stat) continue;
            l.add(a);
        }
        return l;
    }

    protected int sumByStat(Stat stat) {
        int s = 0;
        for (Aura a : this.aurasByStat(stat)) {
            s += a.amountFor(this);
        }
        return s;
    }

    public int getAttack() {
        return Math.max(0, this.attack + this.sumByStat(Stat.ATTACK));
    }

    public int getHealth() {
        return Math.max(0, this.health + this.sumByStat(Stat.HEALTH));
    }

    public boolean damaged() {
        return this.getHealth() < this.maxHealth;
    }

    public boolean combatDamage(int d) {
        if (d <= 0) {
            return false;
        }
        if (this.divineShield) {
            this.divineShield = false;
            return false;
        }
        int migitation = Math.min(d, this.armor);
        this.armor -= migitation;
        this.health -= (d -= migitation);
        return d > 0;
    }

    public void damage(int d) {
        if (d <= 0) {
            return;
        }
        boolean b = this.combatDamage(d);
        if (!b) {
            return;
        }
        this.onDamage(this);
        this.game.postDamage();
    }

    public void destroy() {
        this.health = 0;
        this.game.postDamage();
    }

    public void heal(int d) {
        if ((d = Math.min(d, Math.max(this.maxHealth - this.getHealth(), 0))) > 0) {
            this.health += d;
            this.onHeal(this);
        }
    }

    public void gain(int a, int h) {
        this.attack += a;
        this.health += h;
    }

    public void freeze() {
        System.out.println("freeze " + this);
        this.freeze(1);
    }

    public void freeze(int turns) {
        this.frozen = Math.max(turns, this.frozen);
    }

    public boolean frozen() {
        return this.frozen > 0;
    }

    public void unfreeze() {
        if (this.frozen > 0) {
            --this.frozen;
        }
    }
}

