/*
 * Decompiled with CFR 0.152.
 */
package tcg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.Varargs;
import tcg.Aura;
import tcg.Character;
import tcg.GameState;
import tcg.Minion;
import tcg.Option;
import tcg.Player;
import tcg.Stat;

public class Game {
    public static final int MAXIMUM_BOARD_SIZE = 7;
    public static final int MAXIMUM_HAND_SIZE = 10;
    public ArrayList<Player> players = new ArrayList();
    int current = 0;
    public GameState state = GameState.CAST_SPELL;
    public Object self;
    public Object other;
    List<Aura> globalAuras = new LinkedList<Aura>();
    List<Option> options = new LinkedList<Option>();
    public int minionsPlayed = 0;
    public LuaFunction filter;
    public LuaFunction onTarget;
    public int spellCount = 0;
    LinkedList<Stack> stack = new LinkedList();

    public List<Aura> aurasByStat(Stat stat) {
        LinkedList<Aura> l = new LinkedList<Aura>();
        for (Aura a : this.globalAuras) {
            if (a.stat != stat) continue;
            l.add(a);
        }
        return l;
    }

    public int sumByStat(Stat stat) {
        int s = 0;
        for (Aura a : this.aurasByStat(stat)) {
            s += a.amountFor(this);
        }
        return s;
    }

    public void start() {
        this.current = 0;
        this.currentPlayer().opponent = this.currentOpponent();
        this.currentOpponent().opponent = this.currentPlayer();
        for (Player p : this.players) {
            int i = 0;
            while (i < 4) {
                p.draw();
                ++i;
            }
        }
        ++this.currentPlayer().maxMana;
        ++this.currentPlayer().mana;
    }

    public Player currentPlayer() {
        return this.players.get(this.current);
    }

    public Player currentOpponent() {
        return this.players.get((this.current + 1) % this.players.size());
    }

    public void endTurn() {
        LinkedList<Character> l = new LinkedList<Character>();
        for (Player p2 : this.players) {
            l.add(p2);
            for (Minion m : p2.board) {
                l.add(m);
            }
        }
        for (Character c : l) {
            if (c.controller == this.currentPlayer()) {
                c.unfreeze();
            }
            c.onEndOfTurn(c);
            LinkedList<Aura> remove = new LinkedList<Aura>();
            for (Aura a : this.globalAuras) {
                if (!a.expires) continue;
                remove.add(a);
            }
            for (Aura a : remove) {
                this.globalAuras.remove(a);
            }
            remove.clear();
            for (Aura a : c.auras) {
                if (!a.expires) continue;
                remove.add(a);
            }
            for (Aura a : remove) {
                c.auras.remove(a);
            }
        }
        this.current = (this.current + 1) % this.players.size();
        this.spellCount = 0;
        this.minionsPlayed = 0;
        Player p = this.currentPlayer();
        if (p.maxMana < 10) {
            ++p.maxMana;
        }
        p.mana = p.maxMana;
        p.attackCount = 0;
        for (Minion m : p.board) {
            m.sick = false;
            m.attackCount = 0;
        }
        p.abilityUsed = false;
        p.draw();
        l = new LinkedList();
        for (Player p2 : this.players) {
            l.add(p2);
            for (Minion m : p2.board) {
                l.add(m);
            }
        }
        for (Character c : l) {
            c.onStartOfTurn(c);
        }
    }

    public void combat(Character attacker, Character defender) {
        ++attacker.attackCount;
        attacker.stealth = false;
        int a1 = attacker.getAttack();
        int a2 = defender.getAttack();
        if (a1 > 0) {
            attacker.onDamageDealt(defender, attacker);
            defender.combatDamage(a1);
            defender.onDamage(defender);
        }
        if (a2 > 0) {
            defender.onDamageDealt(attacker, defender);
            attacker.combatDamage(a2);
            attacker.onDamage(attacker);
        }
        this.postDamage();
        if (attacker instanceof Player) {
            ((Player)attacker).durabilityLoss();
        }
    }

    public void postDamage() {
        for (Player p : this.players) {
            LinkedList<Minion> dead = new LinkedList<Minion>();
            for (Minion m : p.board) {
                if (m.getHealth() > 0) continue;
                dead.add(m);
            }
            for (Minion m : dead) {
                p.board.remove(m);
                m.onDeath(m);
            }
        }
    }

    public List<Character> validTargets(LuaFunction filter) {
        LinkedList<Character> targets = new LinkedList<Character>();
        for (Player p : this.players) {
            if ("true".equals(this.invoke(filter, p).toString())) {
                targets.add(p);
            }
            for (Minion m : p.board) {
                if (!"true".equals(this.invoke(filter, m).toString())) continue;
                targets.add(m);
            }
        }
        return targets;
    }

    public int countTargets(LuaFunction filter) {
        return this.validTargets(filter).size();
    }

    public void chooseTarget(LuaFunction filter, LuaFunction handler) {
        if (this.countTargets(filter) == 0) {
            return;
        }
        this.filter = filter;
        this.onTarget = handler;
        this.state = GameState.TARGET;
    }

    public void forEach(LuaFunction filter, LuaFunction handler) {
        for (Character c : this.validTargets(filter)) {
            if (c.getHealth() <= 0) continue;
            this.invoke(handler, c);
        }
    }

    public void forEachRandom(int count, LuaFunction filter, LuaFunction handler) {
        List<Character> targets = this.validTargets(filter);
        Collections.shuffle(targets);
        targets = targets.subList(0, Math.min(count, targets.size()));
        for (Character c : targets) {
            if (c.getHealth() <= 0) continue;
            this.invoke(handler, c);
        }
    }

    public void forEachExceptRandom(int count, LuaFunction filter, LuaFunction handler) {
        List<Character> targets = this.validTargets(filter);
        Collections.shuffle(targets);
        targets = targets.subList(0, Math.max(0, targets.size() - count));
        for (Character c : targets) {
            if (c.getHealth() <= 0) continue;
            this.invoke(handler, c);
        }
    }

    public void chooseOne(String s1, LuaFunction h1, String s2, LuaFunction h2) {
        this.options.clear();
        this.options.add(new Option(this.self, s1, h1));
        this.options.add(new Option(this.self, s2, h2));
        this.state = GameState.CHOOSE_ONE;
    }

    public boolean combo() {
        return this.spellCount > 0;
    }

    public int random(int min, int max) {
        return (int)(Math.random() * (double)(max - min + 1)) + min;
    }

    public Varargs invoke(LuaFunction handler, Object self) {
        return this.invoke(handler, self, null);
    }

    public Varargs invoke(LuaFunction handler, Object self, Object other) {
        Varargs result = null;
        this.stack.push(new Stack(this.self, this.other));
        this.self = self;
        this.other = other;
        if (handler != null) {
            result = handler.invoke();
        }
        Stack s = this.stack.pop();
        this.self = s.self;
        this.other = s.other;
        return result;
    }

    public class Stack {
        Object self;
        Object other;

        public Stack(Object self, Object other) {
            this.self = self;
            this.other = other;
        }
    }
}

