/*
 * Decompiled with CFR 0.152.
 */
package tcg;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import tcg.Card;
import tcg.Character;
import tcg.Game;
import tcg.GameState;
import tcg.Minion;
import tcg.Option;
import tcg.Player;
import tcg.Spell;

public class GameFrame
extends JFrame {
    Game game;
    Character attacker;
    Spell spell;
    Minion hover;
    LinkedList<Target> targets = new LinkedList();
    LinkedList<Target> minions = new LinkedList();

    boolean findTarget(int x, int y) {
        for (Target t : this.targets) {
            if (t.x > x || x > t.x + t.w || t.y > y || y > t.y + t.h) continue;
            return true;
        }
        return false;
    }

    Object getTarget(int x, int y) {
        Object o = null;
        for (Target t : this.targets) {
            if (t.x > x || x > t.x + t.w || t.y > y || y > t.y + t.h) continue;
            o = t.o;
        }
        return o;
    }

    Object getMinion(int x, int y) {
        for (Target t : this.minions) {
            if (t.x > x || x > t.x + t.w || t.y > y || y > t.y + t.h) continue;
            return t.o;
        }
        return null;
    }

    public GameFrame(Game g) {
        super("Game");
        this.game = g;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        final JPanel display = new JPanel(){
            HashMap<String, Image> images = null;

            @Override
            public void paint(Graphics gr) {
                if (this.images == null) {
                    this.images = new HashMap();
                    File[] fileArray = new File("data/images").listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        if (f.getName().endsWith(".png")) {
                            this.images.put(f.getName().replace(".png", ""), new ImageIcon("data/images/" + f.getName()).getImage());
                        }
                        ++n2;
                    }
                }
                GameFrame.this.targets.clear();
                GameFrame.this.minions.clear();
                Graphics2D g = (Graphics2D)gr;
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.setColor(new Color(210, 170, 100));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                Player player = GameFrame.this.game.players.get(0);
                int y = 370;
                int x = 250;
                for (Spell spell : player.hand) {
                    this.drawSpell(g, spell, x, y + 140);
                    x += player.hand.size() < 6 ? 140 : 840 / player.hand.size();
                }
                x = 250;
                for (Minion minion : player.board) {
                    this.drawMinion(g, player, minion, x, y + 0);
                    x += 100;
                }
                this.drawMinion(g, player, null, x, y + 0);
                this.drawHero(g, player, 10, y + 70);
                player = GameFrame.this.game.players.get(1);
                y = 0;
                x = 250;
                for (Spell spell : player.hand) {
                    this.drawSpell(g, spell, x, y);
                    x += player.hand.size() < 6 ? 140 : 840 / player.hand.size();
                }
                x = 250;
                for (Minion minion : player.board) {
                    this.drawMinion(g, player, minion, x, y + 210);
                    x += 100;
                }
                this.drawMinion(g, player, null, x, y + 210);
                this.drawHero(g, player, 10, y + 60);
                g.setFont(this.getFont().deriveFont(20.0f));
                g.setColor(Color.white);
                g.drawString("End Turn", 30, 350);
                if (GameFrame.this.game.state == GameState.CAST_SPELL) {
                    g.setColor(Color.green);
                    g.drawRect(10, 320, 120, 50);
                    GameFrame.this.targets.add(new Target(10, 320, 120, 50, "end"));
                }
                if (GameFrame.this.hover != null) {
                    g.drawImage(this.getCardImage(GameFrame.this.hover.controller, null, GameFrame.this.hover.card, false), 40, 200, 217, 337, null);
                }
                if (GameFrame.this.game.state == GameState.CHOOSE_ONE) {
                    x = 300;
                    y = 400;
                    for (Option o : GameFrame.this.game.options) {
                        g.setColor(Color.black);
                        g.fillRect(x, y, 200, 30);
                        g.setColor(Color.white);
                        g.drawString(o.title, x + 20, y + 20);
                        g.setColor(Color.green);
                        g.drawRect(x, y, 200, 30);
                        GameFrame.this.targets.add(new Target(x, y, 200, 30, o));
                        y += 50;
                    }
                }
            }

            BufferedImage getCardImage(Player owner, Spell s, Card card, boolean active) {
                BufferedImage img = new BufferedImage(311, 484, 2);
                Graphics2D g = (Graphics2D)img.getGraphics();
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (card.nr == 10000) {
                    return img;
                }
                int ty = 0;
                if (card.type.equals("minion")) {
                    g.drawImage(this.images.get("cardframe_minion" + (active ? "_active" : "")), 0, 0, null);
                    if (s != null) {
                        g.drawImage(this.images.get("" + s.getCost()), 35, 75, null);
                    } else {
                        g.drawImage(this.images.get("" + card.cost), 35, 75, null);
                    }
                    g.drawImage(this.images.get("" + card.attack), 38, 368, null);
                    g.drawImage(this.images.get("" + card.health), 233, 368, null);
                    g.drawImage(this.images.get("art" + card.nr), 89, 71, null);
                    g.drawImage(this.images.get("name" + card.nr), 52, 233, null);
                    g.drawImage(this.images.get("minion_rarity_" + card.rarity), 124, 266, null);
                    if (!card.subtype.equals("")) {
                        g.drawImage(this.images.get("typeframe"), 94, 378, null);
                        g.drawImage(this.images.get("type_" + card.subtype), 94, 378, null);
                    }
                } else if (card.type.equals("spell")) {
                    g.drawImage(this.images.get("cardframe_spell" + (active ? "_active" : "")), 0, 0, null);
                    if (s != null) {
                        g.drawImage(this.images.get("" + s.getCost()), 36, 76, null);
                    } else {
                        g.drawImage(this.images.get("" + card.cost), 36, 76, null);
                    }
                    g.drawImage(this.images.get("art" + card.nr), 64, 103, null);
                    g.drawImage(this.images.get("name" + card.nr), 49, 223, null);
                    g.drawImage(this.images.get("spell_rarity_" + card.rarity), 134, 262, null);
                    ty = 14;
                } else if (card.type.equals("weapon")) {
                    g.drawImage(this.images.get("cardframe_weapon" + (active ? "_active" : "")), 0, 0, null);
                    if (s != null) {
                        g.drawImage(this.images.get("" + s.getCost()), 35, 75, null);
                    } else {
                        g.drawImage(this.images.get("" + card.cost), 35, 75, null);
                    }
                    g.drawImage(this.images.get("" + card.attack), 38, 368, null);
                    g.drawImage(this.images.get("" + card.durability), 233, 368, null);
                    g.drawImage(this.images.get("art" + card.nr), 79, 90, null);
                    g.drawImage(this.images.get("name" + card.nr), 52, 233, null);
                    g.drawImage(this.images.get("weapon_rarity_" + card.rarity), 140, 268, null);
                }
                g.setColor(Color.white);
                if (card.description.length() > 0) {
                    g.setFont(g.getFont().deriveFont(20.0f));
                    FontRenderContext frc = g.getFontRenderContext();
                    AttributedString styledText = new AttributedString(card.description);
                    styledText.addAttribute(TextAttribute.FONT, g.getFont());
                    AttributedCharacterIterator m_iterator = styledText.getIterator();
                    int m_start = m_iterator.getBeginIndex();
                    int m_end = m_iterator.getEndIndex();
                    LineBreakMeasurer measurer = new LineBreakMeasurer(m_iterator, frc);
                    measurer.setPosition(m_start);
                    float xx = 65.0f;
                    float yy = 293 + ty;
                    while (measurer.getPosition() < m_end) {
                        TextLayout layout = measurer.nextLayout(190.0f);
                        float dx = layout.getAdvance();
                        layout.draw(g, xx + (190.0f - dx) / 2.0f, yy += layout.getAscent());
                        yy += layout.getDescent() + layout.getLeading();
                    }
                }
                return img;
            }

            void drawSpell(Graphics2D gg, Spell s, int x, int y) {
                boolean active = false;
                if (GameFrame.this.game.state == GameState.CAST_SPELL && GameFrame.this.game.currentPlayer() == s.owner && s.owner.getMana() >= s.getCost()) {
                    active = true;
                    GameFrame.this.targets.add(new Target(x, y, 155, 242, s));
                }
                gg.drawImage(this.getCardImage(s.owner, s, s.card, active), x, y, 155, 242, null);
            }

            void drawMinion(Graphics2D gg, Player p, Minion m, int x, int y) {
                if (m != null) {
                    boolean active = false;
                    boolean canTarget = false;
                    if (GameFrame.this.game.state == GameState.TARGET && !m.stealth && !m.shroud) {
                        canTarget = "true".equals(GameFrame.this.game.invoke(GameFrame.this.game.filter, m).toString());
                    }
                    if (GameFrame.this.game.state == GameState.CAST_SPELL && GameFrame.this.game.currentPlayer() == m.controller && m.getAttack() > 0 && (!m.sick || m.charge) && !m.frozen() && (m.attackCount == 0 || m.windfury && m.attackCount < 2) && !m.defender || GameFrame.this.game.state == GameState.ATTACK && GameFrame.this.game.currentPlayer() != m.controller && !m.stealth && (!m.controller.hasTaunt() || m.taunt) || GameFrame.this.game.state == GameState.TARGET && canTarget) {
                        gg.setColor(Color.green);
                        if (GameFrame.this.game.state == GameState.TARGET) {
                            gg.setColor(Color.red);
                        }
                        active = true;
                        GameFrame.this.targets.add(new Target(x, y, 100, 150, m));
                    }
                    GameFrame.this.minions.add(new Target(x, y, 100, 150, m));
                    BufferedImage card = new BufferedImage(311, 484, 2);
                    Graphics2D g = (Graphics2D)card.getGraphics();
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.drawImage(this.images.get("cardframe_minion_battle" + (m.taunt ? "_taunt" : "") + (active ? "_active" : "")), 0, 0, null);
                    g.drawImage(this.images.get("art" + m.card.nr), 89, 71, null);
                    if (m.frozen()) {
                        g.drawImage(this.images.get("cardframe_minion_battle_frozen"), 0, 0, null);
                    }
                    if (m.stealth) {
                        g.drawImage(this.images.get("cardframe_minion_battle_stealth"), 0, 0, null);
                    }
                    if (m.divineShield) {
                        g.drawImage(this.images.get("cardframe_minion_battle_shield"), 0, 0, null);
                    }
                    g.drawImage(this.images.get("" + m.getAttack()), 92, 215, 33, 33, null);
                    g.drawImage(this.images.get("" + m.getHealth()), 196, 215, 33, 33, null);
                    gg.drawImage(card, x, y, 155, 242, null);
                }
                if (GameFrame.this.game.state == GameState.SUMMON && p == GameFrame.this.game.currentPlayer()) {
                    gg.setColor(Color.green);
                    gg.drawOval(x + 20, y + 70, 20, 20);
                    GameFrame.this.targets.add(new Target(x + 20, y + 70, 20, 20, m));
                }
            }

            void drawHero(Graphics2D g, Player p, int x, int y) {
                g.drawImage(this.images.get("hero_" + p.ability.hero), x, y, 138, 198, null);
                if (p.frozen()) {
                    g.drawImage(this.images.get("cardframe_minion_battle_frozen"), x, y, 138, 198, null);
                }
                g.setFont(this.getFont().deriveFont(12.0f));
                g.setColor(Color.blue);
                g.drawString(String.valueOf(p.getMana()) + " / " + p.maxMana, x + 150, y + 200);
                g.setFont(this.getFont().deriveFont(20.0f));
                g.setColor(Color.yellow);
                g.drawString("" + p.getAttack(), x + 20, y + 100);
                g.setColor(Color.red);
                g.drawString("" + p.getHealth(), x + 90, y + 100);
                g.setColor(Color.gray);
                g.drawString("" + p.armor, x + 90, y + 80);
                if (p.weapon != null) {
                    g.setColor(Color.yellow);
                    g.drawString("" + p.weapon.attack, x + 150, y + 70);
                    g.drawString("" + p.weapon.durability, x + 180, y + 70);
                }
                boolean canTarget = false;
                if (GameFrame.this.game.state == GameState.TARGET) {
                    canTarget = "true".equals(GameFrame.this.game.invoke(GameFrame.this.game.filter, p).toString());
                }
                if (GameFrame.this.game.state == GameState.CAST_SPELL && GameFrame.this.game.currentPlayer() == p && p.getAttack() > 0 && !p.frozen() && (p.attackCount == 0 || p.windfury && p.attackCount < 2) || GameFrame.this.game.state == GameState.ATTACK && GameFrame.this.game.currentPlayer() != p && !p.hasTaunt() || GameFrame.this.game.state == GameState.TARGET && canTarget) {
                    g.setColor(Color.green);
                    if (GameFrame.this.game.state == GameState.TARGET) {
                        g.setColor(Color.red);
                    }
                    g.drawRect(x, y, 138, 198);
                    GameFrame.this.targets.add(new Target(x, y, 138, 198, p));
                }
                g.setColor(Color.white);
                g.drawString("Ability", x + 160, y + 150);
                if (GameFrame.this.game.state == GameState.CAST_SPELL && GameFrame.this.game.currentPlayer() == p && !p.abilityUsed && p.getMana() >= 2) {
                    g.setColor(Color.green);
                    if (GameFrame.this.game.state == GameState.TARGET) {
                        g.setColor(Color.red);
                    }
                    g.drawRect(x + 150, y + 122, 80, 40);
                    GameFrame.this.targets.add(new Target(x + 150, y + 122, 80, 40, "ability"));
                }
            }
        };
        display.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                GameFrame.this.hover = (Minion)GameFrame.this.getMinion(e.getX(), e.getY());
                if (GameFrame.this.findTarget(e.getX(), e.getY())) {
                    display.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    display.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        display.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!GameFrame.this.findTarget(e.getX(), e.getY())) {
                    return;
                }
                Object o = GameFrame.this.getTarget(e.getX(), e.getY());
                if (GameFrame.this.game.state == GameState.CAST_SPELL) {
                    if (o.equals("end")) {
                        GameFrame.this.game.endTurn();
                    }
                    if (o.equals("ability")) {
                        GameFrame.this.game.currentPlayer().useAbility();
                    }
                    if (o instanceof Spell) {
                        if (((Spell)o).card.type.equals("minion")) {
                            GameFrame.this.spell = (Spell)o;
                            GameFrame.this.game.state = GameState.SUMMON;
                        } else {
                            GameFrame.this.game.currentPlayer().castSpell((Spell)o);
                        }
                    }
                    if (o instanceof Character) {
                        GameFrame.this.attacker = (Character)o;
                        GameFrame.this.game.state = GameState.ATTACK;
                    }
                } else if (GameFrame.this.game.state == GameState.ATTACK) {
                    if (o instanceof Character) {
                        Character defender = (Character)o;
                        GameFrame.this.game.combat(GameFrame.this.attacker, defender);
                        GameFrame.this.game.state = GameState.CAST_SPELL;
                    }
                } else if (GameFrame.this.game.state == GameState.TARGET) {
                    GameFrame.this.game.state = GameState.CAST_SPELL;
                    GameFrame.this.game.invoke(GameFrame.this.game.onTarget, o);
                } else if (GameFrame.this.game.state == GameState.SUMMON) {
                    GameFrame.this.game.state = GameState.CAST_SPELL;
                    GameFrame.this.game.currentPlayer().castSpell(GameFrame.this.spell, (Minion)o);
                } else if (GameFrame.this.game.state == GameState.CHOOSE_ONE && o instanceof Option) {
                    Option option = (Option)o;
                    GameFrame.this.game.state = GameState.CAST_SPELL;
                    GameFrame.this.game.invoke(option.handler, option.source);
                }
            }
        });
        this.getContentPane().setLayout(new GridLayout());
        this.getContentPane().add(display);
        this.setSize(1224, 786);
        this.setVisible(true);
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    display.repaint();
                    try {
                        5.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    class Target {
        int x;
        int y;
        int w;
        int h;
        Object o;

        public Target(int x, int y, int w, int h, Object o) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.o = o;
        }
    }
}

