/*
 * Decompiled with CFR 0.152.
 */
package tcg;

import java.util.LinkedList;
import org.luaj.vm2.LuaFunction;
import tcg.Aura;
import tcg.Card;
import tcg.Character;
import tcg.Player;
import tcg.Spell;
import tcg.Stat;

public class Minion
extends Character {
    public Card card;
    public boolean sick = true;
    public boolean charge = false;
    public boolean taunt = false;
    public boolean defender = false;
    public boolean shroud = false;

    public Minion(String name, int attack, int health, Card card, Player p) {
        super(p.game);
        this.card = card;
        this.name = name;
        this.attack = attack;
        this.health = health;
        this.maxHealth = health;
        if (card != null) {
            this.card = card;
            this.charge = card.charge;
            this.defender = card.defender;
            this.taunt = card.taunt;
            this.divineShield = card.divineShield;
            this.windfury = card.windfury;
            this.stealth = card.stealth;
            this.shroud = card.shroud;
        }
        this.controller = this.owner = p;
    }

    @Override
    protected void onDamage(Object source) {
        super.onDamage(source);
        this.game.invoke(this.card.onDamage, source);
    }

    @Override
    protected void onDamageDealt(Object source, Object other) {
        super.onDamageDealt(source, other);
        this.game.invoke(this.card.onDamageDealt, source, other);
    }

    @Override
    protected void onStartOfTurn(Object source) {
        super.onStartOfTurn(source);
        this.game.invoke(this.card.onStartOfTurn, source);
    }

    @Override
    protected void onEndOfTurn(Object source) {
        super.onEndOfTurn(source);
        this.game.invoke(this.card.onEndOfTurn, source);
    }

    @Override
    protected void onDeath(Object source) {
        this.removeAuras();
        super.onDeath(source);
        this.game.invoke(this.card.onDeath, source);
    }

    @Override
    protected void onHeal(Object source) {
        super.onHeal(source);
        this.game.invoke(this.card.onHeal, source);
    }

    @Override
    protected void onDraw(Object source) {
        super.onDraw(source);
        this.game.invoke(this.card.onDraw, source);
    }

    public void silence() {
    }

    public void unsummon() {
        this.controller.board.remove(this);
        this.removeAuras();
        this.owner.hand.add(new Spell(this.card, this.owner));
    }

    public void removeAuras() {
        LinkedList<Aura> remove = new LinkedList<Aura>();
        for (Aura a : this.game.globalAuras) {
            if (a.owner != this) continue;
            remove.add(a);
        }
        for (Aura a : remove) {
            this.game.globalAuras.remove(a);
        }
    }

    public boolean hasCharge() {
        if (this.sumByStat(Stat.CHARGE) > 0) {
            return true;
        }
        return this.charge;
    }

    public boolean hasWindfury() {
        if (this.sumByStat(Stat.WINDFURY) > 0) {
            return true;
        }
        return this.windfury;
    }

    public boolean adjacent(Minion m) {
        int index = this.controller.board.indexOf(this);
        int index2 = this.controller.board.indexOf(m);
        if (index2 == -1) {
            return false;
        }
        return Math.abs(index - index2) == 1;
    }

    public void forEachNeighbor(LuaFunction handler) {
        int left;
        int index = this.controller.board.indexOf(this);
        int right = index + 1;
        if (right < this.controller.board.size()) {
            this.game.invoke(handler, this.controller.board.get(right));
        }
        if ((left = index - 1) >= 0) {
            this.game.invoke(handler, this.controller.board.get(left));
        }
    }
}

