/*
 * Decompiled with CFR 0.152.
 */
package tcg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import tcg.Card;
import tcg.Character;
import tcg.Deck;
import tcg.Game;
import tcg.Minion;
import tcg.Spell;
import tcg.Stat;
import tcg.Weapon;

public class Player
extends Character {
    Deck deck;
    LinkedList<Spell> library = new LinkedList();
    public LinkedList<Spell> hand = new LinkedList();
    public ArrayList<Minion> board = new ArrayList();
    public int mana = 0;
    public int maxMana = 0;
    public Weapon weapon = null;
    public Card ability;
    public boolean abilityUsed = false;
    public Player opponent;

    public Player(Game game, Deck deck) {
        super(game);
        this.controller = this.owner = this;
        this.health = 30;
        this.maxHealth = 30;
        this.attack = 0;
        this.ability = Card.get(deck.hero);
        this.deck = deck;
        for (Card card : deck.spells) {
            this.library.add(new Spell(card, this));
        }
        Collections.shuffle(this.library);
    }

    @Override
    public int getAttack() {
        return super.getAttack() + (this.weapon != null ? this.weapon.attack : 0);
    }

    public int getMana() {
        return Math.max(0, this.mana + this.sumByStat(Stat.MANA));
    }

    public void draw() {
        if (this.library.size() > 0 && this.hand.size() < 10) {
            Spell s = this.library.pop();
            this.hand.add(s);
            this.onDraw(s);
        } else {
            System.out.println("maxmimum hand size reached");
        }
    }

    public void drawCard(String name) {
        if (this.hand.size() < 10) {
            Card c = Card.get(name);
            if (c != null) {
                this.hand.add(new Spell(Card.get(name), this));
            } else {
                System.err.println("Card " + name + " not found");
            }
        } else {
            System.out.println("maxmimum hand size reached");
        }
    }

    public void castSpell(Spell s) {
        this.castSpell(s, null);
    }

    public void castSpell(Spell s, Minion before) {
        this.mana -= s.getCost();
        this.hand.remove(s);
        if (s.card.type.equals("minion")) {
            if (this.board.size() < 7) {
                Minion m = new Minion(s.card.name, s.card.attack, s.card.health, s.card, this);
                int i = this.board.indexOf(before);
                if (i >= 0) {
                    this.board.add(i, m);
                } else {
                    this.board.add(m);
                }
                m.onCast(m);
                this.game.invoke(s.card.onCast, m);
                ++this.game.minionsPlayed;
            } else {
                System.out.println("maxmimum board size reached");
            }
        } else if (s.card.type.equals("weapon")) {
            this.weapon = new Weapon(s.card.name, s.card.attack, s.card.durability, s.card, this);
            this.onCast(s);
            this.game.invoke(s.card.onCast, this.weapon);
        } else {
            this.onCast(s);
            this.game.invoke(s.card.onCast, s);
        }
        ++this.game.spellCount;
    }

    public void summon(String name) {
        if (this.board.size() < 7) {
            Card card = Card.get(name);
            Minion m = new Minion(card.name, card.attack, card.health, card, this);
            this.board.add(m);
        } else {
            System.out.println("maxmimum board size reached");
        }
    }

    public void equip(String name) {
        Card card = Card.get(name);
        this.weapon = new Weapon(card.name, card.attack, card.durability, card, this);
    }

    public boolean hasTaunt() {
        for (Minion m : this.board) {
            if (!m.taunt) continue;
            return true;
        }
        return false;
    }

    public boolean hasWeapon() {
        return this.weapon != null;
    }

    public void durabilityLoss() {
        if (this.weapon == null || this.weapon.durabilityLoss == 0) {
            return;
        }
        this.weapon.durability -= this.weapon.durabilityLoss;
        if (this.weapon.durability == 0) {
            this.weapon = null;
        }
    }

    public void discardRandom(int c) {
        int i = 0;
        while (i < c) {
            if (this.hand.size() > 0) {
                this.hand.remove((int)(Math.random() * (double)this.hand.size()));
            }
            ++i;
        }
    }

    public void useAbility() {
        this.mana -= this.ability.cost;
        this.abilityUsed = true;
        this.game.invoke(this.ability.onCast, this);
    }
}

