Card = luajava.bindClass("tcg.Card");

local spell = Card:createSpell(150,'Adrenaline Rush', 1, 'Rogue', 'Draw a card. Combo: Draw 2 cards instead.', 'Epic');
	spell.onCast = function() this().owner:draw(); if game:combo() then this().owner:draw(); end end

local spell = Card:createSpell(200,'Ancestral Healing', 0, 'Shaman', 'Restore a minion to full health.', 'Basic');
	spell.onCast = function() game:chooseTarget(minion, function() this().health = this().maxHealth; end ); end

local spell = Card:createSpell(126,'Ancestral Spirit', 2, 'Shaman', 'Choose a minion. When that minion is destroyed, return it to the battlefield.', 'Rare');
	spell.onCast = function() game:chooseTarget(minion, function() this():addAura('NONE',0,false).onDeath = function() this().owner:summon(this().card.name); end; end); end;

local spell = Card:createSpell(195,'Arcane Explosion', 2, 'Mage', 'Deal 1 damage to all enemies.', 'Basic');
	spell.onCast = function() game:forEach(enemy, function() this():damage(1); end); end;

local spell = Card:createSpell(41,'Arcane Intellect', 3, 'Mage', 'Draw 2 cards.', 'Basic');
	spell.onCast = function() this().owner:draw(); this().owner:draw(); end;

local spell = Card:createSpell(28,'Arcane Missiles', 1, 'Mage', 'Shoot 3 missiles at random enemies for 1 damage each.', 'Basic');
	spell.onCast = function() game:forEachRandom(3, enemy, function() this():damage(1); end); end;

local spell = Card:createSpell(10000,'Arcane Shot', 1, 'Hunter', 'Deal 2 damage', 'Basic');
	spell.onCast = function() game:chooseTarget(enemy, function() this():damage(2); end ); end

local spell = Card:createSpell(10000,'Assassinate', 5, 'Rogue', 'Destroy an enemy minion.', 'Basic');
	spell.onCast = function() game:chooseTarget(enemyMinion, function() this():destroy(); end ); end

local spell = Card:createSpell(146,'Backstab', 0, 'Rogue', 'Deal 2 damage to an enemy minion.', 'Basic');
	spell.onCast = function() game:chooseTarget(enemyMinion, function() this():damage(2); end ); end

local spell = Card:createSpell(100,'Battle Rage', 2, 'Warrior', 'Draw a card for each damaged minion on the battlefield.', 'Common');
	spell.onCast = function() local source = this(); game:forEach(minion, function() if damaged() then source.owner:draw(); end end ); end

local spell = Card:createSpell(202,'Betrayal', 3, 'Rogue', 'An enemy minion deals it\'s damage to the minions next to it.', 'Common');
	spell.onCast = function() game:chooseTarget(enemyMinion, function() local source = this(); this():forEachNeighbor(function() this():damage(source:getAttack()); end); end); end;

local spell = Card:createSpell(203,'Blade Flurry', 3, 'Rogue', 'Deal your weapon\'s damage to all enemy minions.', 'Basic');
 	spell.onCast = function() if game:currentPlayer():hasWeapon() then game:forEach(enemyMinion, function() this():damage(game:currentPlayer().weapon.attack); end ); end end

local spell = Card:createSpell(157,'Bloodlust', 5, 'Shaman', 'Give your minions +3 Attack this turn.', 'Basic');
 	spell.onCast = function() game:forEach(friendlyMinion, function() this():addAura('ATTACK',3,true); end ); end

local spell = Card:createSpell(204,'Brawl', 5, 'Warrior', 'Destroy all minions except one. (chosen randomly)', 'Epic');
	spell.onCast = function() game:forEachExceptRandom(1, minion, function() this():destroy(); end); end;

local spell = Card:createSpell(117,'Chaos Bolt', 2, 'Warlock', 'Deal 2 damage to a minion. If target is a Demon, give it +2/+2 instead.', 'Common');
	spell.onCast = function() game:chooseTarget(minion, function() if this().card.subtype=='Demon' then this():gain(2,2); else this():damage(2); end end ); end

local spell = Card:createSpell(102,'Charge', 0, 'Warrior', 'Give your minions Charge this turn.', 'Basic');
	spell.onCast = function() game:forEach(friendlyMinion, function() this().charge=true; end); end;

local spell = Card:createSpell(119,'Circle of Healing', 0, 'Priest', 'Restore 4 Health to ALL minions.', 'Common');
	spell.onCast = function() game:forEach(minion, function() this():heal(4); end); end;

local spell = Card:createSpell(54,'Claw', 1, 'Druid', 'Give your hero +3 Attack this turn.', 'Basic');
 	spell.onCast = function() game:currentPlayer():addAura('ATTACK',3,true); end;

local spell = Card:createSpell(93,'Cleave', 3, 'Warrior', 'Deal 2 damage to two random enemy minions.', 'Basic');
	spell.onCast = function() game:forEachRandom(2, enemyMinion, function() this():damage(2); end); end;

local spell = Card:createSpell(151,'Cold Blood', 1, 'Rogue', 'Give a minion +2 Attack. Combo: +4 Attack instead.', 'Common');
	spell.onCast = function() game:chooseTarget(minion, function() if game:combo() then this():gain(4,0); else this():gain(2,0); end end ); end

local spell = Card:createSpell(147,'Conceal', 0, 'Rogue', 'Give a friendly minion Stealth.', 'Common');
	spell.onCast = function() game:chooseTarget(friendlyMinion, function() this().stealth = true; end ); end

local spell = Card:createSpell(152,'Deadly Poison', 1, 'Rogue', 'Your equipped weapon gets +2 Attack.', 'Basic');
	spell.onCast = function() if this().owner:hasWeapon() then this().owner.weapon.attack = this().owner.weapon.attack+2; end end

local spell = Card:createSpell(55,'Demoralizing Roar', 1, 'Druid', 'Enemy minions get -3 Attack this turn.', 'Common');
	spell.onCast = function() game:forEach(enemyMinion, function() this():addAura('ATTACK',-3,true); end ); end

local spell = Card:createSpell(123,'Divine Spirit', 2, 'Priest', 'Double a minion\'s Health.', 'Basic');
	spell.onCast = function() game:chooseTarget(minion, function() this():gain(0,this().maxHealth); end ); end

local spell = Card:createSpell(160,'Drain Life', 3, 'Warlock', 'Deal 2 damage. Restore 2 Health to your hero.', 'Basic');
	spell.onCast = function() local source = this(); game:chooseTarget(character, function() this():damage(2); source.owner:heal(2) end ); end
	
local spell = Card:createSpell(210,'Equality', 2, 'Paladin', 'Change the Health of ALL minions to 1.', 'Rare');
	spell.onCast = function() game:forEach(minion, function() this().health=1; end); end;

local spell = Card:createSpell(211,'Eviscerate', 2, 'Rogue', 'Deal 2 damage. Combo: Deal 4 damage instead.', 'Common');
	spell.onCast = function() game:chooseTarget(character, function() if game:combo() then this():damage(4); else this():damage(2); end end ); end

local spell = Card:createSpell(87,'Execute', 2, 'Warrior', 'Destroy a damaged enemy minion.', 'Basic');
	spell.onCast = function() game:chooseTarget(function() return enemyMinion() and damaged() end, function() this():destroy(); end ); end

local spell = Card:createSpell(124,'Fade', 2, 'Priest', 'Give your minions Taunt. Draw a card.', 'Common');
	spell.onCast = function() local source = this(); game:forEach(friendlyMinion, function() this().taunt=true; end); source.owner:draw(); end;

local spell = Card:createSpell(212,'Fan of Knives', 3, 'Rogue', 'Deal 1-2 damage to all enemy minions.', 'Basic');
	spell.onCast = function() game:forEach(enemyMinion, function() this():damage(game:random(1,2)); end); end;

local spell = Card:createSpell(156,'Fireball', 5, 'Mage', 'Deal 6 damage.', 'Basic');
	spell.onCast = function() game:chooseTarget(character, function() this():damage(6); end ); end

local spell = Card:createSpell(113,'Forked Lightning', 2, 'Shaman', 'Deal 2 damage to 2 random enemy minions. Overload: (1)', 'Common');
	spell.overload = 1;
	spell.onCast = function() game:forEachRandom(2, enemyMinion, function() this():damage(2); end); end;

local spell = Card:createSpell(198,'Frost Bolt', 3, 'Mage', 'Deal 3 damage to a character and Freeze it.', 'Basic');
	spell.onCast = function() game:chooseTarget(character, function() this():damage(3); this():freeze() end ); end

local spell = Card:createSpell(10000,'Frost Shock', 1, 'Shaman', 'Deal 1 damage to an enemy character and Freeze it.', 'Basic');
	spell.onCast = function() game:chooseTarget(enemy, function() this():damage(1); this():freeze() end ); end

local spell = Card:createSpell(132,'Greater Heal', 2, 'Priest', 'Restore 2 Health to a character for each card in your opponent\'s hand.', 'Rare');
	spell.onCast = function() game:chooseTarget(character, function() this():heal(2 * game:currentOpponent().hand:size()); end ); end

local spell = Card:createSpell(169,'Healing Touch', 3, 'Druid', 'Restore 8 Health.', 'Basic');
	spell.onCast = function() game:chooseTarget(character, function() this():heal(8); end ); end

local spell = Card:createSpell(118,'Hellfire', 4, 'Warlock', 'Deal 3 damage to ALL characters.', 'Basic');
	spell.onCast = function() game:forEach(character, function() this():damage(3); end); end;

local spell = Card:createSpell(95,'Heroic Strike', 2, 'Warrior', 'Give your hero +4 Attack this turn.', 'Basic');
 	spell.onCast = function() game:currentPlayer():addAura('ATTACK',4,true); end

local spell = Card:createSpell(144,'Holy Nova', 5, 'Priest', 'Deal 2 damage to all enemies. Restore 2 Health to all friendly characters.', 'Basic');
	spell.onCast = function() game:forEach(enemy, function() this():damage(2); end); game:forEach(friendly, function() this():heal(2); end); end;

local spell = Card:createSpell(121,'Holy Smite', 1, 'Priest', 'Deal 2 damage.', 'Basic');
	spell.onCast = function() game:chooseTarget(character, function() this():damage(2); end ); end

local spell = Card:createSpell(125,'Ice Lance', 1, 'Mage', 'Freeze a character. If it was already Frozen, deal 4 damage instead.', 'Common');
	spell.onCast = function() game:chooseTarget(character, function() if this():frozen() then this():damage(4); else this():freeze() end end ); end

local spell = Card:createSpell(190,'Inner Rage', 2, 'Warrior', 'Deal 1 damage to a minion. It gains +2 Attack this turn.', 'Common');
	spell.onCast = function() game:chooseTarget(minion, function() this():damage(1); this():addAura('ATTACK',2,true); end ); end

local spell = Card:createSpell(52,'Innervate', 0, 'Druid', 'Gain 2 Mana Crystals this turn only.', 'Basic');
	spell.onCast = function() this().owner:addAura('MANA',2,true); end

local spell = Card:createSpell(10000,'Kill Command', 3, 'Hunter', 'Deal 3 damage. If you have a Beast, deal 5 damage instead', 'Basic');
	spell.onCast = function() game:chooseTarget(character, function() if game:countTargets(function() return friendlyMinion() and this().card.subtype == 'Beast'; end) > 0 then this():damage(5); else this():damage(3); end end ); end

local spell = Card:createSpell(217,'Lightning Bolt', 1, 'Shaman', 'Deal 3 damage. Overload: (1)', 'Common');
	spell.overload = 1;
	spell.onCast = function() game:chooseTarget(character, function() this():damage(3); end ); end
	
local spell = Card:createSpell(56,'Mark of the Wild', 2, 'Druid', 'Give a minion Taunt and +2/+2. (+2 Attack and +2 Health)', 'Basic');
	spell.onCast = function() game:chooseTarget(minion, function() this().taunt = true; this():gain(2,2); end ); end

local spell = Card:createSpell(138,'Mass Dispel', 4, 'Priest', 'Silence all enemy minions. Draw a Card.', 'Rare');
	spell.onCast = function() this().owner:draw(); game:forEach(enemyMinion, function() this():silence() end ); end

local spell = Card:createSpell(133,'Mental Collapse', 2, 'Priest', 'Deal 1 damage to the enemy hero for each card in his hand.', 'Common');
	spell.onCast = function() game:currentOpponent():damage(game:currentOpponent().hand:size()); end

local spell = Card:createSpell(141,'Mind Blast', 3, 'Priest', 'Deal 5 damage to the enemy hero.', 'Basic');
	spell.onCast = function() game:currentOpponent():damage(5); end

local spell = Card:createSpell(53,'Moonfire', 0, 'Druid', 'Deal 1 damage.', 'Basic');
	spell.onCast = function() game:chooseTarget(character, function() this():damage(1); end ); end

local spell = Card:createSpell(219,'Mortal Strike', 4, 'Warrior', 'Deal 4 damage. If your hero has 12 or less Health, deal 8 damage instead.', 'Rare');
	spell.onCast = function() local source = this(); game:chooseTarget(character, function() if source.owner:getHealth()<=12 then this():damage(8); else this():damage(4); end end ); end

local spell = Card:createSpell(10000,'Multi-Shot', 4, 'Hunter', 'Deal 3 damage to two random enemy minions.', 'Basic');
	spell.onCast = function() game:forEachRandom(2, enemyMinion, function() this():damage(3); end); end;

local spell = Card:createSpell(142,'Penance', 3, 'Priest', 'Deal 3 damage. Restore 3 Health to your hero.', 'Common');
	spell.onCast = function() local source = this(); game:chooseTarget(character, function() this():damage(3); source.owner:heal(3) end ); end

local spell = Card:createSpell(48,'Power Overwhelming', 1, 'Warlock', 'Give a friendly minion +4/+4 until end of turn. Then, it dies. Horribly.', 'Common');
 	spell.onCast = function() game:chooseTarget(friendlyMinion, function() this():gain(4,4); this():addAura('NONE',0,true).onEndOfTurn = function() this():destroy(); end; end ); end

local spell = Card:createSpell(122,'Power Word: Shield', 1, 'Priest', 'Give a minion +3 Health.', 'Basic');
	spell.onCast = function() game:chooseTarget(minion, function() this():gain(0,3); end ); end

local spell = Card:createSpell(57,'Power of the Wild', 2, 'Druid', 'Choose One - Give your minions +1/+1; or summon a 3/2 Panther.', 'Common');

local spell = Card:createSpell(134,'Prayer of Fortitude', 2, 'Priest', 'Give your minions +1/+1 (+1 Attack/+1 Health)', 'Basic');
	spell.onCast = function() game:forEach(friendlyMinion, function() this():gain(1,1); end); end;

local spell = Card:createSpell(148,'Preparation', 0, 'Rogue', 'The next spell you cast this turn costs (2) less.', 'Epic');

local spell = Card:createSpell(192,'Rampage', 2, 'Warrior', 'Give a damaged minion +3/+3.', 'Common');
	spell.onCast = function() game:chooseTarget(function() return minion() and damaged() end, function() this():gain(3,3); end ); end

local spell = Card:createSpell(174,'Sap', 2, 'Rogue', 'Return a enemy minion to their hand.', 'Basic');
	spell.onCast = function() game:chooseTarget(minion, function() this():unsummon() end); end;

local spell = Card:createSpell(58,'Savagery', 2, 'Druid', 'Deal damage equal to your hero\'s attack to all enemy minions.', 'Rare');
	spell.onCast = function() game:forEach(enemyMinion, function() this():damage(game:currentPlayer():getAttack()); end); end;

local spell = Card:createSpell(176,'Shadow Bolt', 3, 'Warlock', 'Deal 4 damage to a minion.', 'Basic');
	spell.onCast = function() game:chooseTarget(minion, function() this():damage(4); end ); end

local spell = Card:createSpell(135,'Shadow Word: Pain', 2, 'Priest', 'Destroy a minion with 3 or less Attack', 'Basic');
	spell.onCast = function() game:chooseTarget(function() return minion() and this():getAttack() <= 3 end, function() this():destroy(); end ); end

local spell = Card:createSpell(149,'Shadowstep', 0, 'Rogue', 'Return a friendly minion to your hand.', 'Common');
	spell.onCast = function() game:chooseTarget(friendlyMinion, function() this():unsummon() end); end;

local spell = Card:createSpell(120,'Silence', 0, 'Priest', 'Silence a minion.', 'Common');
	spell.onCast = function() game:chooseTarget(minion, function() this():silence() end ); end

local spell = Card:createSpell(153,'Sinister Strike', 1, 'Rogue', 'Deal 3 damage to the enemy hero.', 'Basic');
	spell.onCast = function() game:currentOpponent():damage(3); end;

local spell = Card:createSpell(27,'Siphon Soul', 6, 'Warlock', 'Destory a minion. Restore 3 Health to your hero.', 'Rare');
	spell.onCast = function() local source = this(); game:chooseTarget(minion, function() this():destroy(); source.owner:heal(3); end ); end

local spell = Card:createSpell(46,'Soulfire', 0, 'Warlock', 'Deal 4 damage. Discard a random card.', 'Basic');
	spell.onCast = function() this().owner:discardRandom(1); game:chooseTarget(character, function() this():damage(4) end ); end

local spell = Card:createSpell(10000,'Sprint', 7, 'Rogue', 'Draw 4 cards.', 'Basic');
	spell.onCast = function() for i=1,4,1 do this().owner:draw() end end

local spell = Card:createSpell(163,'Swipe', 4, 'Druid', 'Deal 3 damage to an enemy and 1 damage to all other enemies.', 'Basic');
	spell.onCast = function() game:chooseTarget(enemy, function() local source = this(); this():damage(3); game:forEach(enemy, function() if this() ~= source then this():damage(1); end end); end ); end

local spell = Card:createSpell(171,'Twisting Nether', 8, 'Warlock', 'Destroy all Minions.', 'Epic');
	spell.onCast = function() game:forEach(minion, function() this():destroy(); end); end;

local spell = Card:createSpell(223,'Unleash the Hounds', 1, 'Hunter', 'Give your Beasts +1/+1 and Charge', 'Common');
	spell.onCast = function() game:forEach(function() return friendlyMinion() and this().card.subtype == 'Beast'; end, function() this():gain(1,1); this().charge=true; end); end;

local spell = Card:createSpell(10000,'Vanish', 6, 'Rogue', 'Return all minions to their owner\'s hand.', 'Basic');
	spell.onCast = function() game:forEach(minion, function() this():unsummon() end); end;

local spell = Card:createSpell(154,'Whirlwind', 1, 'Warrior', 'Deal 1 damage to ALL minions', 'Basic');
	spell.onCast = function() game:forEach(minion, function() this():damage(1); end); end;

local spell = Card:createSpell(59,'Wild Growth', 2, 'Druid', 'Gain an empty Mana Crystal.', 'Basic');
	spell.onCast = function() this().owner.maxMana = this().owner.maxMana+1; end;

local spell = Card:createSpell(254,'Blizzard', 5, 'Mage', 'Deal 2 damage to all enemy minions and Freeze them.', 'Common');
	spell.onCast = function() game:forEach(enemyMinion,function() this():damage(2); this():freeze(); end); end;

local spell = Card:createSpell(256,'Feral Spirit', 3, 'Shaman', 'Summon two 2/3 Spirit Wolves with Taunt. Overload: (2).', 'Rare');
	spell.overload = 2;
	spell.onCast = function() for i=1,2,1 do this().owner:summon('Spirit Wolf'); end end;
local spell = Card:createMinion(256,'Spirit Wolf', 0, 'Shaman', 'Taunt.', 2, 3, 'Common');
	spell.taunt = true;
	
local spell = Card:createSpell(259,'Mirror Image', 1, 'Mage', 'Summon two 0/1 minions with Taunt.', 'Common');
	spell.onCast = function() for i=1,2,1 do this().owner:summon('Mirror Image Minion'); end end;
local spell = Card:createMinion(259,'Mirror Image Minion', 0, 'Mage', 'Taunt.', 0, 1, 'Common');
	spell.taunt = true;
	
local spell = Card:createSpell(167,'Nourish', 5, 'Druid', 'Choose One - Gain 2 Mana Crystals; or Draw 3 cards.', 'Rare');
	spell.onCast = function() game:chooseOne(
						"Gain 2 Mana Crystals", function() this().owner.mana = this().owner.mana+2; end,
						"Draw 3 cards", function() for i=1,3,1 do this().owner:draw(); end end
					); end;

local spell = Card:createSpell(130,'Wrath', 2, 'Druid', 'Choose One - Deal 3 damage; or Deal 1 damage and draw a card.', 'Common');
	spell.onCast = function() local source = this(); game:chooseOne(
						"Deal 3 damage", function() game:chooseTarget(character,function() this():damage(3); end); end,
						"Deal 1 damage and draw a card", function() game:chooseTarget(character,function() this():damage(1); source.owner:draw() end); end
					); end;

local spell = Card:createSpell(272,'Hunter\'s Mark', 0, 'Hunter', 'Change a minion\'s Health to 1 this turn.', 'Basic');
	spell.onCast = function() game:chooseTarget(minion, function() local h = this():getHealth()-1; this():addAura('HEALTH',-h,true); end); end;

	