--[[
	Author: 	Ifko[nator]
	Date:		06.01.2019
	Version:	1.0
	
	History:
				v1.0 @ 06.01.2019 - initial implementation in FS 19
]]

FillTypeSigns = {};

function FillTypeSigns.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(FillUnit, specializations);
end;

function FillTypeSigns.registerEventListeners(vehicleType)
	local functionNames = {
		"onLoad",
		"onUpdate"
	};
	
	for _, functionName in ipairs(functionNames) do
		SpecializationUtil.registerEventListener(vehicleType, functionName, FillTypeSigns);
	end;
end;

function FillTypeSigns:onLoad(savegame)
	self.spec_fillTypeSigns = {};
	
	local specFillTypeSigns = self.spec_fillTypeSigns;
	
	specFillTypeSigns.fillTypeSigns = {};
	
	local fillTypeSignNumber = 0;
	
	while true do
		local fillTypeSignKey = "vehicle.fillTypeSigns.fillTypeSign(" .. tostring(fillTypeSignNumber) .. ")";
		
		if not hasXMLProperty(self.xmlFile, fillTypeSignKey) then
			break;
		end;
		
		local fillTypeSign = {};

		fillTypeSign.node = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile, fillTypeSignKey .. "#node"), self.i3dMappings);
		fillTypeSign.fillTypeName = string.upper(getXMLString(self.xmlFile, fillTypeSignKey .. "#fillTypeName"));
		
		if fillTypeSign.node ~= nil and fillTypeSign.fillTypeName ~= nil then
			setVisibility(fillTypeSign.node, false);
			
			table.insert(specFillTypeSigns.fillTypeSigns, fillTypeSign);
		end;
		
		fillTypeSignNumber = fillTypeSignNumber + 1;
	end;
end;

function FillTypeSigns:onUpdate(dt, isActiveForInput, isSelected)
	local specFillTypeSigns = self.spec_fillTypeSigns;
	local specFillUnit = self.spec_fillUnit;
	
	if specFillUnit ~= nil then
		for _, fillTypeSign in pairs(specFillTypeSigns.fillTypeSigns) do	
			for fillUnitIndex, fillUnit in pairs(specFillUnit.fillUnits) do
				local currentFillType = self:getFillUnitFillType(fillUnitIndex);
	
				if currentFillType ~= nil and currentFillType ~= FillType.UNKNOWN then
					local fillTypeName = string.upper(g_fillTypeManager.indexToName[currentFillType]);
					
					setVisibility(fillTypeSign.node, fillTypeName == fillTypeSign.fillTypeName);
				else
					setVisibility(fillTypeSign.node, false);
				end;
			end;
		end;
	end;
end;