Assets=
{
    Asset("ANIM", "anim/lamp.zip"),
    Asset("ANIM", "anim/bloom.zip"),
    Asset("ATLAS", "images/inventoryimages/lamp.xml"),
    Asset("IMAGE", "images/inventoryimages/lamp.tex"),
}

PrefabFiles = 
{
    "lamp",
    "bloom",
}

    local STRINGS = GLOBAL.STRINGS
    local RECIPETABS = GLOBAL.RECIPETABS
    local Recipe = GLOBAL.Recipe
    local Ingredient = GLOBAL.Ingredient
    local TECH = GLOBAL.TECH

    STRINGS.NAMES.LAMP = "Lamp"
    STRINGS.RECIPE_DESC.LAMP = "It lights your path."
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.LAMP = "It's a light"

TUNING.USER_RATE = GetModConfigData("CONSUMPTION_RATE")*TUNING.PERISH_ONE_DAY
TUNING.USER_RANGE = GetModConfigData("LIGHT_RANGE")

if (GLOBAL.PORKLAND_DLC and GLOBAL.IsDLCEnabled(GLOBAL.PORKLAND_DLC)) then

GLOBAL.ACTIONS.RUMMAGE.fn = function(act)
    local targ = act.target or act.invobject
    
    if act.doer.HUD and targ.components.container and (targ.components.container.type == "lamp" or targ.components.container.canbeopened and targ.components.container.numslots > 1) then
        if targ.components.container:IsOpen() then
            targ.components.container:Close(act.doer)
            act.doer:PushEvent("closecontainer", {container=targ})
        else
            act.doer:PushEvent("opencontainer", {container=targ})
            targ.components.container:Open(act.doer)
        end
        return true
    end
end
end
AddPrefabPostInit("lightbulb", function(inst)
    if inst.components.fuel then
    inst.components.fuel.secondaryfueltype = "LAMPFUEL"
    else
        inst:AddComponent("fuel")
        inst.components.fuel.secondaryfueltype = "LAMPFUEL"
    end
end)

AddPrefabPostInit("rainbowjellyfish", function(inst)
    if inst.components.fuel then
    inst.components.fuel.secondaryfueltype = "LAMPFUEL"
    else
        inst:AddComponent("fuel")
        inst.components.fuel.fueltype = "LAMPFUEL"
    end
end)

AddPrefabPostInit("rainbowjellyfish_dead", function(inst)
    if inst.components.fuel then
    inst.components.fuel.secondaryfueltype = "LAMPFUEL"
    else
        inst:AddComponent("fuel")
        inst.components.fuel.fueltype = "LAMPFUEL"
    end
end)

AddPrefabPostInit("fireflies", function(inst)
    if inst.components.fuel then
    inst.components.fuel.secondaryfueltype = "LAMPFUEL"
    else
        inst:AddComponent("fuel")
        inst.components.fuel.secondaryfueltype = "LAMPFUEL"
    end
end)

AddPrefabPostInit("bioluminescence", function(inst)
    if inst.components.fuel then
    inst.components.fuel.secondaryfueltype = "LAMPFUEL"
    else
        inst:AddComponent("fuel")
        inst.components.fuel.secondaryfueltype = "LAMPFUEL"
    end
end)
-- or (GLOBAL.PORKLAND_DLC and GLOBAL.IsDLCEnabled(GLOBAL.PORKLAND_DLC))
local function AddModRecipe(name, ingredients, tab, techlevel, gametype, placer, min_spacing, nounlock, numtogive, aquatic, distance)
    if (GLOBAL.CAPY_DLC and GLOBAL.IsDLCEnabled(GLOBAL.CAPY_DLC)) or (GLOBAL.PORKLAND_DLC and GLOBAL.IsDLCEnabled(GLOBAL.PORKLAND_DLC)) then
    return GLOBAL.Recipe(name, ingredients, tab, techlevel, gametype, placer, min_spacing, nounlock, numtogive, aquatic, distance)
    else
    return GLOBAL.Recipe(name, ingredients, tab, techlevel, placer, min_spacing, nounlock, numtogive)
    end
end

--local lamp_recipe = GLOBAL.Recipe("lamp",
--{ 
--    Ingredient("log", 4),
--    Ingredient("transistor", 1),
--    Ingredient("lantern", 1)
--},
--    RECIPETABS.LIGHT, TECH.SCIENCE_TWO, {GLOBAL.RECIPE_GAME_TYPE.VANILLA,GLOBAL.RECIPE_GAME_TYPE.ROG,GLOBAL.RECIPE_GAME_TYPE.PORKLAND}, "lamp_placer", 1 )
--    if lamp_recipe then
--        lamp_recipe.atlas = "images/inventoryimages/lamp.xml"
--    end

local lamp_recipe = AddModRecipe("lamp",
{ 
    Ingredient("log", 4),
    Ingredient("transistor", 1),
    Ingredient("lantern", 1)
},
    RECIPETABS.LIGHT, TECH.SCIENCE_TWO, "common", "lamp_placer", 1 )
    lamp_recipe.atlas = "images/inventoryimages/lamp.xml"

--if GLOBAL.SaveGameIndex:IsModeShipwrecked() then

--    local lamp_recipe = AddModRecipe("lamp",
--{ 
--    Ingredient("log", 4),
--    Ingredient("transistor", 1),
--    Ingredient("messagebottleempty", 1)
--},
--    RECIPETABS.LIGHT, TECH.SCIENCE_TWO, "common", "lamp_placer", 1 )
--    lamp_recipe.atlas = "images/inventoryimages/lamp.xml"

--end

--if GLOBAL.CAPY_DLC  then

--local lamp_recipe = AddModRecipe("lamp",
--{ 
--    Ingredient("log", 4),
--    Ingredient("transistor", 1),
--    Ingredient("messagebottleempty", 1)
--},
--    RECIPETABS.LIGHT, TECH.SCIENCE_TWO, "common", "lamp_placer", 1 )
--    lamp_recipe.atlas = "images/inventoryimages/lamp.xml"
--end

