local assets =
{
	Asset("ANIM", "anim/bloom.zip"),
    --Asset("INV_IMAGE", "lightbulb"),
}


local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.AnimState:SetBank("bloom")
    inst.AnimState:SetBuild("bloom")
    inst.AnimState:PlayAnimation("off",true)
    inst:AddTag("NOCLICK")
    inst:AddTag("FX")
    inst.light = inst.entity:AddLight()
  	inst.light:SetFalloff(0.5)
    inst.light:SetIntensity(0.5)
    inst.light:SetRadius(0.1)
    inst.Light:SetColour(100/255,75/255,60/255)

    inst.Light:Enable(false)
    --inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
    
    return inst
end

return Prefab( "common/objects/bloom", fn, assets) 

