require "prefabutil"

local assets =
{
	Asset("ANIM", "anim/lamp.zip"),
	Asset("ANIM", "anim/bloom.zip"),
	Asset("ANIM", "anim/ui_lamp_1x4.zip"),
}

local prefabs =
{
    
    "bloom",
    
}

local INTENSITY = .8
local FALLOFF = .33
local RADIUS = TUNING.USER_RANGE
local BULBTIME = TUNING.USER_RATE
if SaveGameIndex:IsModeShipwrecked() then
		local lamp_recipe = Recipe("lamp",
	{ 
    	Ingredient("log", 4),
    	Ingredient("transistor", 1),
    	Ingredient("messagebottleempty", 1)
	},
    	RECIPETABS.LIGHT, TECH.SCIENCE_TWO, "common", "lamp_placer", 1 )
    	lamp_recipe.atlas = "images/inventoryimages/lamp.xml"
end
--local OLD_PERISHTIME = nil
--local RADIUS = GetModConfigData("LIGHT_RANGE")
--local BULBTIME = GetModConfigData("CONSUMPTION_RATE")*TUNING.PERISH_ONE_DAY
--local BULBTIME = 100
--local COLOR = {200/255,150/255,120/255}

local widgetbuttoninfo = {
	text = "Close",
	position = Vector3(0,29,0),
	fn = function(inst)
		inst.components.container:Close()
	end,
	
	validfn = function(inst)
		return true
	end,
}

--local function OnAccept(inst, giver, item)
--	local old_item = inst.components.container:GetItemInSlot(1)
--	if item.components.perishable then
--		local pt = old_item.components.perishable:GetPercent() + item.components.perishable:GetPercent()
--		old_item.components.perishable:SetPercent(pt)
--	else
--		old_item.components.perishable:SetPercent(1)
--	end

--end

local function takefuel(inst)
	local old_item = inst.components.container:GetItemInSlot(1)
    if old_item and old_item.components.perishable then
    	old_item.components.perishable:SetPercent(1)
	end
end

--local function ShouldAcceptItem(inst, item)
--    if inst.components.container:IsEmpty() then
--        return false
--    end
--    local old_item = inst.components.container:GetItemInSlot(1)
--    if old_item.components.perishable then
--    	if (item.prefab == "lightbulb" or item.prefab == "rainbowjellyfish" or item.prefab == "rainbowjellyfish_dead" or item.prefab == "fireflies" or item.prefab == "bioluminescence") and old_item.components.perishable:GetPercent() < 1 then
--    	    return true
--    	else
--    		return false
--    	end
--	end
--end

local function freezbulb(inst)
	inst.components.container:FindItems(function(item)
			if item.components.perishable 
			then 
				--OLD_PERISHTIME = item.components.perishable.perishtime
				local per = item.components.perishable:GetPercent()
			    item.components.perishable.perishtime = BULBTIME
				item.components.perishable.perishremainingtime = item.components.perishable.perishtime*per
			end
	 	end)

end

local function resumebulb(inst)
	inst.components.container:FindItems(function(item)
			if item.components.perishable 
			then local per = item.components.perishable:GetPercent()
				if item.prefab == "lightbulb" then
			   		item.components.perishable.perishtime = TUNING.PERISH_FAST
			   	elseif item.prefab == "rainbowjellyfish" then
			   		item.components.perishable.perishtime = TUNING.PERISH_ONE_DAY * 1.5
			   	end
				item.components.perishable.perishremainingtime = item.components.perishable.perishtime*per
			end
	 	end)

end

local function onopen(inst)
    --inst.components.container:Open()
    --inst.components.container:FindItems(function(item)
	--		if item.components.perishable 
	--		then item.components.perishable.perishremainingtime = item.components.perishable.perishremainingtime*30
	--			 item.components.perishable.perishtime = item.components.perishable.perishtime*30
	--			end
	--	end)
	resumebulb(inst)
end

local function onclose(inst)
    --inst.components.container:Close()
    --local item = inst.components.container:GetItemInSlot(1)
    --if item and item.components.perishable then
    --	item.components.perishable:SetPerishTime(5)
    --end
	freezbulb(inst)
end

local function itemtest(inst, item, slot)
	if (item.prefab == "lightbulb" or item.prefab == "rainbowjellyfish") then
		return true
	end
end


local slotpos = {	
					Vector3(0,100,0), 
					
				}

local function fade_in(inst)
	--inst.AnimState:PlayAnimation("idle",true)
	--inst.fire = SpawnPrefab( "lighterfire" )
    --local follower = inst.fire.entity:AddFollower()
    --follower:FollowSymbol( inst.GUID, "snow", 180, -350, 0.1 )
    inst.bloom.AnimState:PlayAnimation("fadein")
	inst.bloom.AnimState:PushAnimation("on",true)
	inst.bloom.Light:Enable(true)
	--inst.bloom:fadein(inst.bloom)
	--inst.bloom = SpawnPrefab( "bloom" )
    --local follower = inst.bloom.entity:AddFollower()
    --follower:FollowSymbol( inst.GUID, "lantern", 0, 0, 0 )
    inst.components.fader:StopAll()
    --inst.AnimState:PlayAnimation("idle",true)
    
    --inst.AnimState:PlayAnimation("fadein")
    --inst.AnimState:PushAnimation("on", true)
    inst.Light:Enable(true)
    inst.Light:SetRadius(0)
    inst.bloom.Light:SetRadius(0)
    inst.components.fader:Fade(0, 0.5, 2, function(v) inst.bloom.Light:SetRadius(v) end)
    inst.components.fader:Fade(0, RADIUS, 2, function(v) inst.Light:SetRadius(v) end)
    
end

local function fade_out(inst)
	inst.bloom.AnimState:PlayAnimation("fadeout")
	inst.bloom.AnimState:PushAnimation("off")
	inst.bloom.Light:Enable(false)
    inst.components.fader:StopAll()
    --inst.AnimState:PlayAnimation("fadeout")
    --inst.AnimState:PushAnimation("off")
    --inst.components.fader:Fade(0.5, 0, 2, function(v) inst.bloom.Light:SetRadius(v) end, function() inst.bloom.Light:Enable(false) end)
    inst.components.fader:Fade(RADIUS, 0, 2, function(v) inst.Light:SetRadius(v) end, function() inst.Light:Enable(false) end)

end

local function UpdateState(inst)
	if inst.components.container:IsEmpty() then 
		--inst.components.trader:Disable()
		inst.components.fueled.accepting = false
	else 
		--inst.components.trader:Enable()
		inst.components.fueled.accepting = true
	end
	--inst.components.talker:Say("UpdateState")
	if inst.components.container:IsEmpty() then
			inst.components.fader:StopAll()	
			inst.Light:Enable(false)
			inst.bloom.Light:Enable(false)
			inst.bloom.AnimState:PlayAnimation("off")
			--inst.AnimState:PlayAnimation("off")
		

	elseif not inst.components.container:IsEmpty() and inst.components.machine.ison then
		--inst.components.fader:StopAll()
    	--inst.AnimState:PlayAnimation("fadein")
    	--inst.AnimState:PushAnimation("on", true)
    	--inst.Light:Enable(true)
    	--inst.Light:SetRadius(0)
    	--inst.components.fader:Fade(0, RADIUS, 2, function(v) inst.Light:SetRadius(v) end)
    	fade_in(inst)
    	inst.components.container:FindItems(function(item)
			if item.components.perishable 
			then item.components.perishable:StartPerishing()
				end
		end)
    else
    	inst.components.container:FindItems(function(item)
			if item.components.perishable 
			then item.components.perishable:StopPerishing()
				end
		end)
	end

end


local function onhammered(inst, worker)
	resumebulb(inst)
	inst.components.lootdropper:DropLoot()
	inst.components.container:DropEverything()
    SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
    inst.bloom:Remove()
	inst.bloom = nil
    inst:Remove()
    inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
end

local function onhit(inst, worker)
	
	inst.AnimState:PlayAnimation("hit")
	inst.AnimState:PushAnimation("idle",true)

end

local function onbuilt(inst)
	inst.AnimState:PlayAnimation("place")
	inst.AnimState:PushAnimation("idle",true)
	--inst.components.container.slots = {"lightbulb"}
	if not SaveGameIndex:IsModeShipwrecked() then
		inst.components.container:GiveItem(SpawnPrefab("lightbulb"))
	end
	--inst.components.container.slots = {SpawnPrefab("lightbulb")}
	inst.components.container:FindItems(function(item)
			if item.components.perishable 
			then item.components.perishable:StopPerishing()
				end
	end)
	if GetClock():IsDusk() then
    	inst.components.machine.ison = true
    elseif (GetClock():IsNight() and GetClock():GetMoonPhase() ~= "full") then
    	inst.components.machine.ison = true
    end
    if SaveGameIndex:IsModeShipwrecked() then
    	inst.bloom.AnimState:PlayAnimation("off")
		inst.bloom.Light:Enable(false)
		inst.components.fueled.accepting = false
		return
	end
		inst.components.fueled.accepting = true
	
	if not inst.components.machine.ison then
		--inst.AnimState:PushAnimation("idle")
		inst.bloom.AnimState:PlayAnimation("off")
		inst.bloom.Light:Enable(false)
	else
		inst.components.fader:StopAll()
		inst.bloom.AnimState:PlayAnimation("fadein")
		inst.bloom.AnimState:PushAnimation("on",true)
		inst.bloom.Light:Enable(true)
    	--inst.AnimState:PushAnimation("fadein")
    	--inst.AnimState:PushAnimation("on", true)
    	
    	inst.Light:Enable(true)
    	inst.Light:SetRadius(0)
    	inst:DoTaskInTime(.2, function() inst.components.fader:Fade(0, RADIUS, 2, function(v) inst.Light:SetRadius(v) end) end)
    	inst.components.container:FindItems(function(item)
			if item.components.perishable 
			then item.components.perishable:StartPerishing()
				end
		end)
    end

    freezbulb(inst)
    --inst:DoPeriodicTask(1, function() 

    --	inst.components.container:FindItems(function(item)
	--		if item.components.perishable 
	--		then 
	--		inst.components.talker:Say(tostring(item.components.perishable:GetPercent()))
	--		end
	-- 	end)

    -- end)
end



--local function snow(inst)
	--print("snow!snow!snow!")
	--inst.components.talker:Say("good~")
	--if not GetSeasonManager() then return end
	--inst.AnimState:OverrideSymbol("snow", "snow", "snow")
	--inst.AnimState:Hide("snow")
	--inst.AnimState:Hide("swap_snow3")
    --inst:AddTag("SnowCovered")
    --if GetSeasonManager().ground_snow_level < SNOW_THRESH then
	--	inst.AnimState:OverrideSymbol("snow", "", "")
	--else
	--	inst.AnimState:Show("snow")
	--end

--end
local function onsave(inst, data)
	--inst.components.container:FindItems(function(item)
	--		if item.components.perishable 
	--		then item.components.perishable:StopPerishing()
	--			end
	--		end)
	inst.components.container:FindItems(function(item)
			if item.components.perishable 
			then local per = item.components.perishable:GetPercent()
			if item.prefab == "lightbulb" then
			   		data.pt = TUNING.PERISH_FAST * per
			elseif item.prefab == "rainbowjellyfish" then
			   		data.pt = TUNING.PERISH_ONE_DAY * 1.5 * per
			end
				--data.pt = OLD_PERISHTIME*per
				--item.components.perishable.perishtime = BULBTIME
				--data.pt = item.components.perishable.perishremainingtime
			end
	 	end)
	
end

local function onload(inst, data)
	inst.AnimState:PlayAnimation("idle",true)
	--inst.bloom = SpawnPrefab( "bloom" )
    --local follower = inst.bloom.entity:AddFollower()
    --follower:FollowSymbol( inst.GUID, "lantern", 0, 0, 0 )

	if inst.components.container:IsEmpty() then
		--inst.components.trader:Disable()
		inst.components.fueled.accepting = false
	end

	if inst.components.machine.ison then
		inst.components.machine.ison = false
    	inst.components.machine:TurnOn()
    elseif not inst.components.machine.ison then
    	inst.components.container:FindItems(function(item)
		if item.components.perishable 
		then item.components.perishable:StopPerishing()
			end
		end)
    end

    inst.components.container:FindItems(function(item)
			if item.components.perishable 
			then 
				if data and data.pt then
					item.components.perishable.perishremainingtime = data.pt
				end
				--OLD_PERISHTIME = item.components.perishable.perishtime
				local per = item.components.perishable:GetPercent()
			    item.components.perishable.perishtime = BULBTIME
				item.components.perishable.perishremainingtime = item.components.perishable.perishtime*per
			end
	 	end)
    
    --inst:DoPeriodicTask(1, function() 

    --	inst.components.container:FindItems(function(item)
	--		if item.components.perishable 
	--		then 
	--		inst.components.talker:Say(tostring(item.components.perishable.perishremainingtime).."/"..tostring(item.components.perishable.perishtime).."-"..string.format("%.2f", item.components.perishable:GetPercent()))
	--		end
	--	end)

    --end)

    --inst.components.container.canbeopened = false
end

local function fn()
	
	local inst = CreateEntity()
	
	inst.entity:AddTransform()
	--inst.Transform:SetScale(1.1, 1.1, 1.1)
	inst.entity:AddAnimState()
	inst:AddTag("structure")

	inst.entity:AddLight()

	inst.entity:AddSoundEmitter()
	inst.AnimState:SetBank("lamp")
	inst.AnimState:SetBuild("lamp")
	inst.AnimState:PlayAnimation("idle",true)
	inst:AddComponent("named")
    inst.components.named:SetName("Lamp")
    --inst.Light.SetPosition(1, 1, 1)
    inst.Light:SetFalloff(FALLOFF)
    inst.Light:SetIntensity(INTENSITY)
    inst.Light:SetRadius(RADIUS)
    inst.Light:SetColour(200/255,150/255,120/255)
    
    inst.Light:Enable(false)

    --local season = inst.GetSeasonManager()
	inst:AddComponent("talker")
	inst.components.talker.fontsize = 35
    inst.components.talker.font = TALKINGFONT
    
    inst.components.talker.offset = Vector3(0,-400,0)

    --inst:AddComponent("trader")
    --inst.components.trader:SetAcceptTest(ShouldAcceptItem)
    --inst.components.trader.onaccept = OnAccept
    inst:AddComponent("fueled")
    if not SaveGameIndex:IsModeShipwrecked() then
   		inst.components.fueled.fueltype = "CAVE"
   	elseif SaveGameIndex:IsModeShipwrecked() then
    	inst.components.fueled.fueltype = "LAMPFUEL"
	end
    --inst.components.fueled:InitializeFuelLevel(360)
    --inst.components.fueled:SetDepletedFn(nofuel)
    --inst.components.fueled:SetUpdateFn(fuelupdate)
    inst.components.fueled.ontakefuelfn = takefuel
    inst.components.fueled.accepting = false
    --inst:AddComponent("fueled")
    --inst.components.fueled.fueltype = "CAVE"
    --inst.components.fueled.accepting = true

	inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(3)
    inst.components.workable:SetOnFinishCallback(onhammered)
    inst.components.workable:SetOnWorkCallback(onhit)
    inst:AddComponent("inspectable")
    inst:AddComponent("lootdropper")
    if not SaveGameIndex:IsModeShipwrecked() then
    	inst.components.lootdropper:SetLoot({"log", "log", "rope", "transistor"})
    elseif SaveGameIndex:IsModeShipwrecked() then
		inst.components.lootdropper:SetLoot({"log", "log", "messagebottleempty", "transistor"})
	end
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetPercent(0)

    --inst:AddTag("fridge")
    inst:AddComponent("container")
    inst.components.container.itemtestfn = itemtest
    inst.components.container:SetNumSlots(1)
    inst.components.container.widgetslotpos = slotpos
    inst.components.container.widgetanimbank = "ui_lamp_1x4"
    inst.components.container.widgetanimbuild = "ui_lamp_1x4"
    inst.components.container.widgetpos = Vector3(150,0,0)
    inst.components.container.side_align_tip = 100
    inst.components.container.widgetbuttoninfo = widgetbuttoninfo
    inst.components.container.acceptsstacks = false
    --inst.components.container.canbeopened = false
    inst.components.container.type = "lamp"

    inst.components.container.onopenfn = onopen
    inst.components.container.onclosefn = onclose

    inst:AddComponent("fader")
    inst:AddComponent("machine")
    --inst.components.machine.ison = false
    --inst:AddComponent("seasonmanager")
    inst.components.machine.cooldowntime = 0
    inst.components.machine.turnonfn = function()
    	if inst.components.container:IsFull() and not inst.components.machine.ison then
        	--inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
        	--inst.flies = inst:SpawnChild("flies")
        	inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
        	fade_in(inst)
        	inst.components.container:FindItems(function(item)
			if item.components.perishable 
			then item.components.perishable:StartPerishing()
				end
		end)
    	end
    end
    inst.components.machine.turnofffn = function()
    	if inst.components.container:IsFull() and inst.components.machine.ison then
        	--inst.AnimState:SetBloomEffectHandle( "" )
        	--if inst.flies then inst.flies:Remove() inst.flies = nil end
        	inst.AnimState:SetBloomEffectHandle("")
        	fade_out(inst)
        	inst.components.container:FindItems(function(item)
			if item.components.perishable 
			then item.components.perishable:StopPerishing()
				end
		end)
    	end
    end
    math.randomseed(tostring(os.time()):reverse():sub(1, 7))
    inst:ListenForEvent( "daytime", function() inst:DoTaskInTime(2+math.random(), function() inst.components.machine:TurnOff() end) end , GetWorld() )
    inst:ListenForEvent( "dusktime", function() inst:DoTaskInTime(math.random(3), function() inst.components.machine:TurnOn() end) end , GetWorld() )
    inst:ListenForEvent( "nighttime", function() if GetClock():GetMoonPhase() == "full" then inst:DoTaskInTime(2+math.random(), function() inst.components.machine:TurnOff() end) end end , GetWorld() )
    inst:ListenForEvent( "itemget", UpdateState)
    inst:ListenForEvent( "itemlose", UpdateState)
    
    --local pt = inst:GetPosition()
    --inst.flies = inst:SpawnChild("flies")
    --inst.flies.Transform:SetPosition(pt.x+2, pt.y+3, pt.z)
    --snow(inst)
    --inst.AnimState:OverrideSymbol("snow", "", "")
    --inst.AnimState:Hide("snow")
    inst.bloom = SpawnPrefab( "bloom" )
    local follower = inst.bloom.entity:AddFollower()
    follower:FollowSymbol( inst.GUID, "lantern", 0, 0, 0.05 )
    MakeSnowCovered(inst)
    inst:ListenForEvent( "onbuilt", onbuilt)
    --inst:ListenForEvent( "abc", snow(inst), GetSeasonManager())
    inst.OnLoad = onload
    inst.OnSave = onsave
	return inst
end

return
	Prefab("common/prefab/lamp", fn, assets),
	MakePlacer("common/prefab/lamp_placer", "lamp", "lamp", "preview")
  